/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli.jgit.commands;

import java.util.LinkedHashMap;
import java.util.Map;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.GitRevisionInfo;
import org.netbeans.modules.git.remote.cli.jgit.GitClassFactory;
import org.netbeans.modules.git.remote.cli.jgit.JGitRepository;
import org.netbeans.modules.git.remote.cli.jgit.commands.GitCommand;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.remotefs.versioning.api.ProcessUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.util.Cancellable;

public class CompareCommand
extends GitCommand {
    private final LinkedHashMap<VCSFileProxy, GitRevisionInfo.GitFileInfo> statuses;
    private final VCSFileProxy[] roots;
    private final String revisionFirst;
    private final String revisionSecond;
    private final ProgressMonitor monitor;

    public CompareCommand(JGitRepository repository, String revisionFirst, String revisionSecond, VCSFileProxy[] roots, GitClassFactory gitFactory, ProgressMonitor monitor) {
        super(repository, gitFactory, monitor);
        this.roots = roots;
        this.revisionFirst = revisionFirst;
        this.revisionSecond = revisionSecond;
        this.statuses = new LinkedHashMap();
        this.monitor = monitor;
    }

    @Override
    protected boolean prepareCommand() throws GitException {
        boolean exists = this.getRepository().getMetadataLocation().exists();
        if (exists) {
            this.prepare();
        }
        return exists;
    }

    public Map<VCSFileProxy, GitRevisionInfo.GitFileInfo> getFileDifferences() {
        return this.statuses;
    }

    @Override
    protected void prepare() throws GitException {
        this.setCommandsNumber(2);
        super.prepare();
        this.addArgument(0, "diff");
        this.addArgument(0, "--raw");
        this.addArgument(0, "--no-renames");
        this.addArgument(0, this.revisionFirst);
        this.addArgument(0, this.revisionSecond);
        this.addArgument(0, "--");
        this.addFiles(0, this.roots);
        this.addArgument(1, "diff");
        this.addArgument(1, "--raw");
        this.addArgument(1, "--find-renames");
        this.addArgument(1, this.revisionFirst);
        this.addArgument(1, this.revisionSecond);
        this.addArgument(1, "--");
        this.addFiles(1, this.roots);
    }

    @Override
    protected void run() throws GitException {
        block6: {
            ProcessUtils.Canceler canceled = new ProcessUtils.Canceler();
            if (this.monitor != null) {
                this.monitor.setCancelDelegate((Cancellable)canceled);
            }
            try {
                new GitCommand.Runner(canceled, 0){

                    @Override
                    public void outputParser(String output) throws GitException {
                        CompareCommand.this.parseDiffOutput(output, CompareCommand.this.statuses);
                    }
                }.runCLI();
                boolean hasDeleted = false;
                for (GitRevisionInfo.GitFileInfo info : this.statuses.values()) {
                    if (info.getStatus() != GitRevisionInfo.GitFileInfo.Status.REMOVED) continue;
                    hasDeleted = true;
                    break;
                }
                if (hasDeleted) {
                    new GitCommand.Runner(canceled, 1){

                        @Override
                        public void outputParser(String output) throws GitException {
                            CompareCommand.this.parseDiffOutput(output, CompareCommand.this.statuses);
                        }
                    }.runCLI();
                }
            }
            catch (GitException t) {
                throw t;
            }
            catch (Throwable t) {
                if (canceled.canceled()) break block6;
                throw new GitException(t);
            }
        }
    }

    private void parseDiffOutput(String output, LinkedHashMap<VCSFileProxy, GitRevisionInfo.GitFileInfo> statuses) {
        for (String line : output.split("\n")) {
            VCSFileProxy f;
            GitRevisionInfo.GitFileInfo.Status gitSt;
            if (!line.startsWith(":")) continue;
            String[] s = line.split("\\s");
            if (s.length == 6) {
                String file = s[s.length - 1];
                String st = s[s.length - 2].substring(0, 1);
                gitSt = GitRevisionInfo.GitFileInfo.Status.UNKNOWN;
                if ("A".equals(st)) {
                    gitSt = GitRevisionInfo.GitFileInfo.Status.ADDED;
                } else if ("M".equals(st)) {
                    gitSt = GitRevisionInfo.GitFileInfo.Status.MODIFIED;
                } else if ("R".equals(st)) {
                    gitSt = GitRevisionInfo.GitFileInfo.Status.RENAMED;
                } else if ("C".equals(st)) {
                    gitSt = GitRevisionInfo.GitFileInfo.Status.COPIED;
                } else if ("D".equals(st)) {
                    gitSt = GitRevisionInfo.GitFileInfo.Status.REMOVED;
                }
                f = VCSFileProxy.createFileProxy((VCSFileProxy)this.getRepository().getLocation(), (String)file);
                statuses.put(f, this.getClassFactory().createFileInfo(f, file, gitSt, null, null));
                continue;
            }
            if (s.length != 7) continue;
            String fileTo = s[s.length - 1];
            String fileFrom = s[s.length - 2];
            gitSt = GitRevisionInfo.GitFileInfo.Status.RENAMED;
            f = VCSFileProxy.createFileProxy((VCSFileProxy)this.getRepository().getLocation(), (String)fileTo);
            VCSFileProxy fOld = VCSFileProxy.createFileProxy((VCSFileProxy)this.getRepository().getLocation(), (String)fileFrom);
            statuses.put(f, this.getClassFactory().createFileInfo(f, fileTo, gitSt, fOld, fileFrom));
        }
    }
}

