/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly.config.mdb.wf10;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.MessageDestination;
import org.netbeans.modules.javaee.wildfly.WildflyDeploymentManager;
import org.netbeans.modules.javaee.wildfly.config.ResourceConfigurationHelper;
import org.netbeans.modules.javaee.wildfly.config.WildflyMessageDestination;
import org.netbeans.modules.javaee.wildfly.config.gen.wf10.JmsQueueType;
import org.netbeans.modules.javaee.wildfly.config.gen.wf10.JmsTopicType;
import org.netbeans.modules.javaee.wildfly.config.gen.wf10.MessagingDeployment;
import org.netbeans.modules.javaee.wildfly.config.gen.wf10.ServerType;
import org.netbeans.modules.javaee.wildfly.config.mdb.MessageDestinationSupport;
import org.netbeans.modules.schema2beans.BaseBean;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class MessageDestinationSupportImpl
implements MessageDestinationSupport {
    public static final String MSG_DEST_RESOURCE_NAME_WILDFLY = "-jms.xml";
    public static final String CONN_FACTORY_JNDI_NAME_JB4 = "ConnectionFactory";
    private File resourceDir;
    private MessagingDeployment destinationServiceModel;
    private File destinationsFile;
    private FileObject destinationsFO;
    private WildflyDeploymentManager dm;

    public MessageDestinationSupportImpl(File resourceDir, String moduleName) throws IOException {
        this.resourceDir = resourceDir;
        this.destinationsFile = new File(resourceDir, moduleName + MSG_DEST_RESOURCE_NAME_WILDFLY);
        this.ensureDestinationsFOExists();
        this.dm = (WildflyDeploymentManager)Lookup.getDefault().lookup(WildflyDeploymentManager.class);
    }

    private void ensureDestinationsFOExists() throws IOException {
        if (!this.destinationsFile.exists()) {
            return;
        }
        if (this.destinationsFO == null || !this.destinationsFO.isValid()) {
            this.destinationsFO = FileUtil.toFileObject((File)this.destinationsFile);
            assert (this.destinationsFO != null);
            this.destinationsFO.addFileChangeListener((FileChangeListener)new MessageDestinationFileListener());
        }
    }

    @Override
    public Set<MessageDestination> getMessageDestinations() throws ConfigurationException {
        return MessageDestinationSupportImpl.getMessageDestinations(this.getMessageDestinationModel(false));
    }

    private static Set<MessageDestination> getMessageDestinations(MessagingDeployment model) throws ConfigurationException {
        if (model == null) {
            return Collections.emptySet();
        }
        HashSet<MessageDestination> destinations = new HashSet<MessageDestination>();
        for (ServerType serverType : model.getServer()) {
            if (serverType.getJmsDestinations() == null) continue;
            JmsQueueType[] queues = serverType.getJmsDestinations().getJmsQueue();
            for (JmsQueueType jmsQueueType : serverType.getJmsDestinations().getJmsQueue()) {
                destinations.add(new WildflyMessageDestination(jmsQueueType.getName(), MessageDestination.Type.QUEUE));
            }
            for (BaseBean baseBean : serverType.getJmsDestinations().getJmsTopic()) {
                destinations.add(new WildflyMessageDestination(baseBean.getName(), MessageDestination.Type.TOPIC));
            }
        }
        return destinations;
    }

    private synchronized MessagingDeployment getMessageDestinationModel(boolean create) {
        block9: {
            try {
                if (this.destinationsFile.exists()) {
                    try {
                        if (this.destinationServiceModel == null) {
                            this.destinationServiceModel = MessagingDeployment.createGraph(this.destinationsFile);
                        }
                        break block9;
                    }
                    catch (IOException ioe) {
                        Exceptions.printStackTrace((Throwable)ioe);
                    }
                    catch (RuntimeException ioe) {}
                    break block9;
                }
                if (create) {
                    this.destinationServiceModel = new MessagingDeployment();
                    ResourceConfigurationHelper.writeFile(this.destinationsFile, this.destinationServiceModel);
                    this.ensureDestinationsFOExists();
                }
            }
            catch (IOException ce) {
                Exceptions.printStackTrace((Throwable)ce);
                this.destinationServiceModel = null;
            }
            catch (ConfigurationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                this.destinationServiceModel = null;
            }
        }
        return this.destinationServiceModel;
    }

    @Override
    public MessageDestination createMessageDestination(String name, MessageDestination.Type type) throws UnsupportedOperationException, ConfigurationException {
        DataObject destinationsDO;
        if (!this.resourceDir.exists()) {
            this.resourceDir.mkdir();
        }
        if (!this.destinationsFile.exists()) {
            this.getMessageDestinationModel(true);
        }
        try {
            destinationsDO = DataObject.find((FileObject)this.destinationsFO);
        }
        catch (DataObjectNotFoundException donfe) {
            Exceptions.printStackTrace((Throwable)donfe);
            return null;
        }
        MessagingDeployment newDestinationServiceModel = null;
        StyledDocument doc = null;
        try {
            EditorCookie editor = (EditorCookie)destinationsDO.getCookie(EditorCookie.class);
            doc = editor.getDocument();
            if (doc == null) {
                doc = editor.openDocument();
            }
            byte[] docString = doc.getText(0, doc.getLength()).getBytes();
            newDestinationServiceModel = MessagingDeployment.createGraph(new ByteArrayInputStream(docString));
        }
        catch (IOException ioe) {
            String msg = NbBundle.getMessage(MessageDestinationSupport.class, (String)"MSG_CannotUpdateFile", (Object)this.destinationsFile.getAbsolutePath());
            throw new ConfigurationException(msg, (Throwable)ioe);
        }
        catch (BadLocationException ble) {
            Logger.getLogger("global").log(Level.INFO, null, ble);
        }
        catch (RuntimeException e) {
            MessagingDeployment oldDestinationServiceModel = this.getMessageDestinationModel(true);
            if (oldDestinationServiceModel == null) {
                throw new ConfigurationException(NbBundle.getMessage(MessageDestinationSupport.class, (String)"MSG_msgdestXmlCannotParse", (Object)this.destinationsFile.getAbsolutePath()));
            }
            NotifyDescriptor.Confirmation notDesc = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(MessageDestinationSupport.class, (String)"MSG_msgdestXmlNotValid", (Object)this.destinationsFile.getAbsolutePath()), 2);
            Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)notDesc);
            if (result == NotifyDescriptor.CANCEL_OPTION) {
                return null;
            }
            newDestinationServiceModel = oldDestinationServiceModel;
        }
        WildflyMessageDestination dest = this.modifyMessageDestinationModel(newDestinationServiceModel, name, type);
        boolean modified = destinationsDO.isModified();
        ResourceConfigurationHelper.replaceDocument(doc, newDestinationServiceModel);
        if (!modified) {
            SaveCookie cookie = (SaveCookie)destinationsDO.getCookie(SaveCookie.class);
            try {
                cookie.save();
            }
            catch (IOException ioe) {
                String msg = NbBundle.getMessage(MessageDestinationSupport.class, (String)"MSG_CannotSaveFile", (Object)this.destinationsFile.getAbsolutePath());
                throw new ConfigurationException(msg, (Throwable)ioe);
            }
        }
        this.destinationServiceModel = newDestinationServiceModel;
        return dest;
    }

    private WildflyMessageDestination modifyMessageDestinationModel(MessagingDeployment model, String name, MessageDestination.Type type) throws ConfigurationException {
        if (model == null) {
            return null;
        }
        for (MessageDestination destination : MessageDestinationSupportImpl.getMessageDestinations(model)) {
            if (!name.equals(destination.getName()) || type != destination.getType()) continue;
            return null;
        }
        if (model.getServer(0) == null) {
            ServerType server = new ServerType();
            server.setJmsDestinations(server.newJmsDestinations());
            model.addServer(server);
        }
        if (type == MessageDestination.Type.QUEUE) {
            JmsQueueType queue = new JmsQueueType();
            queue.setName(name);
            model.getServer(0).getJmsDestinations().addJmsQueue(queue);
        } else if (type == MessageDestination.Type.TOPIC) {
            JmsTopicType topic = new JmsTopicType();
            topic.setName(name);
            model.getServer(0).getJmsDestinations().addJmsTopic(topic);
        }
        return new WildflyMessageDestination(name, type);
    }

    private class MessageDestinationFileListener
    extends FileChangeAdapter {
        private MessageDestinationFileListener() {
        }

        public void fileChanged(FileEvent fe) {
            assert (fe.getSource() == MessageDestinationSupportImpl.this.destinationsFO);
            MessageDestinationSupportImpl.this.destinationServiceModel = null;
        }

        public void fileDeleted(FileEvent fe) {
            assert (fe.getSource() == MessageDestinationSupportImpl.this.destinationsFO);
            MessageDestinationSupportImpl.this.destinationServiceModel = null;
        }
    }
}

