/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.platform;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.apisupport.project.api.Util;
import org.netbeans.modules.apisupport.project.ui.ApisupportAntUIUtils;
import org.netbeans.modules.apisupport.project.ui.ModuleUISettings;
import org.netbeans.modules.apisupport.project.universe.HarnessVersion;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

class HarnessUpgrader {
    private HarnessUpgrader() {
    }

    public static void checkForUpgrade() {
        if (ModuleUISettings.getDefault().getHarnessesUpgraded()) {
            return;
        }
        ModuleUISettings.getDefault().setHarnessesUpgraded(true);
        final HashSet<NbPlatform> toUpgrade = new HashSet<NbPlatform>();
        for (NbPlatform p : NbPlatform.getPlatforms()) {
            if (p.isDefault() && !p.isValid() || p.getHarnessVersion().compareTo(HarnessVersion.V50u1) >= 0 || !p.getHarnessLocation().equals(p.getBundledHarnessLocation())) continue;
            toUpgrade.add(p);
        }
        if (!toUpgrade.isEmpty()) {
            Mutex.EVENT.readAccess(new Runnable(){

                @Override
                public void run() {
                    HarnessUpgrader.promptForUpgrade(toUpgrade);
                }
            });
        }
    }

    private static void promptForUpgrade(Set<NbPlatform> platforms) {
        if (ApisupportAntUIUtils.showAcceptCancelDialog(NbBundle.getMessage(HarnessUpgrader.class, (String)"HarnessUpgrader.title"), NbBundle.getMessage(HarnessUpgrader.class, (String)"HarnessUpgrader.text"), NbBundle.getMessage(HarnessUpgrader.class, (String)"HarnessUpgrader.upgrade"), NbBundle.getMessage(HarnessUpgrader.class, (String)"HarnessUpgrader.skip"), 3)) {
            try {
                HarnessUpgrader.doUpgrade(platforms);
            }
            catch (IOException e) {
                Util.err.notify((Throwable)e);
            }
        }
    }

    private static void doUpgrade(Set<NbPlatform> platforms) throws IOException {
        NbPlatform plaf = NbPlatform.getDefaultPlatform();
        if (plaf == null) {
            return;
        }
        File defaultHarness = plaf.getHarnessLocation();
        for (NbPlatform p : platforms) {
            p.setHarnessLocation(defaultHarness);
        }
    }
}

