/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.memory;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.RowFilter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.filters.GenericFilter;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsDiff;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.MemoryResultsSnapshot;
import org.netbeans.lib.profiler.ui.Formatters;
import org.netbeans.lib.profiler.ui.memory.MemoryView;
import org.netbeans.lib.profiler.ui.swing.ExportUtils;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTableContainer;
import org.netbeans.lib.profiler.ui.swing.renderer.CheckBoxRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.HideableBarRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.JavaNameRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.NumberPercentRenderer;
import org.netbeans.modules.profiler.api.icons.Icons;

abstract class AllocTableView
extends MemoryView {
    private MemoryTableModel tableModel;
    private ProfilerTable table;
    private int nTrackedItems;
    private ClientUtils.SourceCodeSelection[] classNames;
    private int[] nTotalAllocObjects;
    private long[] totalAllocObjectsSize;
    private final Set<ClientUtils.SourceCodeSelection> selection;
    private boolean filterZeroItems = true;
    private HideableBarRenderer[] renderers;

    public AllocTableView(Set<ClientUtils.SourceCodeSelection> selection) {
        this.selection = selection;
        this.initUI();
    }

    @Override
    protected ProfilerTable getResultsComponent() {
        return this.table;
    }

    private void setData(final int _nTrackedItems, final String[] _classNames, final int[] _nTotalAllocObjects, final long[] _totalAllocObjectsSize, final boolean diff) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (AllocTableView.this.tableModel != null) {
                    AllocTableView.this.nTrackedItems = _nTrackedItems;
                    AllocTableView.access$202(AllocTableView.this, new ClientUtils.SourceCodeSelection[_classNames.length]);
                    for (int i = 0; i < AllocTableView.this.classNames.length; ++i) {
                        ((AllocTableView)AllocTableView.this).classNames[i] = new ClientUtils.SourceCodeSelection(_classNames[i], "*", null);
                    }
                    AllocTableView.access$302(AllocTableView.this, _nTotalAllocObjects);
                    AllocTableView.access$402(AllocTableView.this, _totalAllocObjectsSize);
                    long totalObjects = 0L;
                    long _totalObjects = 0L;
                    long totalBytes = 0L;
                    long _totalBytes = 0L;
                    for (int i = 0; i < AllocTableView.this.nTrackedItems; ++i) {
                        if (diff) {
                            totalObjects = Math.max(totalObjects, (long)AllocTableView.this.nTotalAllocObjects[i]);
                            _totalObjects = Math.min(_totalObjects, (long)AllocTableView.this.nTotalAllocObjects[i]);
                            totalBytes = Math.max(totalBytes, AllocTableView.this.totalAllocObjectsSize[i]);
                            _totalBytes = Math.min(_totalBytes, AllocTableView.this.totalAllocObjectsSize[i]);
                            continue;
                        }
                        totalObjects += (long)AllocTableView.this.nTotalAllocObjects[i];
                        totalBytes += AllocTableView.this.totalAllocObjectsSize[i];
                    }
                    if (diff) {
                        AllocTableView.this.renderers[0].setMaxValue(Math.max(Math.abs(totalBytes), Math.abs(_totalBytes)));
                        AllocTableView.this.renderers[1].setMaxValue(Math.max(Math.abs(totalObjects), Math.abs(_totalObjects)));
                    } else {
                        AllocTableView.this.renderers[0].setMaxValue(totalBytes);
                        AllocTableView.this.renderers[1].setMaxValue(totalObjects);
                    }
                    AllocTableView.this.renderers[0].setDiffMode(diff);
                    AllocTableView.this.renderers[1].setDiffMode(diff);
                    AllocTableView.this.tableModel.fireTableDataChanged();
                }
            }
        });
    }

    @Override
    public void setData(MemoryResultsSnapshot snapshot, GenericFilter filter, int aggregation) {
        AllocMemoryResultsSnapshot _snapshot = (AllocMemoryResultsSnapshot)snapshot;
        boolean diff = _snapshot instanceof AllocMemoryResultsDiff;
        String[] _classNames = _snapshot.getClassNames();
        int[] _nTotalAllocObjects = _snapshot.getObjectsCounts();
        long[] _totalAllocObjectsSize = _snapshot.getObjectsSizePerClass();
        int _nTrackedItems = Math.min(_snapshot.getNProfiledClasses(), _classNames.length);
        _nTrackedItems = Math.min(_nTrackedItems, _nTotalAllocObjects.length);
        if (filter == null) {
            this.filterZeroItems = !diff;
            this.setData(_nTrackedItems, _classNames, _nTotalAllocObjects, _totalAllocObjectsSize, diff);
        } else {
            this.filterZeroItems = false;
            ArrayList<String> fClassNames = new ArrayList<String>();
            ArrayList<Integer> fTotalAllocObjects = new ArrayList<Integer>();
            ArrayList<Long> fTotalAllocObjectsSize = new ArrayList<Long>();
            for (int i = 0; i < _nTrackedItems; ++i) {
                if (!filter.passes(_classNames[i].replace('.', '/'))) continue;
                fClassNames.add(_classNames[i]);
                fTotalAllocObjects.add(_nTotalAllocObjects[i]);
                fTotalAllocObjectsSize.add(_totalAllocObjectsSize[i]);
            }
            int trackedItems = fClassNames.size();
            String[] aClassNames = fClassNames.toArray(new String[0]);
            int[] aTotalAllocObjects = new int[trackedItems];
            for (int i = 0; i < trackedItems; ++i) {
                aTotalAllocObjects[i] = (Integer)fTotalAllocObjects.get(i);
            }
            long[] aTotalAllocObjectsSize = new long[trackedItems];
            for (int i = 0; i < trackedItems; ++i) {
                aTotalAllocObjectsSize[i] = (Long)fTotalAllocObjectsSize.get(i);
            }
            this.setData(trackedItems, aClassNames, aTotalAllocObjects, aTotalAllocObjectsSize, diff);
        }
    }

    @Override
    public void resetData() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AllocTableView.this.nTrackedItems = 0;
                AllocTableView.access$202(AllocTableView.this, null);
                AllocTableView.access$302(AllocTableView.this, null);
                AllocTableView.access$402(AllocTableView.this, null);
                AllocTableView.this.renderers[0].setMaxValue(0L);
                AllocTableView.this.renderers[1].setMaxValue(0L);
                AllocTableView.this.renderers[0].setDiffMode(false);
                AllocTableView.this.renderers[1].setDiffMode(false);
                AllocTableView.this.tableModel.fireTableDataChanged();
            }
        });
    }

    @Override
    public void showSelectionColumn() {
        this.table.setColumnVisibility(0, true);
    }

    @Override
    public void refreshSelection() {
        this.tableModel.fireTableDataChanged();
    }

    @Override
    public ExportUtils.ExportProvider[] getExportProviders() {
        ExportUtils.ExportProvider[] exportProviderArray;
        if (this.table.getRowCount() == 0) {
            exportProviderArray = null;
        } else {
            ExportUtils.ExportProvider[] exportProviderArray2 = new ExportUtils.ExportProvider[4];
            exportProviderArray2[0] = new ExportUtils.CSVExportProvider(this.table);
            exportProviderArray2[1] = new ExportUtils.HTMLExportProvider(this.table, EXPORT_ALLOCATED);
            exportProviderArray2[2] = new ExportUtils.XMLExportProvider(this.table, EXPORT_ALLOCATED);
            exportProviderArray = exportProviderArray2;
            exportProviderArray2[3] = new ExportUtils.PNGExportProvider(this.table);
        }
        return exportProviderArray;
    }

    @Override
    protected abstract void performDefaultAction(ClientUtils.SourceCodeSelection var1);

    protected abstract void populatePopup(JPopupMenu var1, Object var2, ClientUtils.SourceCodeSelection var3);

    protected void popupShowing() {
    }

    protected void popupHidden() {
    }

    private void initUI() {
        String[] stringArray;
        final int offset = this.selection == null ? -1 : 0;
        this.tableModel = new MemoryTableModel();
        this.table = new ProfilerTable(this.tableModel, true, true, null){

            public ClientUtils.SourceCodeSelection getUserValueForRow(int row) {
                return AllocTableView.this.getUserValueForRow(row);
            }

            @Override
            protected void populatePopup(JPopupMenu popup, Object value, Object userValue) {
                AllocTableView.this.populatePopup(popup, value, (ClientUtils.SourceCodeSelection)userValue);
            }

            @Override
            protected void popupShowing() {
                AllocTableView.this.popupShowing();
            }

            @Override
            protected void popupHidden() {
                AllocTableView.this.popupHidden();
            }
        };
        if (this.selection == null) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = NAME_COLUMN_TOOLTIP;
            stringArray2[1] = ALLOC_SIZE_COLUMN_TOOLTIP;
            stringArray = stringArray2;
            stringArray2[2] = ALLOC_COUNT_COLUMN_TOOLTIP;
        } else {
            String[] stringArray3 = new String[4];
            stringArray3[0] = SELECTED_COLUMN_TOOLTIP;
            stringArray3[1] = NAME_COLUMN_TOOLTIP;
            stringArray3[2] = ALLOC_SIZE_COLUMN_TOOLTIP;
            stringArray = stringArray3;
            stringArray3[3] = ALLOC_COUNT_COLUMN_TOOLTIP;
        }
        this.table.setColumnToolTips(stringArray);
        this.table.providePopupMenu(true);
        this.installDefaultAction();
        this.table.setMainColumn(1 + offset);
        this.table.setFitWidthColumn(1 + offset);
        this.table.setSortColumn(2 + offset);
        this.table.setDefaultSortOrder(1 + offset, SortOrder.ASCENDING);
        if (this.selection != null) {
            this.table.setColumnVisibility(0, false);
        }
        this.table.addRowFilter(new RowFilter(){

            public boolean include(RowFilter.Entry entry) {
                return !AllocTableView.this.filterZeroItems || ((Number)entry.getValue(3 + offset)).intValue() > 0;
            }
        });
        this.renderers = new HideableBarRenderer[2];
        this.renderers[0] = new HideableBarRenderer(new NumberPercentRenderer(Formatters.bytesFormat()));
        this.renderers[1] = new HideableBarRenderer(new NumberPercentRenderer());
        this.renderers[0].setMaxValue(123456789L);
        this.renderers[1].setMaxValue(12345678L);
        if (this.selection != null) {
            this.table.setColumnRenderer(0, new CheckBoxRenderer());
        }
        this.table.setColumnRenderer(1 + offset, new JavaNameRenderer(Icons.getIcon((String)"LanguageIcons.Class")));
        this.table.setColumnRenderer(2 + offset, this.renderers[0]);
        this.table.setColumnRenderer(3 + offset, this.renderers[1]);
        if (this.selection != null) {
            int w = new JLabel((String)this.table.getColumnName((int)0)).getPreferredSize().width;
            this.table.setDefaultColumnWidth(0, w + 15);
        }
        this.table.setDefaultColumnWidth(2 + offset, this.renderers[0].getOptimalWidth());
        this.table.setDefaultColumnWidth(3 + offset, this.renderers[1].getMaxNoBarWidth());
        ProfilerTableContainer tableContainer = new ProfilerTableContainer(this.table, false, null);
        this.setLayout(new BorderLayout());
        this.add((Component)tableContainer, "Center");
    }

    @Override
    protected ClientUtils.SourceCodeSelection getUserValueForRow(int row) {
        if (this.nTrackedItems == 0 || row == -1) {
            return null;
        }
        if (row >= this.tableModel.getRowCount()) {
            return null;
        }
        return this.classNames[this.table.convertRowIndexToModel(row)];
    }

    static /* synthetic */ ClientUtils.SourceCodeSelection[] access$202(AllocTableView x0, ClientUtils.SourceCodeSelection[] x1) {
        x0.classNames = x1;
        return x1;
    }

    static /* synthetic */ int[] access$302(AllocTableView x0, int[] x1) {
        x0.nTotalAllocObjects = x1;
        return x1;
    }

    static /* synthetic */ long[] access$402(AllocTableView x0, long[] x1) {
        x0.totalAllocObjectsSize = x1;
        return x1;
    }

    private class MemoryTableModel
    extends AbstractTableModel {
        private MemoryTableModel() {
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (AllocTableView.this.selection == null) {
                ++columnIndex;
            }
            if (columnIndex == 1) {
                return MemoryView.COLUMN_NAME;
            }
            if (columnIndex == 2) {
                return MemoryView.COLUMN_ALLOCATED_BYTES;
            }
            if (columnIndex == 3) {
                return MemoryView.COLUMN_ALLOCATED_OBJECTS;
            }
            if (columnIndex == 0) {
                return MemoryView.COLUMN_SELECTED;
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (AllocTableView.this.selection == null) {
                ++columnIndex;
            }
            if (columnIndex == 1) {
                return String.class;
            }
            if (columnIndex == 2) {
                return Long.class;
            }
            if (columnIndex == 3) {
                return Integer.class;
            }
            if (columnIndex == 0) {
                return Boolean.class;
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return AllocTableView.this.nTrackedItems;
        }

        @Override
        public int getColumnCount() {
            return AllocTableView.this.selection == null ? 3 : 4;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (AllocTableView.this.nTrackedItems == 0) {
                return null;
            }
            if (AllocTableView.this.selection == null) {
                ++columnIndex;
            }
            if (columnIndex == 1) {
                return AllocTableView.this.classNames[rowIndex].getClassName();
            }
            if (columnIndex == 2) {
                return AllocTableView.this.totalAllocObjectsSize[rowIndex];
            }
            if (columnIndex == 3) {
                return AllocTableView.this.nTotalAllocObjects[rowIndex];
            }
            if (columnIndex == 0) {
                if (AllocTableView.this.selection.isEmpty()) {
                    return Boolean.FALSE;
                }
                return AllocTableView.this.selection.contains(AllocTableView.this.classNames[rowIndex]);
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (AllocTableView.this.selection == null) {
                ++columnIndex;
            }
            if (columnIndex == 0) {
                if (Boolean.FALSE.equals(aValue)) {
                    AllocTableView.this.selection.remove(AllocTableView.this.classNames[rowIndex]);
                } else {
                    AllocTableView.this.selection.add(AllocTableView.this.classNames[rowIndex]);
                }
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (AllocTableView.this.selection == null) {
                ++columnIndex;
            }
            return columnIndex == 0;
        }
    }
}

