/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.wizard;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.api.jaxws.project.config.Endpoint;
import org.netbeans.modules.websvc.api.jaxws.project.config.Endpoints;
import org.netbeans.modules.websvc.api.jaxws.project.config.EndpointsProvider;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModel;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModelListener;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModeler;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlPort;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlService;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.websvc.wsitconf.spi.WsitProvider;
import org.netbeans.modules.websvc.wsitconf.util.GenerationUtils;
import org.netbeans.modules.websvc.wsitconf.util.Util;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class STSWizardCreator {
    protected static final int JSE_PROJECT_TYPE = 0;
    protected static final int WEB_PROJECT_TYPE = 1;
    protected static final int EJB_PROJECT_TYPE = 2;
    public static final String STS_WEBSERVICE = "sts-webservice";
    private int projectType;
    private Project project;
    private WizardDescriptor wiz;
    public boolean wsitSupported;
    public boolean jsr109Supported;
    private static final Logger logger = Logger.getLogger(STSWizardCreator.class.getName());

    public STSWizardCreator(Project project, WizardDescriptor wiz) {
        this.project = project;
        this.wiz = wiz;
    }

    public STSWizardCreator(Project project) {
        this.project = project;
    }

    public void createSTS() {
        final ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(STSWizardCreator.class, (String)"TXT_StsGeneration"));
        this.initProjectInfo(this.project);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    handle.start(100);
                    STSWizardCreator.this.generateWsFromWsdl15(handle);
                }
                catch (Exception e) {
                    handle.finish();
                    String message = e.getLocalizedMessage();
                    if (message != null) {
                        logger.log(Level.INFO, null, e);
                        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)message, 0);
                        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
                    }
                    logger.log(Level.INFO, null, e);
                }
            }
        };
        RequestProcessor.getDefault().post(r);
    }

    private void initProjectInfo(Project project) {
        J2eeModuleProvider provider;
        WsitProvider wsitProvider = (WsitProvider)project.getLookup().lookup(WsitProvider.class);
        if (wsitProvider != null) {
            this.jsr109Supported = wsitProvider.isJsr109Project();
            this.wsitSupported = wsitProvider.isWsitSupported();
        }
        if ((provider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class)) != null) {
            J2eeModule.Type moduleType = provider.getJ2eeModule().getType();
            if (J2eeModule.Type.EJB.equals(moduleType)) {
                this.projectType = 2;
            } else if (J2eeModule.Type.WAR.equals(moduleType)) {
                this.projectType = 1;
                Util.checkMetroRtLibrary(project, false);
            } else {
                this.projectType = J2eeModule.Type.CAR.equals(moduleType) ? 3 : 0;
            }
        } else {
            WebModule wm = WebModule.getWebModule((FileObject)project.getProjectDirectory());
            EjbJar em = EjbJar.getEjbJar((FileObject)project.getProjectDirectory());
            this.projectType = wm != null ? 1 : (em != null ? 2 : 0);
        }
    }

    private void generateWsFromWsdl15(final ProgressHandle handle) throws Exception {
        String wsdlFilePath = (String)this.wiz.getProperty("wsdlFilePath");
        File normalizedWsdlFilePath = FileUtil.normalizeFile((File)new File(wsdlFilePath));
        final URL wsdlURL = normalizedWsdlFilePath.toURI().toURL();
        final WsdlService service = (WsdlService)this.wiz.getProperty("wsdlService");
        if (service == null) {
            handle.finish();
            return;
        }
        final WsdlPort port = (WsdlPort)this.wiz.getProperty("wsdlPort");
        WsdlModeler wsdlModeler = (WsdlModeler)this.wiz.getProperty("wsdlModeler");
        wsdlModeler.generateWsdlModel(new WsdlModelListener(){

            public void modelCreated(WsdlModel model) {
                WsdlService service1 = model.getServiceByName(service.getName());
                WsdlPort port1 = service1.getPortByName(port.getName());
                port1.setSOAPVersion(port.getSOAPVersion());
                FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)STSWizardCreator.this.wiz);
                String targetName = Templates.getTargetName((WizardDescriptor)STSWizardCreator.this.wiz);
                try {
                    STSWizardCreator.this.generateProviderImplClass(STSWizardCreator.this.project, targetFolder, targetName, service1, port1, wsdlURL);
                    handle.finish();
                }
                catch (Exception ex) {
                    handle.finish();
                    logger.log(Level.SEVERE, null, ex);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateProviderImplClass(Project project, FileObject targetFolder, final String targetName, final WsdlService service, final WsdlPort port, URL wsdlURL) throws Exception {
        FileObject ddFolder;
        FileObject sunjaxwsFile;
        this.initProjectInfo(project);
        String serviceID = service.getName();
        final JAXWSSupport jaxWsSupport = JAXWSSupport.getJAXWSSupport((FileObject)project.getProjectDirectory());
        FileObject implClassFo = GenerationUtils.createClass(targetFolder, targetName, null);
        ClassPath classPath = ClassPath.getClassPath((FileObject)implClassFo, (String)"classpath/source");
        String serviceImplPath = classPath.getResourceName(implClassFo, '.', false);
        String portJavaName = port.getJavaName();
        String artifactsPckg = portJavaName.substring(0, portJavaName.lastIndexOf(46));
        serviceID = jaxWsSupport.addService(targetName, serviceImplPath, wsdlURL.toString(), service.getName(), port.getName(), artifactsPckg, this.jsr109Supported && Util.isJavaEE5orHigher(project), true);
        final String wsdlLocation = jaxWsSupport.getWsdlLocation(serviceID);
        final String[] fqn = new String[1];
        JavaSource targetSource = JavaSource.forFileObject((FileObject)implClassFo);
        CancellableTask<WorkingCopy> task = new CancellableTask<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                GenerationUtils genUtils = GenerationUtils.newInstance(workingCopy);
                if (genUtils != null) {
                    TreeMaker make = workingCopy.getTreeMaker();
                    ClassTree javaClass = genUtils.getClassTree();
                    Element element = workingCopy.getTrees().getElement(workingCopy.getTrees().getPath(workingCopy.getCompilationUnit(), javaClass));
                    if (element instanceof TypeElement) {
                        fqn[0] = ((TypeElement)element).getQualifiedName().toString();
                    }
                    String baseStsImpl = "com.sun.xml.ws.security.trust.sts.BaseSTSImpl";
                    ArrayList<AnnotationTree> annotations = new ArrayList<AnnotationTree>();
                    AnnotationTree resourceAnnotation = make.Annotation((Tree)make.QualIdent("javax.annotation.Resource"), Collections.emptyList());
                    annotations.add(resourceAnnotation);
                    ArrayList<VariableTree> classField = new ArrayList<VariableTree>();
                    classField.add(make.Variable(make.Modifiers(Collections.emptySet(), annotations), (CharSequence)"context", (Tree)make.QualIdent("javax.xml.ws.WebServiceContext"), null));
                    ClassTree modifiedClass = genUtils.addClassFields(javaClass, classField);
                    ParameterizedTypeTree t = make.ParameterizedType((Tree)make.QualIdent("javax.xml.ws.Provider"), Collections.singletonList(make.QualIdent("javax.xml.transform.Source")));
                    modifiedClass = make.addClassImplementsClause(modifiedClass, (Tree)t);
                    modifiedClass = make.setExtends(modifiedClass, (ExpressionTree)make.Identifier((CharSequence)baseStsImpl));
                    ArrayList<AssignmentTree> attrs = new ArrayList<AssignmentTree>();
                    attrs.add(make.Assignment((ExpressionTree)make.Identifier((CharSequence)"serviceName"), (ExpressionTree)make.Literal((Object)service.getName())));
                    attrs.add(make.Assignment((ExpressionTree)make.Identifier((CharSequence)"portName"), (ExpressionTree)make.Literal((Object)port.getName())));
                    attrs.add(make.Assignment((ExpressionTree)make.Identifier((CharSequence)"targetNamespace"), (ExpressionTree)make.Literal((Object)port.getNamespaceURI())));
                    attrs.add(make.Assignment((ExpressionTree)make.Identifier((CharSequence)"wsdlLocation"), (ExpressionTree)make.Literal((Object)wsdlLocation)));
                    AnnotationTree WSAnnotation = make.Annotation((Tree)make.QualIdent("javax.xml.ws.WebServiceProvider"), attrs);
                    modifiedClass = genUtils.addAnnotation(modifiedClass, WSAnnotation);
                    TypeElement modeAn = workingCopy.getElements().getTypeElement("javax.xml.ws.ServiceMode");
                    ArrayList<AssignmentTree> attrsM = new ArrayList<AssignmentTree>();
                    MemberSelectTree mstree = make.MemberSelect(make.QualIdent("javax.xml.ws.Service.Mode"), (CharSequence)"PAYLOAD");
                    attrsM.add(make.Assignment((ExpressionTree)make.Identifier((CharSequence)"value"), (ExpressionTree)mstree));
                    AnnotationTree modeAnnot = make.Annotation((Tree)make.QualIdent((Element)modeAn), attrsM);
                    modifiedClass = genUtils.addAnnotation(modifiedClass, modeAnnot);
                    if (STSWizardCreator.this.projectType == 2) {
                        AnnotationTree statelessAnnotation = make.Annotation((Tree)make.QualIdent("javax.ejb.Stateless"), Collections.emptyList());
                        modifiedClass = genUtils.addAnnotation(modifiedClass, statelessAnnotation);
                    }
                    ArrayList<VariableTree> params = new ArrayList<VariableTree>();
                    params.add(make.Variable(make.Modifiers(Collections.emptySet(), Collections.emptyList()), (CharSequence)"rstElement", (Tree)make.QualIdent("javax.xml.transform.Source"), null));
                    ModifiersTree methodModifiers = make.Modifiers(Collections.singleton(Modifier.PUBLIC), Collections.emptyList());
                    ArrayList exc = new ArrayList();
                    MethodTree method = make.Method(methodModifiers, (CharSequence)"invoke", (Tree)make.QualIdent("javax.xml.transform.Source"), Collections.emptyList(), params, exc, "{ return super.invoke(rstElement); }", null);
                    modifiedClass = make.addClassMember(modifiedClass, (Tree)method);
                    ModifiersTree msgContextModifiers = make.Modifiers(Collections.singleton(Modifier.PROTECTED), Collections.emptyList());
                    ArrayList excMsg = new ArrayList();
                    MethodTree methodMsgContext = make.Method(msgContextModifiers, (CharSequence)"getMessageContext", (Tree)make.QualIdent("javax.xml.ws.handler.MessageContext"), Collections.emptyList(), Collections.emptyList(), excMsg, "{ MessageContext msgCtx = context.getMessageContext();\nreturn msgCtx; }", null);
                    modifiedClass = make.addClassMember(modifiedClass, (Tree)methodMsgContext);
                    workingCopy.rewrite((Tree)javaClass, (Tree)modifiedClass);
                }
            }

            public void cancel() {
            }
        };
        targetSource.runModificationTask((Task)task).commit();
        String url = "/" + targetName + "Service";
        String mexUrl = url + "/mex";
        WsitProvider wsitProvider = (WsitProvider)project.getLookup().lookup(WsitProvider.class);
        if (wsitProvider != null) {
            wsitProvider.addServiceDDEntry(serviceImplPath, mexUrl, targetName);
        }
        if ((sunjaxwsFile = (ddFolder = jaxWsSupport.getDeploymentDescriptorFolder()).getFileObject("sun-jaxws.xml")) == null) {
            WSUtils.generateSunJaxwsFile((FileObject)ddFolder);
            sunjaxwsFile = ddFolder.getFileObject("sun-jaxws.xml");
        }
        Endpoints endpoints = EndpointsProvider.getDefault().getEndpoints(sunjaxwsFile);
        Endpoint endpoint = endpoints.newEndpoint();
        endpoint.setEndpointName("MEXEndpoint");
        endpoint.setImplementation("com.sun.xml.ws.mex.server.MEXEndpoint");
        endpoint.setUrlPattern(mexUrl);
        endpoints.addEnpoint(endpoint);
        if (fqn[0] != null) {
            endpoint = endpoints.newEndpoint();
            endpoint.setEndpointName(targetName);
            endpoint.setImplementation(fqn[0]);
            endpoint.setUrlPattern(url);
            endpoints.addEnpoint(endpoint);
        }
        FileLock lock = null;
        OutputStream os = null;
        STSWizardCreator sTSWizardCreator = this;
        synchronized (sTSWizardCreator) {
            try {
                lock = sunjaxwsFile.lock();
                os = sunjaxwsFile.getOutputStream(lock);
                endpoints.write(os);
            }
            finally {
                if (lock != null) {
                    lock.releaseLock();
                }
                if (os != null) {
                    os.close();
                }
            }
        }
        DataObject dobj = DataObject.find((FileObject)implClassFo);
        implClassFo.setAttribute(STS_WEBSERVICE, (Object)Boolean.TRUE);
        implClassFo.addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

            public void fileDeleted(FileEvent fe) {
                try {
                    jaxWsSupport.removeNonJsr109Entries("MEXEndpoint");
                    jaxWsSupport.removeNonJsr109Entries(fqn[0]);
                    jaxWsSupport.removeNonJsr109Entries(targetName);
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, null, e);
                }
            }
        });
        STSWizardCreator.openFileInEditor(dobj);
    }

    private static void openFileInEditor(DataObject dobj) {
        final EditorCookie ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                ec.open();
            }
        }, 1000);
    }
}

