/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.xref;

import java.util.Collection;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmNamedElement;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmQualifiedNamedElement;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.modelutil.CsmDisplayUtilities;
import org.netbeans.modules.cnd.spi.utils.FileObjectRedirector;
import org.netbeans.modules.cnd.xref.impl.ReferenceSupportImpl;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public final class CsmReferenceSupport {
    private static final ReferenceSupportImpl impl = new ReferenceSupportImpl();

    private CsmReferenceSupport() {
    }

    public static CsmReference createObjectReference(CsmOffsetable obj) {
        return impl.createObjectReference(obj);
    }

    public static CsmReference createObjectReference(CsmObject target, CsmOffsetable owner) {
        return impl.createObjectReference(target, owner);
    }

    public static CharSequence getContextLineHtml(CsmReference ref, boolean refNameInBold) {
        int endToken;
        int stToken;
        CsmFile csmFile = ref.getContainingFile();
        CharSequence out = CsmDisplayUtilities.getContextLineHtml((CsmFile)csmFile, (int)(stToken = ref.getStartOffset()), (int)(endToken = ref.getEndOffset()), (boolean)refNameInBold);
        if (out == null) {
            out = ref.getText();
        }
        return out;
    }

    public static CharSequence getContextLine(CsmReference ref) {
        int endToken;
        int stToken;
        CsmFile csmFile = ref.getContainingFile();
        CharSequence out = CsmDisplayUtilities.getContextLine((CsmFile)csmFile, (int)(stToken = ref.getStartOffset()), (int)(endToken = ref.getEndOffset()));
        if (out == null) {
            out = ref.getText();
        }
        return out;
    }

    public static boolean sameFile(CsmFile checkFile, CsmFile targetFile) {
        if (checkFile != null && targetFile != null && checkFile.getName().equals(targetFile.getName())) {
            CharSequence targetAbsolutePath;
            if (checkFile.equals(targetFile)) {
                return true;
            }
            CharSequence checkAbsolutePath = checkFile.getAbsolutePath();
            if (checkAbsolutePath.equals(targetAbsolutePath = targetFile.getAbsolutePath())) {
                FileObject checkDeclFO = checkFile.getFileObject();
                FileObject targetDeclFO = targetFile.getFileObject();
                if (checkDeclFO != null && targetDeclFO != null) {
                    return checkDeclFO.equals(targetDeclFO);
                }
                return true;
            }
            FileObject checkDeclFO = checkFile.getFileObject();
            FileObject targetDeclFO = targetFile.getFileObject();
            if (checkDeclFO != null && targetDeclFO != null) {
                Collection redirectors = Lookup.getDefault().lookupAll(FileObjectRedirector.class);
                for (FileObjectRedirector redirector : redirectors) {
                    FileObject fo1 = redirector.redirect(checkDeclFO);
                    FileObject fo2 = redirector.redirect(targetDeclFO);
                    if (fo1 != null && fo2 != null) {
                        return fo1.equals(fo2);
                    }
                    if (fo1 != null && fo2 == null) {
                        return fo1.equals(targetDeclFO);
                    }
                    if (fo1 != null || fo2 == null) continue;
                    return checkDeclFO.equals(fo2);
                }
            }
        }
        return false;
    }

    public static boolean sameDeclaration(CsmObject checkDecl, CsmObject targetDecl) {
        CharSequence fqnTarget;
        CharSequence fqnCheck;
        CharSequence targetName;
        CharSequence checkName;
        if (checkDecl.equals(targetDecl)) {
            return true;
        }
        if (CsmReferenceSupport.isSameOffsetables(checkDecl, targetDecl)) {
            return true;
        }
        if (CsmKindUtilities.isConstructor((CsmObject)checkDecl)) {
            return false;
        }
        if (CsmKindUtilities.isFunction((CsmObject)checkDecl) && CsmKindUtilities.isFunction((CsmObject)targetDecl)) {
            CharSequence fqnTarget2;
            CharSequence fqnCheck2 = ((CsmQualifiedNamedElement)checkDecl).getQualifiedName();
            if (fqnCheck2.equals(fqnTarget2 = ((CsmQualifiedNamedElement)targetDecl).getQualifiedName()) && CsmBaseUtilities.sameSignature((CsmFunction)((CsmFunction)checkDecl), (CsmFunction)((CsmFunction)targetDecl))) {
                return true;
            }
        } else if (CsmKindUtilities.isVariable((CsmObject)checkDecl) && CsmKindUtilities.isVariable((CsmObject)targetDecl) && (checkName = ((CsmNamedElement)checkDecl).getName()).equals(targetName = ((CsmNamedElement)targetDecl).getName()) && CsmKindUtilities.isGlobalVariable((CsmObject)checkDecl) && CsmKindUtilities.isGlobalVariable((CsmObject)targetDecl) && (fqnCheck = ((CsmQualifiedNamedElement)checkDecl).getQualifiedName()).equals(fqnTarget = ((CsmQualifiedNamedElement)targetDecl).getQualifiedName())) {
            return CsmReferenceSupport.belongsToRelatedProjects(((CsmVariable)checkDecl).getContainingFile(), ((CsmVariable)targetDecl).getContainingFile());
        }
        return false;
    }

    private static boolean belongsToRelatedProjects(CsmFile checkFile, CsmFile targetFile) {
        if (checkFile == null || targetFile == null) {
            return false;
        }
        CsmProject checkPrj = checkFile.getProject();
        CsmProject targetPrj = targetFile.getProject();
        if (checkPrj == null || targetPrj == null) {
            return false;
        }
        if (checkPrj.equals(targetPrj)) {
            return true;
        }
        if (checkPrj.getLibraries().contains(targetPrj)) {
            return true;
        }
        return targetPrj.getLibraries().contains(checkPrj);
    }

    private static boolean isSameOffsetables(CsmObject checkDecl, CsmObject targetDecl) {
        if (CsmKindUtilities.isOffsetable((Object)checkDecl) && CsmKindUtilities.isOffsetable((Object)targetDecl)) {
            CsmOffsetable offsCheckDecl = (CsmOffsetable)checkDecl;
            CsmOffsetable offsTargetDecl = (CsmOffsetable)targetDecl;
            if (offsCheckDecl.getStartOffset() == offsTargetDecl.getStartOffset()) {
                CsmFile checkDeclFile = offsCheckDecl.getContainingFile();
                CsmFile targetDeclFile = offsTargetDecl.getContainingFile();
                return CsmReferenceSupport.sameFile(checkDeclFile, targetDeclFile);
            }
        }
        return false;
    }
}

