/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.assembly;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.Catalog;
import org.netbeans.spi.viewmodel.Models;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class RegistersWindow
extends TopComponent
implements ActionListener {
    private static final String preferredID = "RegistersWindow";
    private static RegistersWindow DEFAULT;
    private transient JComponent tree = null;
    private final String name = Catalog.get("TITLE_RegistersWindow");
    private final String view_name = Catalog.get("TITLE_RegistersView");
    private NativeDebugger debugger = null;
    private DefaultTableModel dataModel;
    private JMenuItem menuItemHide;
    private JPopupMenu popup;
    private JPanel hp;
    private JTable tab;
    private JTextArea ta;
    private JScrollPane ta_sp;
    private JScrollPane tab_sp;
    private List<String> previous_regs;
    private List<String> current_regs;
    private List<String> hidden_regs;
    private PopupListener popupListener;
    private boolean needInitData = true;
    private boolean seen_sparc_regs = false;
    private String selected_text = null;
    private int selected_area_start = 0;
    private int selected_area_end = 0;
    private int view_model = 1;

    public static synchronized RegistersWindow getDefault() {
        if (DEFAULT == null && (DEFAULT = (RegistersWindow)WindowManager.getDefault().findTopComponent(preferredID)) == null) {
            DEFAULT = new RegistersWindow();
        }
        return DEFAULT;
    }

    public RegistersWindow() {
        super.setName(this.name);
        String iconDir = "org/netbeans/modules/cnd/debugger/common2/icons/";
        this.setIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/debugger/common2/icons/registers.png"));
    }

    protected String preferredID() {
        return this.getClass().getName();
    }

    protected void componentHidden() {
        if (this.debugger != null) {
            this.debugger.registerRegistersWindow(null);
        }
        super.componentHidden();
    }

    protected void componentShowing() {
        super.componentShowing();
        this.connectToDebugger(NativeDebuggerManager.get().currentDebugger());
        this.needInitData = true;
        this.updateWindow();
    }

    protected void componentClosed() {
        if (this.debugger != null) {
            this.debugger.registerRegistersWindow(null);
        }
        super.componentClosed();
    }

    private void connectToDebugger(NativeDebugger debugger) {
        this.debugger = debugger;
        if (debugger == null) {
            return;
        }
        debugger.registerRegistersWindow(this);
    }

    public void requestActive() {
        super.requestActive();
        this.tab.requestFocusInWindow();
    }

    private void updateWindow() {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.tree == null) {
            String symbol = "\"main()\"";
            this.ta = new JTextArea();
            this.ta_sp = new JScrollPane(this.ta);
            Object[] columnNames = new Object[]{Catalog.get("LBL_NameCol"), Catalog.get("LBL_ValueCol")};
            this.dataModel = new RegisterTableModel(columnNames);
            this.tab = new JTable(this.dataModel);
            this.tab.getColumnModel().getColumn(0).setPreferredWidth(40);
            this.tab.getColumnModel().getColumn(1).setPreferredWidth(300);
            this.tab.setGridColor(Color.LIGHT_GRAY);
            this.tab_sp = new JScrollPane(this.tab);
            this.previous_regs = new ArrayList<String>();
            this.current_regs = new ArrayList<String>();
            this.hidden_regs = new ArrayList<String>();
            this.setLayout(new BorderLayout());
            this.tree = Models.createView((Models.CompoundModel)Models.EMPTY_MODEL);
            this.tree.setName(this.view_name);
            this.ta.setEditable(false);
            this.ta.setWrapStyleWord(false);
            Font f = this.ta.getFont();
            this.ta.setFont(new Font("Monospaced", f.getStyle(), f.getSize()));
            f = this.tab.getFont();
            this.tab.setFont(new Font("Monospaced", f.getStyle(), f.getSize()));
            BorderLayout bl = new BorderLayout();
            bl.setHgap(118);
            this.hp = new JPanel(bl);
            JLabel hp_name = new JLabel(Catalog.get("RegisterName"));
            JLabel hp_value = new JLabel(Catalog.get("RegisterValue"));
            hp_name.setToolTipText(Catalog.get("LBL_RegisterName"));
            hp_value.setToolTipText(Catalog.get("LBL_RegisterValue"));
            this.hp.add((Component)hp_name, "West");
            this.hp.add((Component)hp_value, "Center");
            this.hp.setToolTipText(Catalog.get("LBL_RegisterName"));
            if (this.view_model == 0) {
                this.tree.add((Component)this.hp, "North");
                this.tree.add((Component)this.ta_sp, "Center");
            } else {
                this.tree.add((Component)this.tab_sp, "Center");
            }
            AccessibleContext ac = this.tree.getAccessibleContext();
            ac.setAccessibleDescription(Catalog.get("ACSD_RegisterView"));
            ac.setAccessibleName(Catalog.get("TITLE_RegistersView"));
            this.add(this.tree, "Center");
            this.popup = new JPopupMenu();
            this.popup.add(new ShowAllRegistersAction());
            this.menuItemHide = new JMenuItem(new HideSelectedRegistersAction());
            this.popup.add(this.menuItemHide);
            this.popupListener = new PopupListener(this.popup);
            this.ta.addMouseListener(this.popupListener);
            this.tab.addMouseListener(this.popupListener);
            this.ta.setText(null);
            this.ta.setCaretPosition(0);
            this.hidden_regs.add("cs");
            this.hidden_regs.add("ds");
            this.hidden_regs.add("es");
            this.hidden_regs.add("fs");
            this.hidden_regs.add("gs");
            this.hidden_regs.add("ss");
        }
        if (this.needInitData) {
            this.needInitData = false;
        }
        int carpos = this.ta.getCaretPosition();
        this.ta.setText(null);
        this.dataModel.setRowCount(0);
        for (int i = 0; i < this.current_regs.size(); ++i) {
            String s = this.current_regs.get(i);
            String[] names = this.getRegisterNames(s);
            if (names == null) continue;
            String regname = names[0].trim();
            int m = 0;
            if (!this.hidden_regs.contains(regname)) {
                this.ta.append(s);
                Object[] row = new Object[]{"", ""};
                int n = 0;
                for (m = 0; m < s.length(); ++m) {
                    if (s.charAt(m) == ' ' || s.charAt(m) == '\t') continue;
                    for (n = m + 1; n < s.length() && s.charAt(n) != ' ' && s.charAt(n) != '\t'; ++n) {
                    }
                    break;
                }
                if (m < s.length() && m < n) {
                    row[0] = s.substring(m, n);
                    ++n;
                    while (n < s.length() && (s.charAt(n) == ' ' || s.charAt(n) == '\t')) {
                        ++n;
                    }
                    if (n > s.length()) {
                        n = s.length();
                    }
                    row[1] = s.substring(n, s.length());
                }
                this.dataModel.addRow(row);
            }
            if (i < this.previous_regs.size()) {
                this.previous_regs.set(i, s);
                continue;
            }
            this.previous_regs.add(s);
        }
        try {
            this.ta.setCaretPosition(carpos);
        }
        catch (IllegalArgumentException e) {
            this.ta.setCaretPosition(0);
        }
        this.invalidate();
        this.dataModel.fireTableDataChanged();
    }

    public int getPersistenceType() {
        return 0;
    }

    public String getName() {
        return this.name;
    }

    public String getToolTipText() {
        return this.view_name;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void updateData(List<String> regs) {
        this.current_regs.clear();
        this.current_regs.addAll(regs);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RegistersWindow.this.updateWindow();
            }
        });
    }

    private String[] getRegisterNames(String regs) {
        if (regs == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        int l = regs.length();
        for (int i = 0; i < l; ++i) {
            int k = regs.indexOf(10, i);
            if (k < 0) {
                k = l - 1;
            }
            if (k <= i) break;
            String s = regs.substring(i, k + 1);
            i = k;
            String regname = null;
            k = 0;
            for (int j = 0; j < s.length(); ++j) {
                if (s.charAt(j) == ' ') continue;
                if (k == 0) {
                    k = s.indexOf(32, j);
                    if (k < 0) {
                        k = s.length();
                    }
                    if (k < j) break;
                    regname = s.substring(j, k);
                    j = k;
                    continue;
                }
                k = s.indexOf(10, j);
                if (k >= j) break;
                break;
            }
            if (regname == null) continue;
            result.add(regname);
        }
        return result.toArray(new String[result.size()]);
    }

    protected void HideSelectedRegisters(String regs) {
        String[] selectedRegisterNames = this.getRegisterNames(regs);
        if (selectedRegisterNames == null) {
            return;
        }
        for (int i = 0; i < selectedRegisterNames.length; ++i) {
            String regname = selectedRegisterNames[i].trim();
            if (this.hidden_regs.contains(regname)) continue;
            this.hidden_regs.add(regname);
        }
        this.updateWindow();
    }

    protected void ShowAllRegisters() {
        this.hidden_regs.clear();
        this.updateWindow();
    }

    protected void ChangeView() {
        ++this.view_model;
        if (this.view_model > 1) {
            this.view_model = 0;
        }
        if (this.view_model == 0) {
            this.tree.remove(this.tab_sp);
            this.tree.add((Component)this.hp, "North");
            this.tree.add((Component)this.ta_sp, "Center");
        } else {
            this.tree.remove(this.hp);
            this.tree.remove(this.ta_sp);
            this.tree.add((Component)this.tab_sp, "Center");
        }
        this.updateWindow();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(preferredID);
    }

    private class PopupListener
    extends MouseAdapter
    implements ActionListener,
    PopupMenuListener {
        final JPopupMenu popup;

        PopupListener(JPopupMenu popupMenu) {
            this.popup = popupMenu;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void selectCurrentLine(int x, int y) {
            int ln = RegistersWindow.this.ta.getLineCount();
            if (ln > 0) {
                try {
                    RegistersWindow.this.selected_area_start = RegistersWindow.this.ta.getLineStartOffset(ln);
                    RegistersWindow.this.selected_area_end = RegistersWindow.this.ta.getLineEndOffset(ln);
                    RegistersWindow.this.ta.select(RegistersWindow.this.selected_area_start, RegistersWindow.this.selected_area_end);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                boolean selected = false;
                if (RegistersWindow.this.view_model == 0) {
                    RegistersWindow.this.selected_text = RegistersWindow.this.ta.getSelectedText();
                    if (RegistersWindow.this.selected_text != null) {
                        selected = true;
                    }
                } else if (RegistersWindow.this.tab.getSelectedRowCount() > 0) {
                    selected = true;
                }
                if (selected) {
                    RegistersWindow.this.menuItemHide.setEnabled(true);
                } else {
                    RegistersWindow.this.menuItemHide.setEnabled(false);
                }
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }
    }

    private class HideSelectedRegistersAction
    extends AbstractAction {
        public HideSelectedRegistersAction() {
            super(Catalog.get("Reg_ACT_Hide"), null);
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (RegistersWindow.this.view_model == 0) {
                RegistersWindow.this.selected_text = RegistersWindow.this.ta.getSelectedText();
            } else {
                if (RegistersWindow.this.tab.getSelectedRowCount() <= 0) {
                    return;
                }
                int[] rows = RegistersWindow.this.tab.getSelectedRows();
                RegistersWindow.this.selected_text = "";
                for (int i = 0; i < rows.length; ++i) {
                    RegistersWindow.this.selected_text = RegistersWindow.this.selected_text + RegistersWindow.this.tab.getValueAt(rows[i], 0) + "\t " + RegistersWindow.this.tab.getValueAt(rows[i], 1) + " \n";
                }
            }
            RegistersWindow.this.HideSelectedRegisters(RegistersWindow.this.selected_text);
        }
    }

    private class ShowAllRegistersAction
    extends AbstractAction {
        public ShowAllRegistersAction() {
            super(Catalog.get("Reg_ACT_Show_All_Registers"), null);
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            RegistersWindow.this.ShowAllRegisters();
        }
    }

    private class RegisterTableModel
    extends DefaultTableModel {
        public RegisterTableModel(Object[] columns) {
            super(columns, 0);
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            RegistersWindow.this.debugger.assignRegisterValue(this.getValueAt(row, 0).toString(), aValue.toString());
        }
    }
}

