/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.utils.props;

import org.netbeans.modules.cnd.debugger.common2.utils.IpeUtils;
import org.netbeans.modules.cnd.debugger.common2.utils.props.PropertyOwnerSupport;

public abstract class Property {
    private final PropertyOwnerSupport owner;
    private final String name;
    private final String key;
    private final boolean readOnly;
    private boolean differentiating;
    private boolean dirty;

    protected Property(PropertyOwnerSupport owner, String name, String key, boolean readOnly) {
        this.owner = owner;
        this.name = name;
        this.key = key;
        this.readOnly = readOnly;
        this.differentiating = true;
        owner.register(this);
    }

    public void setDifferentiating(boolean differentiating) {
        this.differentiating = differentiating;
    }

    public boolean isDifferentiating() {
        return this.differentiating;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public String name() {
        return this.name;
    }

    public String key() {
        return this.key;
    }

    public boolean matches(Property that) {
        if (!IpeUtils.sameString(this.name, that.name)) {
            return false;
        }
        assert (this.readOnly == that.readOnly);
        assert (IpeUtils.sameString(this.key, that.key));
        return IpeUtils.sameString(this.toString(), that.toString());
    }

    public abstract Object getAsObject();

    public abstract String toString();

    public void setFromObject(Object o) {
        this.setFromObjectImpl(o);
        this.setDirty();
    }

    public void setFromObjectInitial(Object o) {
        this.setFromObjectImpl(o);
    }

    public void setFromString(String s) {
        this.setFromStringImpl(s);
        this.setDirty();
    }

    protected void setDirty() {
        this.owner.setDirty();
        this.dirty = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    protected abstract void setFromObjectImpl(Object var1);

    protected abstract void setFromStringImpl(String var1);
}

