/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remotefs.versioning.api;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.remotefs.versioning.api.ProcessUtils;
import org.netbeans.modules.remotefs.versioning.api.RemoteVcsSupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.api.VersioningSupport;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public final class VCSFileProxySupport {
    private static Map<VCSFileProxy, Charset> fileToCharset;
    private static final Logger LOG;
    private static final Object ENCODING_LOCK;

    private VCSFileProxySupport() {
    }

    public static void deleteExternally(VCSFileProxy file) {
        RemoteVcsSupport.deleteExternally(file);
    }

    public static void delete(VCSFileProxy file) {
        RemoteVcsSupport.delete(file);
    }

    public static void deleteOnExit(VCSFileProxy file) {
    }

    public static void setLastModified(VCSFileProxy file, VCSFileProxy referenceFile) {
        RemoteVcsSupport.setLastModified(file, referenceFile);
    }

    public static boolean mkdir(VCSFileProxy file) {
        File javaFile = file.toFile();
        if (javaFile != null) {
            return javaFile.mkdir();
        }
        ProcessUtils.ExitStatus status = ProcessUtils.executeInDir(file.getParentFile().getPath(), null, false, new ProcessUtils.Canceler(), VersioningSupport.createProcessBuilder((VCSFileProxy)file), "mkdir", file.getPath());
        if (!status.isOK()) {
            LOG.log(Level.INFO, "mkdir {0} failed: {1}", new Object[]{file.getPath(), status.toString()});
            return false;
        }
        return VCSFileProxySupport.refreshImpl(file);
    }

    public static boolean mkdirs(VCSFileProxy file) {
        File javaFile = file.toFile();
        if (javaFile != null) {
            return javaFile.mkdirs();
        }
        ProcessUtils.ExitStatus status = ProcessUtils.executeInDir(null, null, false, new ProcessUtils.Canceler(), VersioningSupport.createProcessBuilder((VCSFileProxy)file), "mkdir", "-p", file.getPath());
        if (!status.isOK()) {
            LOG.log(Level.INFO, "mkdir -p {0} failed: {1}", new Object[]{file, status});
            return false;
        }
        return VCSFileProxySupport.refreshImpl(file);
    }

    public static boolean setExecutable(VCSFileProxy file, boolean b) {
        File javaFile = file.toFile();
        if (javaFile != null) {
            return javaFile.setExecutable(b);
        }
        throw new UnsupportedOperationException();
    }

    public static VCSFileProxy createSymbolicLink(VCSFileProxy link, String relPath) throws IOException {
        File javaFile = link.toFile();
        if (javaFile != null) {
            Path createdSymbolicLink = Files.createSymbolicLink(Paths.get(javaFile.getPath(), new String[0]), Paths.get(relPath, new String[0]), new FileAttribute[0]);
            return VCSFileProxy.createFileProxy((File)createdSymbolicLink.toFile());
        }
        throw new UnsupportedOperationException();
    }

    public static VCSFileProxy fromURI(URI uri) {
        if ("file".equals(uri.getScheme())) {
            return VCSFileProxy.createFileProxy((File)new File(uri));
        }
        try {
            ArrayList<String> segments = new ArrayList<String>();
            FileObject fo = VCSFileProxySupport.findExistingParent(uri, segments);
            VCSFileProxy res = VCSFileProxy.createFileProxy((FileObject)fo);
            for (int i = segments.size() - 1; i >= 0; --i) {
                res = VCSFileProxy.createFileProxy((VCSFileProxy)res, (String)((String)segments.get(i)));
            }
            return res;
        }
        catch (URISyntaxException ex) {
            LOG.log(Level.INFO, null, ex);
        }
        catch (MalformedURLException ex) {
            LOG.log(Level.INFO, null, ex);
        }
        return null;
    }

    private static FileObject findExistingParent(URI first, List<String> segments) throws MalformedURLException, URISyntaxException {
        URI uri = first;
        URL url;
        FileObject fo;
        while ((fo = URLMapper.findFileObject((URL)(url = uri.toURL()))) == null) {
            String path = uri.getPath();
            int i = path.lastIndexOf(47);
            if (i < 0) {
                i = path.lastIndexOf(92);
            }
            if (i < 0) {
                throw new MalformedURLException("URI " + first.toString());
            }
            segments.add(path.substring(i + 1));
            path = path.substring(0, i);
            uri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), path, uri.getQuery(), uri.getFragment());
        }
        return fo;
    }

    public static URI toURI(VCSFileProxy file) {
        File javaFile = file.toFile();
        if (javaFile != null) {
            return javaFile.toURI();
        }
        try {
            ArrayList<String> segments = new ArrayList<String>();
            FileObject fo = VCSFileProxySupport.findExistingParent(file, segments);
            URI res = fo.toURI();
            for (int i = segments.size() - 1; i >= 0; --i) {
                String path = res.getPath().endsWith("/") ? res.getPath() + (String)segments.get(i) : res.getPath() + "/" + (String)segments.get(i);
                res = new URI(res.getScheme(), res.getUserInfo(), res.getHost(), res.getPort(), path, res.getQuery(), res.getFragment());
            }
            return res;
        }
        catch (URISyntaxException ex) {
            LOG.log(Level.INFO, null, ex);
        }
        catch (FileNotFoundException ex) {
            LOG.log(Level.INFO, null, ex);
        }
        return null;
    }

    private static FileObject findExistingParent(VCSFileProxy file, List<String> segments) throws FileNotFoundException {
        do {
            FileObject fo;
            if ((fo = file.toFileObject()) != null) {
                return fo;
            }
            segments.add(file.getName());
        } while ((file = file.getParentFile()) != null);
        throw new FileNotFoundException();
    }

    public static boolean isSymlink(VCSFileProxy file) {
        return RemoteVcsSupport.isSymlink(file);
    }

    public static String readSymbolicLinkPath(VCSFileProxy file) throws IOException {
        return RemoteVcsSupport.readSymbolicLinkPath(file);
    }

    public static boolean canRead(VCSFileProxy file) {
        return RemoteVcsSupport.canRead(file);
    }

    public static boolean canRead(VCSFileProxy base, String subdir) {
        return RemoteVcsSupport.canRead(base, subdir);
    }

    public static boolean createNew(VCSFileProxy file) throws IOException {
        ProcessUtils.ExitStatus status;
        VCSFileProxy parentFile = file.getParentFile();
        if (!parentFile.exists()) {
            VCSFileProxySupport.mkdirs(parentFile);
        }
        if (!(status = ProcessUtils.executeInDir(parentFile.getPath(), null, false, new ProcessUtils.Canceler(), VersioningSupport.createProcessBuilder((VCSFileProxy)file), "touch", file.getName())).isOK()) {
            LOG.log(Level.INFO, "touch {0} failed: {1}", new Object[]{file, status});
            throw new IOException(status.toString());
        }
        return VCSFileProxySupport.refreshImpl(file);
    }

    public static OutputStream getOutputStream(VCSFileProxy file) throws IOException {
        return RemoteVcsSupport.getOutputStream(file);
    }

    public static long length(VCSFileProxy file) {
        return RemoteVcsSupport.getSize(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFully(VCSFileProxy file, int max) throws IOException {
        try (InputStream inputStream = file.getInputStream(false);){
            int i;
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            while ((i = inputStream.read()) != -1) {
                b.write(i);
                if (--max != 0) continue;
            }
            byte[] byArray = b.toByteArray();
            return byArray;
        }
    }

    public static String getCanonicalPath(VCSFileProxy file) throws IOException {
        return RemoteVcsSupport.getCanonicalPath(file);
    }

    public static VCSFileProxy getCanonicalFile(VCSFileProxy file) throws IOException {
        return RemoteVcsSupport.getCanonicalFile(file);
    }

    public static VCSFileProxy generateTemporaryFile(VCSFileProxy file, String name) {
        VCSFileProxy tmp = VCSFileProxy.createFileProxy((VCSFileProxy)file, (String)name);
        while (tmp.exists()) {
            tmp = VCSFileProxy.createFileProxy((VCSFileProxy)file, (String)(name + Long.toString(System.currentTimeMillis())));
        }
        return tmp;
    }

    public static VCSFileProxy createTempFile(VCSFileProxy file, String prefix, String suffix, boolean deleteOnExit) throws IOException {
        File javaFile = file.toFile();
        if (javaFile != null) {
            File res = File.createTempFile(prefix, suffix);
            res.deleteOnExit();
            return VCSFileProxy.createFileProxy((File)res);
        }
        if (suffix == null) {
            suffix = ".tmp";
        }
        return VCSFileProxy.createFileProxy((FileObject)file.toFileObject().createData(prefix + Long.toString(System.currentTimeMillis()), suffix));
    }

    public static VCSFileProxy getTempFolder(VCSFileProxy file, boolean deleteOnExit) throws FileStateInvalidException, IOException {
        FileObject tmpDir = VCSFileProxySupport.getFileSystem(file).getTempFolder();
        while (true) {
            try {
                FileObject dir = tmpDir.createFolder("vcs-" + Long.toString(System.currentTimeMillis()));
                return VCSFileProxy.createFileProxy((FileObject)dir).normalizeFile();
            }
            catch (IOException ex) {
                continue;
            }
            break;
        }
    }

    public static boolean renameTo(VCSFileProxy from, VCSFileProxy to) {
        File javaFile = from.toFile();
        if (javaFile != null) {
            return javaFile.renameTo(to.toFile());
        }
        ProcessUtils.ExitStatus status = ProcessUtils.executeInDir(from.getParentFile().getPath(), null, false, new ProcessUtils.Canceler(), VersioningSupport.createProcessBuilder((VCSFileProxy)from), "mv", "-f", from.getName(), to.getPath());
        if (!status.isOK()) {
            LOG.log(Level.INFO, "mv -f {0} {1} failed: {2}", new Object[]{from, to, status});
            return false;
        }
        return VCSFileProxySupport.refreshPairImpl(from.getParentFile(), to.getParentFile());
    }

    public static void copyDirFiles(VCSFileProxy sourceDir, VCSFileProxy targetDir, boolean preserveTimestamp) {
        VCSFileProxy[] files = sourceDir.listFiles();
        if (files == null || files.length == 0) {
            VCSFileProxySupport.mkdirs(targetDir);
            if (preserveTimestamp) {
                VCSFileProxySupport.setLastModified(targetDir, sourceDir);
            }
            return;
        }
        if (preserveTimestamp) {
            VCSFileProxySupport.setLastModified(targetDir, sourceDir);
        }
        for (int i = 0; i < files.length; ++i) {
            try {
                VCSFileProxy target = VCSFileProxy.createFileProxy((VCSFileProxy)targetDir, (String)files[i].getName()).normalizeFile();
                if (files[i].isDirectory()) {
                    VCSFileProxySupport.copyDirFiles(files[i], target, preserveTimestamp);
                    continue;
                }
                VCSFileProxySupport.copyFile(files[i], target);
                if (!preserveTimestamp) continue;
                VCSFileProxySupport.setLastModified(target, files[i]);
                continue;
            }
            catch (IOException ex) {
                Logger.getLogger(VCSFileProxySupport.class.getName()).log(Level.WARNING, ex.getMessage(), ex);
            }
        }
        VCSFileProxySupport.refreshImpl(targetDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(VCSFileProxy from, VCSFileProxy to) throws IOException {
        if (from == null || to == null) {
            throw new NullPointerException("from and to files must not be null");
        }
        InputStream inputStream = null;
        try {
            inputStream = from.getInputStream(false);
            VCSFileProxySupport.copyStreamToFile(inputStream, to);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        VCSFileProxySupport.refreshImpl(to);
        return true;
    }

    public static String getExistingFilenameInParent(VCSFileProxy file) {
        String filename = null;
        if (file == null) {
            return filename;
        }
        VCSFileProxy parent = file.getParentFile();
        if (parent == null) {
            return filename;
        }
        VCSFileProxy[] children = parent.listFiles();
        if (children == null) {
            return filename;
        }
        for (VCSFileProxy child : children) {
            if (!file.getName().equalsIgnoreCase(child.getName())) continue;
            filename = child.getName();
            break;
        }
        return filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStreamToFile(InputStream inputStream, VCSFileProxy targetFile) throws IOException {
        OutputStream outputStream;
        block16: {
            outputStream = null;
            try {
                outputStream = VCSFileProxySupport.getOutputStream(targetFile);
                try {
                    byte[] buffer = new byte[32768];
                    int readBytes = inputStream.read(buffer);
                    while (readBytes > 0) {
                        outputStream.write(buffer, 0, readBytes);
                        readBytes = inputStream.read(buffer);
                    }
                }
                catch (IOException ex) {
                    VCSFileProxySupport.delete(targetFile);
                    throw ex;
                }
                if (inputStream == null) break block16;
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                VCSFileProxySupport.refreshImpl(targetFile);
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        VCSFileProxySupport.refreshImpl(targetFile);
    }

    public static boolean isRemoteFileSystem(VCSFileProxy file) {
        return file.toFile() == null;
    }

    public static VCSFileProxy getResource(VCSFileProxy file, String absPath) {
        VCSFileProxy parent;
        if (!absPath.startsWith("/")) assert (absPath.startsWith("/")) : "Path " + absPath + "must be absolute";
        while (true) {
            if ((parent = file.getParentFile()) == null) break;
            file = parent;
        }
        parent = file;
        return VCSFileProxy.createFileProxy((VCSFileProxy)parent, (String)absPath.substring(1));
    }

    public static VCSFileProxy getResource(FileSystem fileSystem, String absPath) {
        VCSFileProxy root = VCSFileProxy.createFileProxy((FileObject)fileSystem.getRoot());
        if (absPath.startsWith("/")) {
            return VCSFileProxy.createFileProxy((VCSFileProxy)root, (String)absPath.substring(1));
        }
        return VCSFileProxy.createFileProxy((VCSFileProxy)root, (String)absPath);
    }

    public static VCSFileProxy getHome(VCSFileProxy file) {
        return RemoteVcsSupport.getHome(file);
    }

    public static VCSFileProxy getRemotePeristenceFolder(FileSystem fileSystem) throws FileStateInvalidException, IOException {
        FileObject tmpDir = fileSystem.getTempFolder();
        String userName = "user";
        String folderName = "svn_" + userName;
        FileObject res = tmpDir.getFileObject(folderName);
        if (res == null || !res.isValid()) {
            res = tmpDir.createFolder(folderName);
        }
        return VCSFileProxy.createFileProxy((FileObject)res);
    }

    public static boolean isMac(VCSFileProxy file) {
        return RemoteVcsSupport.isMac(file);
    }

    public static boolean isSolaris(VCSFileProxy file) {
        return RemoteVcsSupport.isSolaris(file);
    }

    public static boolean isUnix(VCSFileProxy file) {
        return RemoteVcsSupport.isUnix(file);
    }

    public static String getFileSystemKey(FileSystem file) {
        String fileSystemKey = RemoteVcsSupport.getFileSystemKey(file);
        fileSystemKey = fileSystemKey.replace(':', '_');
        fileSystemKey = fileSystemKey.replace('@', '_');
        return fileSystemKey;
    }

    public static boolean isConnectedFileSystem(FileSystem file) {
        return RemoteVcsSupport.isConnectedFileSystem(file);
    }

    public static void connectFileSystem(FileSystem file) {
        RemoteVcsSupport.connectFileSystem(file);
    }

    public static String toString(VCSFileProxy file) {
        return RemoteVcsSupport.toString(file);
    }

    public static VCSFileProxy fromString(String file) {
        return RemoteVcsSupport.fromString(file);
    }

    public static JFileChooser createFileChooser(VCSFileProxy proxy) {
        return RemoteVcsSupport.createFileChooser(proxy);
    }

    public static VCSFileProxy getSelectedFile(JFileChooser chooser) {
        return RemoteVcsSupport.getSelectedFile(chooser);
    }

    public static FileSystem getDefaultFileSystem() {
        return RemoteVcsSupport.getDefaultFileSystem();
    }

    public static FileSystem[] getFileSystems() {
        return RemoteVcsSupport.getFileSystems();
    }

    public static FileSystem[] getConnectedFileSystems() {
        return RemoteVcsSupport.getConnectedFileSystems();
    }

    public static FileSystem getFileSystem(VCSFileProxy file) {
        return RemoteVcsSupport.getFileSystem(file);
    }

    public static FileSystem readFileSystem(DataInputStream is) throws IOException {
        return RemoteVcsSupport.readFileSystem(is);
    }

    public static void writeFileSystem(DataOutputStream os, FileSystem fs) throws IOException {
        RemoteVcsSupport.writeFileSystem(os, fs);
    }

    private static boolean refreshPairImpl(VCSFileProxy fromParent, VCSFileProxy toParent) {
        if (fromParent != null && toParent != null) {
            if (toParent.equals((Object)fromParent)) {
                return VCSFileProxySupport.refreshImpl(fromParent);
            }
            return VCSFileProxySupport.refreshImpl(fromParent, toParent);
        }
        return true;
    }

    private static boolean refreshImpl(VCSFileProxy ... files) {
        try {
            RemoteVcsSupport.refreshFor(files);
        }
        catch (IOException ex) {
            if (LOG.isLoggable(Level.FINE)) {
                StringBuilder sb = new StringBuilder("Error refreshing ");
                for (VCSFileProxy f : files) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(f);
                }
                LOG.log(Level.FINE, sb.toString(), ex);
            }
            return false;
        }
        return true;
    }

    public static boolean isAncestorOrEqual(VCSFileProxy ancestor, VCSFileProxy file) {
        String ancestorPath = ancestor.getPath();
        String filePath = file.getPath();
        if (VCSFileProxySupport.isMac(ancestor) ? filePath.length() < ancestorPath.length() : !filePath.startsWith(ancestorPath)) {
            return false;
        }
        while (file != null) {
            if (file.equals((Object)ancestor)) {
                return true;
            }
            file = file.getParentFile();
        }
        return false;
    }

    public static void openFile(VCSFileProxy file) {
        FileObject fo = file.toFileObject();
        if (fo != null) {
            try {
                DataObject dao = DataObject.find((FileObject)fo);
                OpenCookie oc = (OpenCookie)dao.getLookup().lookup(OpenCookie.class);
                if (oc != null) {
                    oc.open();
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
    }

    public static VCSFileProxy[][] splitFlatOthers(VCSFileProxy[] files) {
        HashSet<VCSFileProxy> flat = new HashSet<VCSFileProxy>(1);
        for (int i = 0; i < files.length; ++i) {
            if (!VersioningSupport.isFlat((VCSFileProxy)files[i])) continue;
            flat.add(files[i]);
        }
        if (flat.isEmpty()) {
            return new VCSFileProxy[][]{new VCSFileProxy[0], files};
        }
        HashSet<VCSFileProxy> allFiles = new HashSet<VCSFileProxy>(Arrays.asList(files));
        allFiles.removeAll(flat);
        return new VCSFileProxy[][]{flat.toArray(new VCSFileProxy[flat.size()]), allFiles.toArray(new VCSFileProxy[allFiles.size()])};
    }

    public static Set<VCSFileProxy> flattenFiles(VCSFileProxy[] roots, Collection<VCSFileProxy> files) {
        VCSFileProxy[][] split = VCSFileProxySupport.splitFlatOthers(roots);
        HashSet<VCSFileProxy> filteredFiles = new HashSet<VCSFileProxy>(files);
        if (split[0].length > 0) {
            Iterator it = filteredFiles.iterator();
            block0: while (it.hasNext()) {
                VCSFileProxy f = (VCSFileProxy)it.next();
                for (VCSFileProxy flat : split[0]) {
                    if (f.getParentFile().equals((Object)flat)) continue block0;
                }
                for (VCSFileProxy folder : split[1]) {
                    if (VCSFileProxySupport.isAncestorOrEqual(folder, f)) continue block0;
                }
                it.remove();
            }
        }
        return filteredFiles;
    }

    public static boolean isFromMultiFileDataObject(VCSContext ctx) {
        Collection allSets;
        if (ctx != null && (allSets = ctx.getElements().lookupAll(Set.class)) != null) {
            for (Set contextElements : allSets) {
                if (!"org.openide.loaders.DataNode$LazyFilesSet".equals(contextElements.getClass().getName())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean shareCommonDataObject(VCSFileProxy[] files) {
        if (files == null || files.length < 2) {
            return true;
        }
        DataObject common = VCSFileProxySupport.findDataObject(files[0]);
        for (int i = 1; i < files.length; ++i) {
            DataObject dao = VCSFileProxySupport.findDataObject(files[i]);
            if (dao == common || dao != null && dao.equals(common)) continue;
            return false;
        }
        return true;
    }

    private static DataObject findDataObject(VCSFileProxy file) {
        FileObject fo = file.toFileObject();
        if (fo != null) {
            try {
                return DataObject.find((FileObject)fo);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Set<VCSFileProxy> getAllDataObjectFiles(VCSFileProxy file) {
        HashSet<VCSFileProxy> filesToCheckout = new HashSet<VCSFileProxy>(2);
        filesToCheckout.add(file);
        FileObject fo = file.toFileObject();
        if (fo != null) {
            try {
                DataObject dao = DataObject.find((FileObject)fo);
                Set fileObjects = dao.files();
                for (FileObject fileObject : fileObjects) {
                    filesToCheckout.add(VCSFileProxy.createFileProxy((FileObject)fileObject));
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return filesToCheckout;
    }

    public static VCSFileProxy getCommonParent(VCSFileProxy a, VCSFileProxy b) {
        do {
            if (!a.equals((Object)b)) continue;
            return a;
        } while (!(a.getPath().length() > b.getPath().length() ? (a = a.getParentFile()) == null : (b = b.getParentFile()) == null));
        return null;
    }

    public static boolean isFileContentText(VCSFileProxy file) {
        FileObject fo = file.toFileObject();
        if (fo == null) {
            return false;
        }
        if (fo.getMIMEType().startsWith("text")) {
            return true;
        }
        try {
            DataObject dao = DataObject.find((FileObject)fo);
            return dao.getLookup().lookupItem(new Lookup.Template(EditorCookie.class)) != null;
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void associateEncoding(VCSFileProxy referenceFile, VCSFileProxy file) {
        FileObject fo = referenceFile.toFileObject();
        if (fo == null || fo.isFolder()) {
            return;
        }
        Charset c = FileEncodingQuery.getEncoding((FileObject)fo);
        if (c == null) {
            return;
        }
        Object object = ENCODING_LOCK;
        synchronized (object) {
            if (fileToCharset == null) {
                fileToCharset = new WeakHashMap<VCSFileProxy, Charset>();
            }
            fileToCharset.put(file, c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Charset getAssociatedEncoding(FileObject fo) {
        try {
            if (fo == null) {
                return null;
            }
            Object object = ENCODING_LOCK;
            synchronized (object) {
                if (fileToCharset == null || fileToCharset.isEmpty()) {
                    return null;
                }
            }
            if (fo.isFolder()) {
                return null;
            }
            VCSFileProxy file = VCSFileProxy.createFileProxy((FileObject)fo);
            if (file == null) {
                return null;
            }
            Object object2 = ENCODING_LOCK;
            synchronized (object2) {
                return fileToCharset.get(file);
            }
        }
        catch (Throwable t) {
            LOG.log(Level.INFO, null, t);
            return null;
        }
    }

    public static void associateEncoding(VCSFileProxy file, Charset charset) {
        FileObject fo = file.toFileObject();
        if (fo == null) {
            LOG.log(Level.WARNING, "associateEncoding() no file object available for {0}", file);
            return;
        }
        VCSFileProxySupport.associateEncoding(fo, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void associateEncoding(FileObject file, Charset charset) {
        if (charset == null) {
            return;
        }
        VCSFileProxy fo = VCSFileProxy.createFileProxy((FileObject)file);
        if (fo == null) {
            return;
        }
        Object object = ENCODING_LOCK;
        synchronized (object) {
            if (fileToCharset == null) {
                fileToCharset = new WeakHashMap<VCSFileProxy, Charset>();
            }
            fileToCharset.put(fo, charset);
        }
    }

    public static String getContextDisplayName(VCSContext ctx) {
        Set nodes = ctx.getFiles();
        int objectCount = nodes.size();
        Node[] activatedNodes = ctx.getElements().lookupAll(Node.class).toArray(new Node[0]);
        boolean projectsOnly = true;
        for (int i = 0; i < activatedNodes.length; ++i) {
            Node activatedNode = activatedNodes[i];
            Project project = (Project)activatedNode.getLookup().lookup(Project.class);
            if (project != null) continue;
            projectsOnly = false;
            break;
        }
        if (projectsOnly) {
            objectCount = activatedNodes.length;
        }
        if (objectCount == 0) {
            return null;
        }
        if (objectCount == 1) {
            if (projectsOnly) {
                return ProjectUtils.getInformation((Project)((Project)activatedNodes[0].getLookup().lookup(Project.class))).getDisplayName();
            }
            FileObject fo = (FileObject)activatedNodes[0].getLookup().lookup(FileObject.class);
            if (fo != null) {
                return fo.getNameExt();
            }
            DataObject dao = (DataObject)activatedNodes[0].getLookup().lookup(DataObject.class);
            if (dao instanceof DataShadow) {
                dao = ((DataShadow)dao).getOriginal();
            }
            if (dao != null) {
                return dao.getPrimaryFile().getNameExt();
            }
            return activatedNodes[0].getDisplayName();
        }
        if (projectsOnly) {
            try {
                return MessageFormat.format(NbBundle.getMessage(VCSFileProxySupport.class, (String)"MSG_ActionContext_MultipleProjects"), objectCount);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return MessageFormat.format(NbBundle.getMessage(VCSFileProxySupport.class, (String)"MSG_ActionContext_MultipleFiles"), objectCount);
    }

    public static Project getProject(VCSFileProxy[] files) {
        for (VCSFileProxy file : files) {
            FileObject fo;
            if (!file.exists()) {
                file = file.getParentFile();
            }
            if ((fo = file.toFileObject()) == null) {
                LOG.log(Level.FINE, "Utils.getProjectFile(): No FileObject for {0}", file);
                continue;
            }
            Project p = FileOwnerQuery.getOwner((FileObject)fo);
            if (p != null) {
                return p;
            }
            LOG.log(Level.FINE, "Utils.getProjectFile(): No project for {0}", file);
        }
        return null;
    }

    public static VCSFileProxy getProjectFile(Project project) {
        if (project == null) {
            return null;
        }
        FileObject fo = project.getProjectDirectory();
        return VCSFileProxy.createFileProxy((FileObject)fo);
    }

    public static Set<VCSFileProxy> getOpenFiles() {
        TopComponent[] comps = TopComponent.getRegistry().getOpened().toArray(new TopComponent[0]);
        HashSet<VCSFileProxy> openFiles = new HashSet<VCSFileProxy>(comps.length);
        for (TopComponent tc : comps) {
            Node[] nodes = tc.getActivatedNodes();
            if (nodes == null) continue;
            for (Node node : nodes) {
                FileObject fo;
                VCSFileProxy file = (VCSFileProxy)node.getLookup().lookup(VCSFileProxy.class);
                if (file == null && (fo = (FileObject)node.getLookup().lookup(FileObject.class)) != null && fo.isData()) {
                    file = VCSFileProxy.createFileProxy((FileObject)fo);
                }
                if (file == null) continue;
                openFiles.add(file);
            }
        }
        return openFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getFileContentsAsByteArray(VCSFileProxy file) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(5120);
        try (BufferedInputStream bis = null;){
            bis = new BufferedInputStream(file.getInputStream(false));
            byte[] buffer = new byte[1024];
            int byteRead = bis.read(buffer);
            while (byteRead > 0) {
                baos.write(buffer, 0, byteRead);
                byteRead = bis.read(buffer);
            }
        }
        return baos.toByteArray();
    }

    static {
        LOG = Logger.getLogger("remote.vcs.logger");
        ENCODING_LOCK = new Object();
    }

    public static final class VCSFileProxyComparator
    implements Comparator<VCSFileProxy> {
        @Override
        public int compare(VCSFileProxy o1, VCSFileProxy o2) {
            return o1.getPath().compareTo(o2.getPath());
        }
    }
}

