/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.ui.build2;

import java.io.File;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.docker.ui.Validations;
import org.netbeans.modules.docker.ui.build2.BuildContextVisual;
import org.netbeans.modules.docker.ui.build2.BuildImageWizard;
import org.netbeans.modules.docker.ui.build2.Bundle;
import org.openide.WizardDescriptor;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;

public class BuildContextPanel
implements WizardDescriptor.Panel<WizardDescriptor>,
WizardDescriptor.FinishablePanel<WizardDescriptor>,
ChangeListener {
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private BuildContextVisual component;
    private WizardDescriptor wizard;

    public BuildContextVisual getComponent() {
        if (this.component == null) {
            this.component = new BuildContextVisual();
            this.component.addChangeListener(this);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isFinishPanel() {
        return BuildImageWizard.isFinishable(this.component.getBuildContext(), (String)this.wizard.getProperty("dockerfile"));
    }

    public boolean isValid() {
        String message;
        String message2;
        this.wizard.putProperty("WizardPanel_errorMessage", null);
        this.wizard.putProperty("WizardPanel_infoMessage", null);
        this.wizard.putProperty("WizardPanel_warningMessage", null);
        String buildContext = this.component.getBuildContext();
        if (buildContext == null || !new File(buildContext).isDirectory()) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)Bundle.MSG_NonExistingBuildContext());
            return false;
        }
        if (this.component.getRepository() == null && this.component.getTag() != null) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)Bundle.MSG_EmptyRepository());
            return false;
        }
        String repository = this.component.getRepository();
        if (repository != null && (message2 = Validations.validateRepository(repository)) != null) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)message2);
            return false;
        }
        String tag = this.component.getTag();
        if (tag != null && (message = Validations.validateTag(tag)) != null) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)message);
            return false;
        }
        return true;
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    public void readSettings(WizardDescriptor wiz) {
        if (this.wizard == null) {
            this.wizard = wiz;
        }
        this.component.setBuildContext((String)wiz.getProperty("buildContext"));
        this.component.setRepository((String)wiz.getProperty("repository"));
        this.component.setTag((String)wiz.getProperty("tag"));
        this.changeSupport.fireChange();
    }

    public void storeSettings(WizardDescriptor wiz) {
        wiz.putProperty("buildContext", (Object)this.component.getBuildContext());
        wiz.putProperty("repository", (Object)this.component.getRepository());
        wiz.putProperty("tag", (Object)this.component.getTag());
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.changeSupport.fireChange();
    }
}

