/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.keystore;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.modules.j2me.keystore.ui.ExportPanel;
import org.netbeans.modules.mobility.cldcplatform.J2MEPlatform;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class MEKeyTool {
    public static String getMEKeyToolPath(Object target) {
        if (target == null) {
            return null;
        }
        if (target instanceof J2MEPlatform) {
            return MEKeyTool.getMEKeyToolPath((J2MEPlatform)target);
        }
        return MEKeyTool.getMEKeyToolPath((J2MEPlatform.Device)target);
    }

    public static String getMEKeyToolPath(J2MEPlatform platform) {
        if (platform == null) {
            return null;
        }
        FileObject toolFO = platform.findTool("mekeytool");
        if (toolFO == null) {
            return null;
        }
        File toolFile = FileUtil.toFile((FileObject)toolFO);
        if (toolFile == null) {
            return null;
        }
        return toolFile.getAbsolutePath();
    }

    public static String getMEKeyToolPath(J2MEPlatform.Device device) {
        Collection<JavaPlatform> javaMEPlatforms = ExportPanel.getJavaMEPlatformsWithoutBdj();
        for (JavaPlatform javaPlatform : javaMEPlatforms) {
            J2MEPlatform.Device[] devices;
            if (!(javaPlatform instanceof J2MEPlatform)) continue;
            J2MEPlatform j2MEPlatform = (J2MEPlatform)javaPlatform;
            for (J2MEPlatform.Device deviceInPlatform : devices = j2MEPlatform.getDevices()) {
                if (!deviceInPlatform.equals(device)) continue;
                String result = MEKeyTool.getMEKeyToolPath(j2MEPlatform);
                return result;
            }
        }
        return null;
    }

    public static String keystoreForDevice(J2MEPlatform.Device device) {
        JavaPlatformManager platformManager = JavaPlatformManager.getDefault();
        for (JavaPlatform platform : platformManager.getInstalledPlatforms()) {
            J2MEPlatform.Device[] devices;
            if (platform == null || !(platform instanceof J2MEPlatform)) continue;
            for (J2MEPlatform.Device dev : devices = ((J2MEPlatform)platform).getDevices()) {
                if (!dev.equals(device)) continue;
                return MEKeyTool.keystorePathForDevice((J2MEPlatform)platform, device.getName());
            }
        }
        return null;
    }

    public static KeyDetail[] listKeys(Object target) {
        if (target == null) {
            return null;
        }
        if (target instanceof J2MEPlatform) {
            return MEKeyTool.listKeys((J2MEPlatform)target);
        }
        J2MEPlatform.Device device = (J2MEPlatform.Device)target;
        String ksPath = MEKeyTool.keystoreForDevice(device);
        if (ksPath == null) {
            return MEKeyTool.listKeys(device);
        }
        return MEKeyTool.listKeysME3(device, ksPath);
    }

    public static KeyDetail[] listKeys(J2MEPlatform platform) {
        String toolString = MEKeyTool.getMEKeyToolPath(platform);
        if (toolString == null) {
            return null;
        }
        try {
            String line;
            BufferedReader br = MEKeyTool.execute(new String[]{toolString, "-list"});
            ArrayList<KeyDetail> list = new ArrayList<KeyDetail>();
            KeyDetail key = null;
            while ((line = br.readLine()) != null) {
                if ("".equals(line)) continue;
                if (line.startsWith("Key ")) {
                    if (key != null) {
                        list.add(key);
                    }
                    try {
                        key = new KeyDetail(Integer.parseInt(line.substring("Key ".length())));
                    }
                    catch (NumberFormatException e) {
                        key = null;
                    }
                    continue;
                }
                if (key == null) continue;
                key.addLine(line);
            }
            if (key != null) {
                list.add(key);
            }
            return list.toArray(new KeyDetail[list.size()]);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static KeyDetail[] listKeysME3(J2MEPlatform.Device device, String ksPath) {
        String toolString = MEKeyTool.getMEKeyToolPath(device);
        if (toolString == null) {
            return null;
        }
        try {
            String line;
            BufferedReader br = MEKeyTool.execute(new String[]{toolString, "-list", "-MEkeystore", ksPath});
            ArrayList<KeyDetail> list = new ArrayList<KeyDetail>();
            KeyDetail key = null;
            while ((line = br.readLine()) != null) {
                if ("".equals(line)) continue;
                if (line.startsWith("Key ")) {
                    if (key != null) {
                        list.add(key);
                    }
                    try {
                        key = new KeyDetail(Integer.parseInt(line.substring("Key ".length())));
                    }
                    catch (NumberFormatException e) {
                        key = null;
                    }
                    continue;
                }
                if (key == null) continue;
                key.addLine(line);
            }
            if (key != null) {
                list.add(key);
            }
            return list.toArray(new KeyDetail[list.size()]);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static KeyDetail[] listKeys(J2MEPlatform.Device device) {
        return MEKeyTool.listKeys(device, null);
    }

    public static KeyDetail[] listKeys(J2MEPlatform.Device device, String client) {
        String toolString = MEKeyTool.getMEKeyToolPath(device);
        if (toolString == null) {
            return null;
        }
        try {
            String line;
            String[] commandToExecute = new String[]{toolString, "-list", "-Xdevice:" + device.getName()};
            if (client != null) {
                commandToExecute = new String[]{toolString, "-list", "-Xdevice:" + device.getName(), "-client", client};
            }
            BufferedReader br = MEKeyTool.execute(commandToExecute);
            ArrayList<KeyDetail> list = new ArrayList<KeyDetail>();
            KeyDetail key = null;
            while ((line = br.readLine()) != null) {
                if ("".equals(line)) continue;
                if (line.startsWith("[")) {
                    int keyNumber = Integer.parseInt(line.substring(1, line.indexOf("]")));
                    key = new KeyDetail(keyNumber);
                    list.add(key);
                    continue;
                }
                if (line.startsWith("Owner") && key != null) {
                    if (line.contains("valid")) {
                        int splitIndex = line.indexOf("valid");
                        key.addLine(line.substring(0, splitIndex));
                        key.addLine(line.substring(splitIndex, line.length()));
                        continue;
                    }
                    key.addLine(line);
                    continue;
                }
                if (key == null) continue;
                key.addLine(line);
            }
            if (key != null && !list.contains(key)) {
                list.add(key);
            }
            return list.toArray(new KeyDetail[list.size()]);
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String keystorePathForDevice(J2MEPlatform platform, final String deviceName) {
        File systemPropsFile = new File(platform.getHomePath() + "/toolkit-lib/modules/bootstrap/conf/system.properties");
        if (!systemPropsFile.exists()) {
            return null;
        }
        Properties systemProps = new Properties();
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(new FileInputStream(systemPropsFile));
            systemProps.load(bis);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        File deviceWorkingDir = new File(System.getProperty("user.home") + File.separatorChar + systemProps.getProperty("toolkits.dir") + File.separatorChar + systemProps.getProperty("release.dir") + File.separatorChar + systemProps.getProperty("work.dir"));
        if (!deviceWorkingDir.exists()) {
            deviceWorkingDir = new File(System.getProperty("user.home") + File.separatorChar + "Library" + File.separatorChar + "Application Support" + File.separatorChar + systemProps.getProperty("toolkits.dir") + File.separatorChar + systemProps.getProperty("release.dir") + File.separatorChar + systemProps.getProperty("work.dir"));
        }
        if (!deviceWorkingDir.exists()) {
            FileObject manager = platform.findTool("emulator");
            if (manager == null) {
                return null;
            }
            try {
                MEKeyTool.execute(new String[]{FileUtil.toFile((FileObject)manager).toString()});
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!deviceWorkingDir.exists()) {
                return null;
            }
        }
        FileObject deviceFolderFO = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)deviceWorkingDir));
        for (FileObject device : deviceFolderFO.getChildren()) {
            FileObject xmlProps = device.getFileObject("properties", "xml");
            if (xmlProps == null) continue;
            final boolean[] inName = new boolean[]{false};
            final boolean[] found = new boolean[]{false};
            try {
                XMLReader reader = XMLUtil.createXMLReader();
                reader.setContentHandler(new DefaultHandler(){

                    @Override
                    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                        if ("void".equals(qName) && "name".equals(attributes.getValue("property"))) {
                            inName[0] = true;
                        }
                    }

                    @Override
                    public void endElement(String uri, String localName, String qName) throws SAXException {
                        if (inName[0] && "string".equals(qName)) {
                            inName[0] = false;
                        }
                    }

                    @Override
                    public void characters(char[] ch, int start, int length) throws SAXException {
                        if (inName[0] && deviceName.equals(new String(ch, start, length))) {
                            found[0] = true;
                        }
                    }
                });
                reader.parse(new InputSource(xmlProps.getInputStream()));
            }
            catch (IOException | SAXException reader) {
                // empty catch block
            }
            if (!found[0]) continue;
            FileObject appDbFO = device.getFileObject("appdb");
            if (null == appDbFO) {
                return null;
            }
            FileObject ksFO = appDbFO.getFileObject("_main.ks");
            if (null == ksFO) {
                return null;
            }
            String ksPath = FileUtil.toFile((FileObject)ksFO).toString();
            return ksPath;
        }
        return null;
    }

    public static String[] listClientsForDevice(J2MEPlatform.Device device) {
        String toolString = MEKeyTool.getMEKeyToolPath(device);
        if (toolString == null) {
            return null;
        }
        ArrayList<String> clientList = new ArrayList<String>();
        try {
            BufferedReader br = MEKeyTool.execute(new String[]{toolString, "-clients", "-Xdevice:" + device.getName()});
            String line = br.readLine();
            while (line != null) {
                if (line.startsWith("Error")) {
                    return null;
                }
                if (!line.isEmpty()) {
                    clientList.add(line);
                }
                line = br.readLine();
            }
        }
        catch (IOException ex) {
            return null;
        }
        if (clientList.size() > 0) {
            clientList.add(0, "<Shared>");
        }
        return clientList.size() > 0 ? clientList.toArray(new String[0]) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedReader execute(String[] arguments) throws IOException {
        File binDir = null;
        if (arguments != null && arguments.length > 0) {
            File execFile = new File(arguments[0]);
            binDir = execFile.exists() ? execFile.getParentFile() : null;
        }
        int os = Utilities.getOperatingSystem();
        Thread currentThread = null;
        int currentPriority = 0;
        Process process = null;
        InputStream inputStream = null;
        InputStream errorStream = null;
        try {
            if (os == 4) {
                currentThread = Thread.currentThread();
                currentPriority = currentThread.getPriority();
                currentThread.setPriority(5);
            }
            process = binDir != null ? Runtime.getRuntime().exec(arguments, null, binDir) : Runtime.getRuntime().exec(arguments);
            inputStream = process.getInputStream();
            errorStream = process.getErrorStream();
        }
        finally {
            if (os == 4) {
                currentThread.setPriority(currentPriority);
            }
        }
        StringBuffer executeOutput = new StringBuffer(1024);
        StringBuffer executeError = new StringBuffer(1024);
        StreamCatcher out = new StreamCatcher(inputStream, executeOutput);
        StreamCatcher err = new StreamCatcher(errorStream, executeError);
        out.start();
        err.start();
        try {
            process.waitFor();
            out.join(10000L);
            err.join(10000L);
        }
        catch (InterruptedException ex) {
            throw (IOException)ErrorManager.getDefault().annotate((Throwable)new IOException(), (Throwable)ex);
        }
        finally {
            process.destroy();
        }
        if (process.exitValue() != 0) {
            throw new IOException(executeOutput.toString());
        }
        return new BufferedReader(new StringReader(executeOutput.toString()));
    }

    private static class StreamCatcher
    extends Thread {
        InputStream is;
        StringBuffer sb;

        StreamCatcher(InputStream is, StringBuffer sb) {
            this.is = is;
            this.sb = sb;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try (InputStreamReader r = new InputStreamReader(this.is);){
                int len;
                char[] buf = new char[256];
                while ((len = r.read(buf)) >= 0) {
                    this.sb.append(buf, 0, len);
                }
            }
            catch (IOException ioEx) {
                ioEx.printStackTrace();
            }
        }
    }

    public static class KeyDetail {
        private final int order;
        private final ArrayList<String> info;

        public KeyDetail(int order) {
            this.order = order;
            this.info = new ArrayList();
        }

        public void addLine(String line) {
            this.info.add(line);
        }

        public int getOrder() {
            return this.order;
        }

        public String[] getInfo() {
            return this.info.toArray(new String[this.info.size()]);
        }

        public String getOwner() {
            for (String s : this.info) {
                if (s == null) continue;
                if ((s = s.trim()).startsWith("Owner:")) {
                    return s.substring("Owner:".length()).trim();
                }
                if (!s.startsWith("Owner ")) continue;
                return s.substring("Owner ".length()).trim();
            }
            return null;
        }
    }
}

