/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spellchecker.bindings.java;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.support.EditorAwareJavaSourceTaskFactory;
import org.netbeans.modules.parsing.spi.TaskIndexingMode;
import org.netbeans.modules.spellchecker.bindings.java.JavaTokenListProvider;
import org.netbeans.modules.spellchecker.spi.language.TokenList;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;

public class JavaSemanticTokenList
implements TokenList {
    private List<Position[]> identifiers;
    private Document doc;
    private int currentIndex;
    private ChangeSupport pcs = new ChangeSupport((Object)this);
    private static Map<FileObject, JavaSemanticTokenList> js2TokenList = new WeakHashMap<FileObject, JavaSemanticTokenList>();

    public synchronized void set(List<Position[]> identifiers, Document doc) {
        this.identifiers = identifiers;
        this.doc = doc;
        this.pcs.fireChange();
    }

    public synchronized void setStartOffset(int offset) {
        if (this.identifiers == null) {
            return;
        }
        this.currentIndex = 0;
        while (this.currentIndex < this.identifiers.size() && this.identifiers.get(this.currentIndex)[0].getOffset() <= offset) {
            ++this.currentIndex;
        }
        if (this.currentIndex < this.identifiers.size()) {
            --this.currentIndex;
        }
    }

    public synchronized boolean nextWord() {
        if (this.identifiers == null) {
            return false;
        }
        return ++this.currentIndex < this.identifiers.size();
    }

    public synchronized int getCurrentWordStartOffset() {
        int result = this.identifiers.get(this.currentIndex)[0].getOffset();
        return result;
    }

    public synchronized CharSequence getCurrentWordText() {
        try {
            String result = this.doc.getText(this.identifiers.get(this.currentIndex)[0].getOffset(), this.identifiers.get(this.currentIndex)[1].getOffset() - this.identifiers.get(this.currentIndex)[0].getOffset());
            return result;
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return "";
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.pcs.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.pcs.removeChangeListener(l);
    }

    static synchronized JavaSemanticTokenList get(FileObject file) {
        if (!JavaTokenListProvider.ENABLE_SEMANTIC_TOKEN_LIST) {
            return null;
        }
        JavaSource js = JavaSource.forFileObject((FileObject)file);
        if (js == null) {
            return null;
        }
        JavaSemanticTokenList l = js2TokenList.get(file);
        if (l == null) {
            l = new JavaSemanticTokenList();
            js2TokenList.put(file, l);
        }
        return l;
    }

    static List<String> separateWords(String ident, List<int[]> subWordsSpans) {
        int currentWordStart = 0;
        int index = 0;
        boolean wasCapital = false;
        LinkedList<String> result = new LinkedList<String>();
        for (char c : ident.toCharArray()) {
            if (Character.isUpperCase(c)) {
                if (!wasCapital && index - currentWordStart > 0) {
                    result.add(ident.substring(currentWordStart, index));
                    subWordsSpans.add(new int[]{currentWordStart, index});
                    currentWordStart = index;
                }
                wasCapital = true;
            } else {
                wasCapital = false;
            }
            ++index;
        }
        if (index - currentWordStart > 0) {
            result.add(ident.substring(currentWordStart, index));
            subWordsSpans.add(new int[]{currentWordStart, index});
        }
        return result;
    }

    static void handleIdentifier(Document doc, List<Position[]> p, int[] span, String name) {
        if (span == null) {
            return;
        }
        LinkedList<int[]> spans = new LinkedList<int[]>();
        List<String> separatedWords = JavaSemanticTokenList.separateWords(name, spans);
        for (int[] s : spans) {
            try {
                p.add(new Position[]{doc.createPosition(span[0] + s[0]), doc.createPosition(span[0] + s[1])});
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public static final class FactoryImpl
    extends EditorAwareJavaSourceTaskFactory {
        public FactoryImpl() {
            super(JavaSource.Phase.PARSED, JavaSource.Priority.LOW, TaskIndexingMode.ALLOWED_DURING_SCAN, new String[0]);
        }

        protected CancellableTask<CompilationInfo> createTask(FileObject file) {
            return new TaskImpl();
        }
    }

    public static final class TaskImpl
    implements CancellableTask<CompilationInfo> {
        public void cancel() {
        }

        public void run(CompilationInfo parameter) throws Exception {
            JavaSemanticTokenList l = JavaSemanticTokenList.get(parameter.getFileObject());
            if (l == null) {
                return;
            }
            Document doc = parameter.getDocument();
            if (doc == null) {
                return;
            }
            ScannerImpl si = new ScannerImpl(doc, parameter);
            ArrayList<Position[]> pos = new ArrayList<Position[]>();
            si.scan(parameter.getCompilationUnit(), pos);
            l.set(pos, parameter.getDocument());
        }

        private static final class ScannerImpl
        extends TreeScanner<Void, List<Position[]>> {
            private Document doc;
            private CompilationInfo info;

            public ScannerImpl(Document doc, CompilationInfo info) {
                this.doc = doc;
                this.info = info;
            }

            @Override
            public Void visitClass(ClassTree node, List<Position[]> p) {
                int[] span = this.info.getTreeUtilities().findNameSpan(node);
                JavaSemanticTokenList.handleIdentifier(this.doc, p, span, node.getSimpleName().toString());
                return (Void)super.visitClass(node, p);
            }

            @Override
            public Void visitMethod(MethodTree node, List<Position[]> p) {
                int[] span = this.info.getTreeUtilities().findNameSpan(node);
                JavaSemanticTokenList.handleIdentifier(this.doc, p, span, node.getName().toString());
                return (Void)super.visitMethod(node, p);
            }

            @Override
            public Void visitVariable(VariableTree node, List<Position[]> p) {
                int[] span = this.info.getTreeUtilities().findNameSpan(node);
                JavaSemanticTokenList.handleIdentifier(this.doc, p, span, node.getName().toString());
                return (Void)super.visitVariable(node, p);
            }
        }
    }
}

