/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.mixeddev.java.jni.actions;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import javax.swing.text.Document;
import org.netbeans.modules.cnd.mixeddev.MixedDevUtils;
import org.netbeans.modules.cnd.mixeddev.Triple;
import org.netbeans.modules.cnd.mixeddev.java.JNISupport;
import org.netbeans.modules.cnd.mixeddev.java.jni.actions.AbstractJNIAction;
import org.netbeans.modules.cnd.mixeddev.java.model.JavaClassInfo;
import org.netbeans.modules.cnd.mixeddev.java.model.JavaEntityInfo;
import org.netbeans.modules.cnd.mixeddev.java.model.JavaFieldInfo;
import org.netbeans.modules.cnd.mixeddev.java.model.JavaMethodInfo;
import org.openide.awt.StatusDisplayer;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class CopyJNISignatureAction
extends AbstractJNIAction {
    public CopyJNISignatureAction(Lookup context) {
        super(context);
        this.putValue("Name", NbBundle.getMessage(MixedDevUtils.class, (String)"cnd.mixeddev.copy_jni_signature"));
    }

    @Override
    protected boolean isEnabledAtPosition(Document doc, int caret) {
        JavaEntityInfo entity = this.resolveJavaEntity(doc, caret);
        if (entity != null) {
            if (entity instanceof JavaMethodInfo) {
                return !((JavaMethodInfo)entity).isNative();
            }
            return true;
        }
        return false;
    }

    @Override
    protected void actionPerformedImpl(Node[] activatedNodes) {
        Triple<DataObject, Document, Integer> context = this.extractContext(activatedNodes);
        if (context != null) {
            Document doc = (Document)context.second;
            int caret = (Integer)context.third;
            String jniSignature = null;
            JavaEntityInfo entity = this.resolveJavaEntity(doc, caret);
            if (entity instanceof JavaClassInfo) {
                jniSignature = JNISupport.getJNISignature((JavaClassInfo)entity);
            } else if (entity instanceof JavaMethodInfo) {
                jniSignature = JNISupport.getJNISignature((JavaMethodInfo)entity);
            } else if (entity instanceof JavaFieldInfo) {
                jniSignature = JNISupport.getJNISignature((JavaFieldInfo)entity);
            }
            if (jniSignature != null) {
                StatusDisplayer.getDefault().setStatusText(jniSignature);
                StringSelection ss = new StringSelection(jniSignature);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(ss, null);
            }
        }
    }
}

