/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.nodes;

import java.awt.Dialog;
import java.awt.Image;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JSeparator;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.websvc.api.jaxws.bindings.BindingsHandler;
import org.netbeans.modules.websvc.api.jaxws.bindings.BindingsHandlerChain;
import org.netbeans.modules.websvc.api.jaxws.bindings.BindingsHandlerChains;
import org.netbeans.modules.websvc.api.jaxws.bindings.BindingsHandlerClass;
import org.netbeans.modules.websvc.api.jaxws.bindings.BindingsModel;
import org.netbeans.modules.websvc.api.jaxws.bindings.BindingsModelFactory;
import org.netbeans.modules.websvc.api.jaxws.bindings.DefinitionsBindings;
import org.netbeans.modules.websvc.api.jaxws.bindings.GlobalBindings;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.modules.websvc.api.jaxws.project.config.Binding;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModel;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModelListener;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModeler;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModelerFactory;
import org.netbeans.modules.websvc.api.support.ConfigureHandlerCookie;
import org.netbeans.modules.websvc.core.jaxws.actions.JaxWsRefreshAction;
import org.netbeans.modules.websvc.core.jaxws.nodes.ClientHandlerButtonListener;
import org.netbeans.modules.websvc.core.jaxws.nodes.JaxWsClientChildren;
import org.netbeans.modules.websvc.core.jaxws.nodes.JaxWsNode;
import org.netbeans.modules.websvc.core.jaxws.nodes.RefreshClientDialog;
import org.netbeans.modules.websvc.core.wseditor.support.EditWSAttributesCookieImpl;
import org.netbeans.modules.websvc.core.wseditor.support.WSEditAttributesAction;
import org.netbeans.modules.websvc.jaxws.api.JaxWsRefreshCookie;
import org.netbeans.modules.websvc.spi.support.ConfigureHandlerAction;
import org.netbeans.modules.websvc.spi.support.MessageHandlerPanel;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.xam.ModelSource;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.actions.DeleteAction;
import org.openide.actions.OpenAction;
import org.openide.actions.PropertiesAction;
import org.openide.cookies.EditCookie;
import org.openide.cookies.OpenCookie;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;

public class JaxWsClientNode
extends AbstractNode
implements OpenCookie,
JaxWsRefreshCookie,
ConfigureHandlerCookie {
    Client client;
    FileObject srcRoot;
    JaxWsModel jaxWsModel;
    InstanceContent content;
    private FileObject wsdlFileObject;
    boolean modelGenerationFinished;
    public static final String CONTEXT = "context";
    private static final String WAITING_BADGE = "org/netbeans/modules/websvc/core/webservices/ui/resources/waiting.png";
    private static final String ERROR_BADGE = "org/netbeans/modules/websvc/core/webservices/ui/resources/error-badge.gif";
    private static final String SERVICE_BADGE = "org/netbeans/modules/websvc/core/webservices/ui/resources/XMLServiceDataIcon.png";
    private Image cachedWaitingBadge;
    private Image cachedErrorBadge;
    private Image cachedServiceBadge;

    public JaxWsClientNode(JaxWsModel jaxWsModel, Client client, FileObject srcRoot) {
        this(jaxWsModel, client, srcRoot, new InstanceContent());
    }

    private JaxWsClientNode(JaxWsModel jaxWsModel, Client client, FileObject srcRoot, InstanceContent content) {
        super((Children)new JaxWsClientChildren(client, srcRoot), (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        this.jaxWsModel = jaxWsModel;
        this.client = client;
        this.srcRoot = srcRoot;
        this.content = content;
        this.setName(client.getName());
        this.setDisplayName(client.getName());
        content.add((Object)this);
        content.add((Object)client);
        content.add((Object)srcRoot);
        WsdlModeler modeler = this.getWsdlModeler();
        if (modeler != null) {
            this.changeIcon();
            modeler.generateWsdlModel(new WsdlModelListener(){

                public void modelCreated(WsdlModel model) {
                    JaxWsClientNode.this.modelGenerationFinished = true;
                    JaxWsClientNode.this.changeIcon();
                }
            });
        }
        content.add((Object)new EditWSAttributesCookieImpl((Node)this, jaxWsModel));
        this.setValue("wsdl-url", client.getWsdlUrl());
    }

    public WsdlModel getWsdlModel() {
        return this.getWsdlModeler().getAndWaitForWsdlModel();
    }

    public String getShortDescription() {
        return this.client.getWsdlUrl();
    }

    public Image getIcon(int type) {
        if (((JaxWsClientChildren)this.getChildren()).getWsdlModel() != null) {
            return this.getServiceImage();
        }
        WsdlModeler wsdlModeler = this.getWsdlModeler();
        if (wsdlModeler != null && wsdlModeler.getCreationException() == null) {
            if (this.modelGenerationFinished) {
                return this.getServiceImage();
            }
            return ImageUtilities.mergeImages((Image)this.getServiceImage(), (Image)this.getWaitingBadge(), (int)15, (int)8);
        }
        Image dirtyNodeImage = ImageUtilities.mergeImages((Image)this.getServiceImage(), (Image)this.getErrorBadge(), (int)6, (int)6);
        if (this.modelGenerationFinished) {
            return dirtyNodeImage;
        }
        return ImageUtilities.mergeImages((Image)dirtyNodeImage, (Image)this.getWaitingBadge(), (int)15, (int)8);
    }

    private Image getServiceImage() {
        if (this.cachedServiceBadge == null) {
            this.cachedServiceBadge = ImageUtilities.loadImage((String)SERVICE_BADGE);
        }
        return this.cachedServiceBadge;
    }

    private Image getErrorBadge() {
        if (this.cachedErrorBadge == null) {
            this.cachedErrorBadge = ImageUtilities.loadImage((String)ERROR_BADGE);
        }
        return this.cachedErrorBadge;
    }

    private Image getWaitingBadge() {
        if (this.cachedWaitingBadge == null) {
            this.cachedWaitingBadge = ImageUtilities.loadImage((String)WAITING_BADGE);
        }
        return this.cachedWaitingBadge;
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public void open() {
        EditCookie ec = this.getEditCookie();
        if (ec != null) {
            ec.edit();
        }
    }

    void changeIcon() {
        this.fireIconChange();
    }

    @SuppressWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    private EditCookie getEditCookie() {
        try {
            String relativePath = this.client.getLocalWsdlFile();
            if (relativePath != null) {
                JAXWSClientSupport support = JAXWSClientSupport.getJaxWsClientSupport((FileObject)this.srcRoot);
                if (support == null) {
                    return null;
                }
                FileObject wsdlFolder = support.getLocalWsdlFolderForClient(this.client.getName(), false);
                if (wsdlFolder != null) {
                    FileObject wsdlFo = wsdlFolder.getFileObject(relativePath);
                    assert (wsdlFo != null) : "Cannot find local WSDL file";
                    if (wsdlFo != null) {
                        DataObject dObj = DataObject.find((FileObject)wsdlFo);
                        return (EditCookie)dObj.getCookie(EditCookie.class);
                    }
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(JaxWsClientNode.class.getName()).log(Level.INFO, "Cannot find data object for wsdl file", ex);
        }
        return null;
    }

    public Action getPreferredAction() {
        return SystemAction.get(OpenAction.class);
    }

    public Action[] getActions(boolean context) {
        ArrayList<CallableSystemAction> actions = new ArrayList<CallableSystemAction>(Arrays.asList((CallableSystemAction)SystemAction.get(OpenAction.class), (CallableSystemAction)SystemAction.get(JaxWsRefreshAction.class), null, (CallableSystemAction)SystemAction.get(WSEditAttributesAction.class), null, (CallableSystemAction)SystemAction.get(ConfigureHandlerAction.class), null, (CallableSystemAction)SystemAction.get(DeleteAction.class), null, (CallableSystemAction)SystemAction.get(PropertiesAction.class)));
        this.addFromLayers(actions, "WebServices/Clients/Actions");
        return actions.toArray(new Action[actions.size()]);
    }

    private void addFromLayers(ArrayList<Action> actions, String path) {
        Lookup look = Lookups.forPath((String)path);
        for (Object next : look.lookupAll(Object.class)) {
            if (next instanceof Action) {
                actions.add((Action)next);
                continue;
            }
            if (!(next instanceof JSeparator)) continue;
            actions.add(null);
        }
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean canDestroy() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws IOException {
        String clientName = this.client.getName();
        JAXWSClientSupport support = JAXWSClientSupport.getJaxWsClientSupport((FileObject)this.srcRoot);
        if (support != null) {
            FileObject buildImplFo;
            FileObject webInfClientFolder;
            Project project;
            FileObject localWsdlFolder = support.getLocalWsdlFolderForClient(clientName, false);
            if (localWsdlFolder != null) {
                FileObject clientArtifactsFolder = localWsdlFolder.getParent();
                FileLock lock = null;
                try {
                    lock = clientArtifactsFolder.lock();
                    clientArtifactsFolder.delete(lock);
                }
                finally {
                    if (lock != null) {
                        lock.releaseLock();
                    }
                }
            }
            if ((project = FileOwnerQuery.getOwner((FileObject)this.srcRoot)).getLookup().lookup(J2eeModuleProvider.class) != null && (webInfClientFolder = this.findWsdlFolderForClient(support, clientName)) != null) {
                FileObject webInfClientRootFolder = webInfClientFolder.getParent();
                FileLock lock = null;
                try {
                    lock = webInfClientFolder.lock();
                    webInfClientFolder.delete(lock);
                }
                finally {
                    if (lock != null) {
                        lock.releaseLock();
                    }
                }
                if (webInfClientRootFolder.getChildren().length == 0) {
                    try {
                        lock = webInfClientRootFolder.lock();
                        webInfClientRootFolder.delete(lock);
                    }
                    finally {
                        if (lock != null) {
                            lock.releaseLock();
                        }
                    }
                }
            }
            if ((buildImplFo = project.getProjectDirectory().getFileObject("build.xml")) != null) {
                try {
                    ExecutorTask wsimportTask = ActionUtils.runTarget((FileObject)buildImplFo, (String[])new String[]{"wsimport-client-clean-" + clientName}, null);
                    wsimportTask.waitFinished();
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().log(ex.getLocalizedMessage());
                }
                catch (IllegalArgumentException ex) {
                    ErrorManager.getDefault().log(ex.getLocalizedMessage());
                }
            }
            support.removeServiceClient(clientName);
        }
        super.destroy();
    }

    public void refreshService(boolean downloadWsdl) {
        this.setValue(CONTEXT, new HashMap());
        if (downloadWsdl) {
            String result = RefreshClientDialog.open(this.client.getWsdlUrl());
            if ("close".equals(result)) {
                return;
            }
            if ("no_download".equals(result)) {
                ((JaxWsClientChildren)this.getChildren()).refreshKeys(false);
            } else {
                this.wsdlFileObject = null;
                ((JaxWsClientChildren)this.getChildren()).refreshKeys(true, result);
            }
        } else {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(JaxWsClientNode.class, (String)"HINT_RefreshClient")));
            ((JaxWsClientChildren)this.getChildren()).refreshKeys(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeWsdlFolderContents() {
        FileObject wsdlFolder = this.getJAXWSClientSupport().getLocalWsdlFolderForClient(this.getName(), false);
        if (wsdlFolder != null) {
            FileLock lock = null;
            FileObject[] files = wsdlFolder.getChildren();
            for (int i = 0; i < files.length; ++i) {
                try {
                    FileObject file = files[i];
                    lock = file.lock();
                    file.delete(lock);
                    continue;
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                    continue;
                }
                finally {
                    if (lock != null) {
                        lock.releaseLock();
                        lock = null;
                    }
                }
            }
        }
    }

    public void configureHandler() {
        DefinitionsBindings db;
        GlobalBindings gb;
        Project project = FileOwnerQuery.getOwner((FileObject)this.srcRoot);
        ArrayList<String> handlerClasses = new ArrayList<String>();
        BindingsModel bindingsModel = this.getBindingsModel();
        if (bindingsModel != null && (gb = bindingsModel.getGlobalBindings()) != null && (db = gb.getDefinitionsBindings()) != null) {
            BindingsHandlerChains handlerChains = db.getHandlerChains();
            BindingsHandlerChain handlerChain = (BindingsHandlerChain)handlerChains.getHandlerChains().iterator().next();
            Collection handlers = handlerChain.getHandlers();
            for (BindingsHandler handler : handlers) {
                BindingsHandlerClass handlerClass = handler.getHandlerClass();
                handlerClasses.add(handlerClass.getClassName());
            }
        }
        MessageHandlerPanel panel = new MessageHandlerPanel(project, handlerClasses, true, this.client.getName());
        String title = NbBundle.getMessage(JaxWsNode.class, (String)"TTL_MessageHandlerPanel");
        DialogDescriptor dialogDesc = new DialogDescriptor((Object)panel, title);
        dialogDesc.setButtonListener((ActionListener)new ClientHandlerButtonListener(panel, bindingsModel, this.client, (Node)this, this.jaxWsModel));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDesc);
        dialog.getAccessibleContext().setAccessibleDescription(dialog.getTitle());
        dialog.setVisible(true);
    }

    private BindingsModel getBindingsModel() {
        String handlerBindingFile = this.client.getHandlerBindingFile();
        BindingsModel bindingsModel = null;
        try {
            FileObject handlerBindingFO;
            JAXWSClientSupport support;
            FileObject bindingsFolder;
            if (handlerBindingFile != null && (bindingsFolder = (support = JAXWSClientSupport.getJaxWsClientSupport((FileObject)this.srcRoot)).getBindingsFolderForClient(this.getName(), false)) != null && (handlerBindingFO = bindingsFolder.getFileObject(handlerBindingFile)) != null) {
                ModelSource ms = Utilities.getModelSource((FileObject)handlerBindingFO, (boolean)true);
                bindingsModel = BindingsModelFactory.getDefault().getModel(ms);
            }
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return null;
        }
        return bindingsModel;
    }

    WsdlModeler getWsdlModeler() {
        if (this.getLocalWsdl() != null) {
            try {
                WsdlModeler modeler = WsdlModelerFactory.getDefault().getWsdlModeler(this.wsdlFileObject.getURL());
                if (modeler != null) {
                    String packageName = this.client.getPackageName();
                    if (packageName != null && this.client.isPackageNameForceReplace()) {
                        modeler.setPackageName(packageName);
                    } else {
                        modeler.setPackageName(null);
                    }
                    modeler.setCatalog(this.getJAXWSClientSupport().getCatalog());
                    this.setBindings(modeler);
                    return modeler;
                }
            }
            catch (FileStateInvalidException ex) {
                ErrorManager.getDefault().log(ex.getLocalizedMessage());
            }
        } else {
            ErrorManager.getDefault().log(65536, NbBundle.getMessage(JaxWsNode.class, (String)"ERR_missingLocalWsdl"));
        }
        return null;
    }

    FileObject getLocalWsdl() {
        String relativePath;
        FileObject localWsdlocalFolder;
        if (this.wsdlFileObject == null && (localWsdlocalFolder = this.getJAXWSClientSupport().getLocalWsdlFolderForClient(this.client.getName(), false)) != null && (relativePath = this.client.getLocalWsdlFile()) != null) {
            this.wsdlFileObject = localWsdlocalFolder.getFileObject(relativePath);
        }
        return this.wsdlFileObject;
    }

    private JAXWSClientSupport getJAXWSClientSupport() {
        return JAXWSClientSupport.getJaxWsClientSupport((FileObject)this.srcRoot);
    }

    private void setBindings(WsdlModeler wsdlModeler) {
        Binding[] extbindings = this.client.getBindings();
        if (extbindings == null || extbindings.length == 0) {
            wsdlModeler.setJAXBBindings(null);
            return;
        }
        String[] bindingFiles = new String[extbindings.length];
        for (int i = 0; i < extbindings.length; ++i) {
            bindingFiles[i] = extbindings[i].getFileName();
        }
        FileObject bindingsFolder = this.getJAXWSClientSupport().getBindingsFolderForClient(this.getName(), true);
        ArrayList<URL> list = new ArrayList<URL>();
        for (int i = 0; i < bindingFiles.length; ++i) {
            FileObject fo = bindingsFolder.getFileObject(bindingFiles[i]);
            if (fo == null) continue;
            try {
                list.add(fo.getURL());
                continue;
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
        }
        URL[] bindings = new URL[list.size()];
        list.toArray(bindings);
        wsdlModeler.setJAXBBindings(bindings);
    }

    void setModelGenerationFinished(boolean value) {
        this.modelGenerationFinished = value;
    }

    JaxWsModel getJaxWsModel() {
        return this.jaxWsModel;
    }

    private FileObject findWsdlFolderForClient(JAXWSClientSupport support, String name) throws IOException {
        FileObject globalWsdlFolder = support.getWsdlFolder(false);
        if (globalWsdlFolder != null) {
            return globalWsdlFolder.getFileObject("client/" + name);
        }
        return null;
    }
}

