/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.core;

import java.lang.reflect.Method;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import org.springframework.jms.JmsException;
import org.springframework.jms.connection.ConnectionFactoryUtils;
import org.springframework.jms.connection.JmsResourceHolder;
import org.springframework.jms.core.BrowserCallback;
import org.springframework.jms.core.JmsOperations;
import org.springframework.jms.core.MessageCreator;
import org.springframework.jms.core.MessagePostProcessor;
import org.springframework.jms.core.ProducerCallback;
import org.springframework.jms.core.SessionCallback;
import org.springframework.jms.support.JmsUtils;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.converter.SimpleMessageConverter;
import org.springframework.jms.support.destination.JmsDestinationAccessor;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class JmsTemplate
extends JmsDestinationAccessor
implements JmsOperations {
    public static final long RECEIVE_TIMEOUT_NO_WAIT = -1L;
    public static final long RECEIVE_TIMEOUT_INDEFINITE_WAIT = 0L;
    private static final Method setDeliveryDelayMethod = ClassUtils.getMethodIfAvailable(MessageProducer.class, (String)"setDeliveryDelay", (Class[])new Class[]{Long.TYPE});
    private final JmsTemplateResourceFactory transactionalResourceFactory = new JmsTemplateResourceFactory();
    private Object defaultDestination;
    private MessageConverter messageConverter;
    private boolean messageIdEnabled = true;
    private boolean messageTimestampEnabled = true;
    private boolean pubSubNoLocal = false;
    private long receiveTimeout = 0L;
    private long deliveryDelay = 0L;
    private boolean explicitQosEnabled = false;
    private int deliveryMode = 2;
    private int priority = 4;
    private long timeToLive = 0L;

    public JmsTemplate() {
        this.initDefaultStrategies();
    }

    public JmsTemplate(ConnectionFactory connectionFactory) {
        this();
        this.setConnectionFactory(connectionFactory);
        this.afterPropertiesSet();
    }

    protected void initDefaultStrategies() {
        this.setMessageConverter(new SimpleMessageConverter());
    }

    public void setDefaultDestination(Destination destination) {
        this.defaultDestination = destination;
    }

    public Destination getDefaultDestination() {
        return this.defaultDestination instanceof Destination ? (Destination)this.defaultDestination : null;
    }

    private Queue getDefaultQueue() {
        Destination defaultDestination = this.getDefaultDestination();
        if (defaultDestination != null && !(defaultDestination instanceof Queue)) {
            throw new IllegalStateException("'defaultDestination' does not correspond to a Queue. Check configuration of JmsTemplate.");
        }
        return (Queue)defaultDestination;
    }

    public void setDefaultDestinationName(String destinationName) {
        this.defaultDestination = destinationName;
    }

    public String getDefaultDestinationName() {
        return this.defaultDestination instanceof String ? (String)this.defaultDestination : null;
    }

    private String getRequiredDefaultDestinationName() throws IllegalStateException {
        String name = this.getDefaultDestinationName();
        if (name == null) {
            throw new IllegalStateException("No 'defaultDestination' or 'defaultDestinationName' specified. Check configuration of JmsTemplate.");
        }
        return name;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public MessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    private MessageConverter getRequiredMessageConverter() throws IllegalStateException {
        MessageConverter converter = this.getMessageConverter();
        if (converter == null) {
            throw new IllegalStateException("No 'messageConverter' specified. Check configuration of JmsTemplate.");
        }
        return converter;
    }

    public void setMessageIdEnabled(boolean messageIdEnabled) {
        this.messageIdEnabled = messageIdEnabled;
    }

    public boolean isMessageIdEnabled() {
        return this.messageIdEnabled;
    }

    public void setMessageTimestampEnabled(boolean messageTimestampEnabled) {
        this.messageTimestampEnabled = messageTimestampEnabled;
    }

    public boolean isMessageTimestampEnabled() {
        return this.messageTimestampEnabled;
    }

    public void setPubSubNoLocal(boolean pubSubNoLocal) {
        this.pubSubNoLocal = pubSubNoLocal;
    }

    public boolean isPubSubNoLocal() {
        return this.pubSubNoLocal;
    }

    public void setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public long getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public void setDeliveryDelay(long deliveryDelay) {
        this.deliveryDelay = deliveryDelay;
    }

    public long getDeliveryDelay() {
        return this.deliveryDelay;
    }

    public void setExplicitQosEnabled(boolean explicitQosEnabled) {
        this.explicitQosEnabled = explicitQosEnabled;
    }

    public boolean isExplicitQosEnabled() {
        return this.explicitQosEnabled;
    }

    public void setDeliveryPersistent(boolean deliveryPersistent) {
        this.deliveryMode = deliveryPersistent ? 2 : 1;
    }

    public void setDeliveryMode(int deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    public int getDeliveryMode() {
        return this.deliveryMode;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    @Override
    public <T> T execute(SessionCallback<T> action) throws JmsException {
        return this.execute(action, false);
    }

    public <T> T execute(SessionCallback<T> action, boolean startConnection) throws JmsException {
        T t;
        Assert.notNull(action, (String)"Callback object must not be null");
        Connection conToClose = null;
        Session sessionToClose = null;
        try {
            Session sessionToUse = ConnectionFactoryUtils.doGetTransactionalSession(this.getConnectionFactory(), this.transactionalResourceFactory, startConnection);
            if (sessionToUse == null) {
                conToClose = this.createConnection();
                sessionToClose = this.createSession(conToClose);
                if (startConnection) {
                    conToClose.start();
                }
                sessionToUse = sessionToClose;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Executing callback on JMS Session: " + sessionToUse));
            }
            t = action.doInJms(sessionToUse);
        }
        catch (JMSException ex) {
            try {
                throw this.convertJmsAccessException(ex);
            }
            catch (Throwable throwable) {
                JmsUtils.closeSession(sessionToClose);
                ConnectionFactoryUtils.releaseConnection(conToClose, this.getConnectionFactory(), startConnection);
                throw throwable;
            }
        }
        JmsUtils.closeSession(sessionToClose);
        ConnectionFactoryUtils.releaseConnection(conToClose, this.getConnectionFactory(), startConnection);
        return t;
    }

    @Override
    public <T> T execute(ProducerCallback<T> action) throws JmsException {
        String defaultDestinationName = this.getDefaultDestinationName();
        if (defaultDestinationName != null) {
            return this.execute(defaultDestinationName, action);
        }
        return this.execute(this.getDefaultDestination(), action);
    }

    @Override
    public <T> T execute(final Destination destination, final ProducerCallback<T> action) throws JmsException {
        Assert.notNull(action, (String)"Callback object must not be null");
        return this.execute(new SessionCallback<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T doInJms(Session session) throws JMSException {
                MessageProducer producer = JmsTemplate.this.createProducer(session, destination);
                try {
                    Object t = action.doInJms(session, producer);
                    return t;
                }
                finally {
                    JmsUtils.closeMessageProducer(producer);
                }
            }
        }, false);
    }

    @Override
    public <T> T execute(final String destinationName, final ProducerCallback<T> action) throws JmsException {
        Assert.notNull(action, (String)"Callback object must not be null");
        return this.execute(new SessionCallback<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T doInJms(Session session) throws JMSException {
                Destination destination = JmsTemplate.this.resolveDestinationName(session, destinationName);
                MessageProducer producer = JmsTemplate.this.createProducer(session, destination);
                try {
                    Object t = action.doInJms(session, producer);
                    return t;
                }
                finally {
                    JmsUtils.closeMessageProducer(producer);
                }
            }
        }, false);
    }

    @Override
    public void send(MessageCreator messageCreator) throws JmsException {
        Destination defaultDestination = this.getDefaultDestination();
        if (defaultDestination != null) {
            this.send(defaultDestination, messageCreator);
        } else {
            this.send(this.getRequiredDefaultDestinationName(), messageCreator);
        }
    }

    @Override
    public void send(final Destination destination, final MessageCreator messageCreator) throws JmsException {
        this.execute(new SessionCallback<Object>(){

            @Override
            public Object doInJms(Session session) throws JMSException {
                JmsTemplate.this.doSend(session, destination, messageCreator);
                return null;
            }
        }, false);
    }

    @Override
    public void send(final String destinationName, final MessageCreator messageCreator) throws JmsException {
        this.execute(new SessionCallback<Object>(){

            @Override
            public Object doInJms(Session session) throws JMSException {
                Destination destination = JmsTemplate.this.resolveDestinationName(session, destinationName);
                JmsTemplate.this.doSend(session, destination, messageCreator);
                return null;
            }
        }, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSend(Session session, Destination destination, MessageCreator messageCreator) throws JMSException {
        Assert.notNull((Object)messageCreator, (String)"MessageCreator must not be null");
        MessageProducer producer = this.createProducer(session, destination);
        try {
            Message message = messageCreator.createMessage(session);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Sending created message: " + message));
            }
            this.doSend(producer, message);
            if (session.getTransacted() && this.isSessionLocallyTransacted(session)) {
                JmsUtils.commitIfNecessary(session);
            }
        }
        finally {
            JmsUtils.closeMessageProducer(producer);
        }
    }

    protected void doSend(MessageProducer producer, Message message) throws JMSException {
        if (this.deliveryDelay > 0L) {
            if (setDeliveryDelayMethod == null) {
                throw new IllegalStateException("setDeliveryDelay requires JMS 2.0");
            }
            ReflectionUtils.invokeMethod((Method)setDeliveryDelayMethod, (Object)producer, (Object[])new Object[]{this.deliveryDelay});
        }
        if (this.isExplicitQosEnabled()) {
            producer.send(message, this.getDeliveryMode(), this.getPriority(), this.getTimeToLive());
        } else {
            producer.send(message);
        }
    }

    @Override
    public void convertAndSend(Object message) throws JmsException {
        Destination defaultDestination = this.getDefaultDestination();
        if (defaultDestination != null) {
            this.convertAndSend(defaultDestination, message);
        } else {
            this.convertAndSend(this.getRequiredDefaultDestinationName(), message);
        }
    }

    @Override
    public void convertAndSend(Destination destination, final Object message) throws JmsException {
        this.send(destination, new MessageCreator(){

            @Override
            public Message createMessage(Session session) throws JMSException {
                return JmsTemplate.this.getRequiredMessageConverter().toMessage(message, session);
            }
        });
    }

    @Override
    public void convertAndSend(String destinationName, final Object message) throws JmsException {
        this.send(destinationName, new MessageCreator(){

            @Override
            public Message createMessage(Session session) throws JMSException {
                return JmsTemplate.this.getRequiredMessageConverter().toMessage(message, session);
            }
        });
    }

    @Override
    public void convertAndSend(Object message, MessagePostProcessor postProcessor) throws JmsException {
        Destination defaultDestination = this.getDefaultDestination();
        if (defaultDestination != null) {
            this.convertAndSend(defaultDestination, message, postProcessor);
        } else {
            this.convertAndSend(this.getRequiredDefaultDestinationName(), message, postProcessor);
        }
    }

    @Override
    public void convertAndSend(Destination destination, final Object message, final MessagePostProcessor postProcessor) throws JmsException {
        this.send(destination, new MessageCreator(){

            @Override
            public Message createMessage(Session session) throws JMSException {
                Message msg = JmsTemplate.this.getRequiredMessageConverter().toMessage(message, session);
                return postProcessor.postProcessMessage(msg);
            }
        });
    }

    @Override
    public void convertAndSend(String destinationName, final Object message, final MessagePostProcessor postProcessor) throws JmsException {
        this.send(destinationName, new MessageCreator(){

            @Override
            public Message createMessage(Session session) throws JMSException {
                Message msg = JmsTemplate.this.getRequiredMessageConverter().toMessage(message, session);
                return postProcessor.postProcessMessage(msg);
            }
        });
    }

    @Override
    public Message receive() throws JmsException {
        Destination defaultDestination = this.getDefaultDestination();
        if (defaultDestination != null) {
            return this.receive(defaultDestination);
        }
        return this.receive(this.getRequiredDefaultDestinationName());
    }

    @Override
    public Message receive(Destination destination) throws JmsException {
        return this.receiveSelected(destination, null);
    }

    @Override
    public Message receive(String destinationName) throws JmsException {
        return this.receiveSelected(destinationName, null);
    }

    @Override
    public Message receiveSelected(String messageSelector) throws JmsException {
        Destination defaultDestination = this.getDefaultDestination();
        if (defaultDestination != null) {
            return this.receiveSelected(defaultDestination, messageSelector);
        }
        return this.receiveSelected(this.getRequiredDefaultDestinationName(), messageSelector);
    }

    @Override
    public Message receiveSelected(final Destination destination, final String messageSelector) throws JmsException {
        return this.execute(new SessionCallback<Message>(){

            @Override
            public Message doInJms(Session session) throws JMSException {
                return JmsTemplate.this.doReceive(session, destination, messageSelector);
            }
        }, true);
    }

    @Override
    public Message receiveSelected(final String destinationName, final String messageSelector) throws JmsException {
        return this.execute(new SessionCallback<Message>(){

            @Override
            public Message doInJms(Session session) throws JMSException {
                Destination destination = JmsTemplate.this.resolveDestinationName(session, destinationName);
                return JmsTemplate.this.doReceive(session, destination, messageSelector);
            }
        }, true);
    }

    protected Message doReceive(Session session, Destination destination, String messageSelector) throws JMSException {
        return this.doReceive(session, this.createConsumer(session, destination, messageSelector));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message doReceive(Session session, MessageConsumer consumer) throws JMSException {
        try {
            long timeout = this.getReceiveTimeout();
            JmsResourceHolder resourceHolder = (JmsResourceHolder)((Object)TransactionSynchronizationManager.getResource((Object)this.getConnectionFactory()));
            if (resourceHolder != null && resourceHolder.hasTimeout()) {
                timeout = Math.min(timeout, resourceHolder.getTimeToLiveInMillis());
            }
            Message message = this.doReceive(consumer, timeout);
            if (session.getTransacted()) {
                if (this.isSessionLocallyTransacted(session)) {
                    JmsUtils.commitIfNecessary(session);
                }
            } else if (this.isClientAcknowledge(session) && message != null) {
                message.acknowledge();
            }
            Message message2 = message;
            return message2;
        }
        finally {
            JmsUtils.closeMessageConsumer(consumer);
        }
    }

    private Message doReceive(MessageConsumer consumer, long timeout) throws JMSException {
        if (timeout == -1L) {
            return consumer.receiveNoWait();
        }
        if (timeout > 0L) {
            return consumer.receive(timeout);
        }
        return consumer.receive();
    }

    @Override
    public Object receiveAndConvert() throws JmsException {
        return this.doConvertFromMessage(this.receive());
    }

    @Override
    public Object receiveAndConvert(Destination destination) throws JmsException {
        return this.doConvertFromMessage(this.receive(destination));
    }

    @Override
    public Object receiveAndConvert(String destinationName) throws JmsException {
        return this.doConvertFromMessage(this.receive(destinationName));
    }

    @Override
    public Object receiveSelectedAndConvert(String messageSelector) throws JmsException {
        return this.doConvertFromMessage(this.receiveSelected(messageSelector));
    }

    @Override
    public Object receiveSelectedAndConvert(Destination destination, String messageSelector) throws JmsException {
        return this.doConvertFromMessage(this.receiveSelected(destination, messageSelector));
    }

    @Override
    public Object receiveSelectedAndConvert(String destinationName, String messageSelector) throws JmsException {
        return this.doConvertFromMessage(this.receiveSelected(destinationName, messageSelector));
    }

    protected Object doConvertFromMessage(Message message) {
        if (message != null) {
            try {
                return this.getRequiredMessageConverter().fromMessage(message);
            }
            catch (JMSException ex) {
                throw this.convertJmsAccessException(ex);
            }
        }
        return null;
    }

    @Override
    public <T> T browse(BrowserCallback<T> action) throws JmsException {
        Queue defaultQueue = this.getDefaultQueue();
        if (defaultQueue != null) {
            return this.browse(defaultQueue, action);
        }
        return this.browse(this.getRequiredDefaultDestinationName(), action);
    }

    @Override
    public <T> T browse(Queue queue, BrowserCallback<T> action) throws JmsException {
        return this.browseSelected(queue, null, action);
    }

    @Override
    public <T> T browse(String queueName, BrowserCallback<T> action) throws JmsException {
        return this.browseSelected(queueName, null, action);
    }

    @Override
    public <T> T browseSelected(String messageSelector, BrowserCallback<T> action) throws JmsException {
        Queue defaultQueue = this.getDefaultQueue();
        if (defaultQueue != null) {
            return this.browseSelected(defaultQueue, messageSelector, action);
        }
        return this.browseSelected(this.getRequiredDefaultDestinationName(), messageSelector, action);
    }

    @Override
    public <T> T browseSelected(final Queue queue, final String messageSelector, final BrowserCallback<T> action) throws JmsException {
        Assert.notNull(action, (String)"Callback object must not be null");
        return this.execute(new SessionCallback<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T doInJms(Session session) throws JMSException {
                QueueBrowser browser = JmsTemplate.this.createBrowser(session, queue, messageSelector);
                try {
                    Object t = action.doInJms(session, browser);
                    return t;
                }
                finally {
                    JmsUtils.closeQueueBrowser(browser);
                }
            }
        }, true);
    }

    @Override
    public <T> T browseSelected(final String queueName, final String messageSelector, final BrowserCallback<T> action) throws JmsException {
        Assert.notNull(action, (String)"Callback object must not be null");
        return this.execute(new SessionCallback<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T doInJms(Session session) throws JMSException {
                Queue queue = (Queue)JmsTemplate.this.getDestinationResolver().resolveDestinationName(session, queueName, false);
                QueueBrowser browser = JmsTemplate.this.createBrowser(session, queue, messageSelector);
                try {
                    Object t = action.doInJms(session, browser);
                    return t;
                }
                finally {
                    JmsUtils.closeQueueBrowser(browser);
                }
            }
        }, true);
    }

    protected Connection getConnection(JmsResourceHolder holder) {
        return holder.getConnection();
    }

    protected Session getSession(JmsResourceHolder holder) {
        return holder.getSession();
    }

    protected boolean isSessionLocallyTransacted(Session session) {
        return this.isSessionTransacted() && !ConnectionFactoryUtils.isSessionTransactional(session, this.getConnectionFactory());
    }

    protected MessageProducer createProducer(Session session, Destination destination) throws JMSException {
        MessageProducer producer = this.doCreateProducer(session, destination);
        if (!this.isMessageIdEnabled()) {
            producer.setDisableMessageID(true);
        }
        if (!this.isMessageTimestampEnabled()) {
            producer.setDisableMessageTimestamp(true);
        }
        return producer;
    }

    protected MessageProducer doCreateProducer(Session session, Destination destination) throws JMSException {
        return session.createProducer(destination);
    }

    protected MessageConsumer createConsumer(Session session, Destination destination, String messageSelector) throws JMSException {
        if (this.isPubSubDomain()) {
            return session.createConsumer(destination, messageSelector, this.isPubSubNoLocal());
        }
        return session.createConsumer(destination, messageSelector);
    }

    protected QueueBrowser createBrowser(Session session, Queue queue, String messageSelector) throws JMSException {
        return session.createBrowser(queue, messageSelector);
    }

    private class JmsTemplateResourceFactory
    implements ConnectionFactoryUtils.ResourceFactory {
        private JmsTemplateResourceFactory() {
        }

        @Override
        public Connection getConnection(JmsResourceHolder holder) {
            return JmsTemplate.this.getConnection(holder);
        }

        @Override
        public Session getSession(JmsResourceHolder holder) {
            return JmsTemplate.this.getSession(holder);
        }

        @Override
        public Connection createConnection() throws JMSException {
            return JmsTemplate.this.createConnection();
        }

        @Override
        public Session createSession(Connection con) throws JMSException {
            return JmsTemplate.this.createSession(con);
        }

        @Override
        public boolean isSynchedLocalTransactionAllowed() {
            return JmsTemplate.this.isSessionTransacted();
        }
    }
}

