/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.deploy;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.modules.tomcat5.AuthorizationException;
import org.netbeans.modules.tomcat5.Base64;
import org.netbeans.modules.tomcat5.config.gen.Context;
import org.netbeans.modules.tomcat5.config.gen.Engine;
import org.netbeans.modules.tomcat5.config.gen.Host;
import org.netbeans.modules.tomcat5.config.gen.SContext;
import org.netbeans.modules.tomcat5.config.gen.Server;
import org.netbeans.modules.tomcat5.config.gen.Service;
import org.netbeans.modules.tomcat5.deploy.TomcatManager;
import org.netbeans.modules.tomcat5.deploy.TomcatModule;
import org.netbeans.modules.tomcat5.progress.ProgressEventSupport;
import org.netbeans.modules.tomcat5.progress.Status;
import org.netbeans.modules.tomcat5.util.TomcatProperties;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class TomcatManagerImpl
implements ProgressObject,
Runnable {
    private static RequestProcessor rp;
    private ProgressEventSupport pes;
    private String command;
    private String output;
    private CommandType cmdType;
    private InputStream istream;
    private TomcatManager tm;
    private boolean authorized;
    private TomcatModule tmId;
    private static final Logger LOGGER;

    private static synchronized RequestProcessor rp() {
        if (rp == null) {
            rp = new RequestProcessor("Tomcat management", 1);
        }
        return rp;
    }

    public TomcatManagerImpl(TomcatManager tm) {
        this.tm = tm;
        this.pes = new ProgressEventSupport(this);
    }

    public void deploy(Target t, InputStream is, InputStream deplPlan) {
        Context ctx;
        try {
            ctx = Context.createGraph(deplPlan);
        }
        catch (RuntimeException e) {
            String msg = NbBundle.getMessage(TomcatManagerImpl.class, (String)"MSG_DeployBrokenContextXml");
            this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, this.cmdType, msg, StateType.FAILED));
            return;
        }
        String ctxPath = ctx.getAttributeValue("path");
        this.tmId = new TomcatModule(t, ctxPath);
        this.command = "deploy?path=" + TomcatManagerImpl.encodePath(this.tmId.getPath());
        this.cmdType = CommandType.DISTRIBUTE;
        String msg = NbBundle.getMessage(TomcatManagerImpl.class, (String)"MSG_DeploymentInProgress");
        this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, this.cmdType, msg, StateType.RUNNING));
        this.istream = is;
        TomcatManagerImpl.rp().post((Runnable)this, 0, 5);
    }

    public void install(Target t, File wmfile, File deplPlan) {
        String docBase = wmfile.toURI().toASCIIString();
        if (docBase.endsWith("/")) {
            docBase = docBase.substring(0, docBase.length() - 1);
        }
        if (wmfile.isFile()) {
            docBase = "jar:" + docBase + "!/";
        }
        String ctxPath = null;
        try {
            if (!deplPlan.exists()) {
                ctxPath = wmfile.isDirectory() ? "/" + wmfile.getName() : "/" + wmfile.getName().substring(0, wmfile.getName().lastIndexOf(46));
                this.tmId = new TomcatModule(t, ctxPath);
                this.command = "deploy?update=true&path=" + TomcatManagerImpl.encodePath(ctxPath) + "&war=" + docBase;
            } else {
                Context ctx;
                FileInputStream in = new FileInputStream(deplPlan);
                try {
                    ctx = Context.createGraph(in);
                }
                catch (RuntimeException e) {
                    String msg = NbBundle.getMessage(TomcatManagerImpl.class, (String)"MSG_DeployBrokenContextXml");
                    this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, this.cmdType, msg, StateType.FAILED));
                    return;
                }
                ctxPath = wmfile.isDirectory() ? "/" + wmfile.getName() : "/" + wmfile.getName().substring(0, wmfile.getName().lastIndexOf(46));
                ctxPath = ctx.getAttributeValue("path");
                this.tmId = new TomcatModule(t, ctxPath);
                this.command = "deploy?update=true&path=" + TomcatManagerImpl.encodePath(this.tmId.getPath()) + "&war=" + docBase;
            }
            this.cmdType = CommandType.DISTRIBUTE;
            String msg = NbBundle.getMessage(TomcatManagerImpl.class, (String)"MSG_DeploymentInProgress");
            this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, this.cmdType, msg, StateType.RUNNING));
            TomcatManagerImpl.rp().post((Runnable)this, 0, 5);
        }
        catch (FileNotFoundException fnfe) {
            this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, this.cmdType, fnfe.getLocalizedMessage(), StateType.FAILED));
        }
    }

    public void initialDeploy(Target t, File contextXml, File dir) {
        try {
            FileInputStream in = new FileInputStream(contextXml);
            Context ctx = Context.createGraph(in);
            String docBaseURI = dir.getAbsoluteFile().toURI().toASCIIString();
            String docBase = dir.getAbsolutePath();
            String ctxPath = ctx.getAttributeValue("path");
            this.tmId = new TomcatModule(t, ctxPath, docBase);
            String tmpContextXml = this.createTempContextXml(docBase, ctx);
            this.command = this.tm.isTomcat50() ? "deploy?config=" + tmpContextXml + "&war=" + docBaseURI : "deploy?config=" + tmpContextXml + "&path=" + TomcatManagerImpl.encodePath(this.tmId.getPath());
            this.cmdType = CommandType.DISTRIBUTE;
            String msg = NbBundle.getMessage(TomcatManagerImpl.class, (String)"MSG_DeploymentInProgress");
            this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, this.cmdType, msg, StateType.RUNNING));
            TomcatManagerImpl.rp().post((Runnable)this, 0, 5);
        }
        catch (IOException ioex) {
            this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, this.cmdType, ioex.getLocalizedMessage(), StateType.FAILED));
        }
        catch (RuntimeException e) {
            String msg = NbBundle.getMessage(TomcatManagerImpl.class, (String)"MSG_DeployBrokenContextXml");
            this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, this.cmdType, msg, StateType.FAILED));
        }
    }

    public void remove(TomcatModule tmId) {
        Server server = this.tm.getRoot();
        if (server != null && this.removeContextFromServer(server, tmId.getPath())) {
            File f = null;
            try {
                f = this.tm.getTomcatProperties().getServerXml();
                server.write(f);
            }
            catch (Exception e) {
                this.pes.fireHandleProgressEvent(tmId, new Status(ActionType.EXECUTE, CommandType.UNDEPLOY, NbBundle.getMessage(TomcatManagerImpl.class, (String)"MSG_ServerXml_RO", (Object)f.getAbsolutePath()), StateType.FAILED));
                return;
            }
        }
        this.tmId = tmId;
        this.command = "undeploy?path=" + TomcatManagerImpl.encodePath(tmId.getPath());
        this.cmdType = CommandType.UNDEPLOY;
        String msg = NbBundle.getMessage(TomcatManagerImpl.class, (String)"MSG_UndeploymentInProgress");
        this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, this.cmdType, msg, StateType.RUNNING));
        TomcatManagerImpl.rp().post((Runnable)this, 0, 5);
    }

    private boolean removeContextFromServer(Server server, String path) {
        Host[] host;
        Engine engine;
        Service[] service;
        if (path.equals("/")) {
            path = "";
        }
        if ((service = server.getService()).length > 0 && (engine = service[0].getEngine()) != null && (host = engine.getHost()).length > 0) {
            SContext[] sContext = host[0].getSContext();
            for (int i = 0; i < sContext.length; ++i) {
                if (!sContext[i].getAttributeValue("path").equals(path)) continue;
                host[0].removeSContext(sContext[i]);
                return true;
            }
        }
        return false;
    }

    public void start(TomcatModule tmId) {
        this.tmId = tmId;
        this.command = "start?path=" + TomcatManagerImpl.encodePath(tmId.getPath());
        this.cmdType = CommandType.START;
        String msg = NbBundle.getMessage(TomcatManagerImpl.class, (String)"MSG_StartInProgress");
        this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, this.cmdType, msg, StateType.RUNNING));
        TomcatManagerImpl.rp().post((Runnable)this, 0, 5);
    }

    public void stop(TomcatModule tmId) {
        this.tmId = tmId;
        this.command = "stop?path=" + TomcatManagerImpl.encodePath(tmId.getPath());
        this.cmdType = CommandType.STOP;
        String msg = NbBundle.getMessage(TomcatManagerImpl.class, (String)"MSG_StopInProgress");
        this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, this.cmdType, msg, StateType.RUNNING));
        TomcatManagerImpl.rp().post((Runnable)this, 0, 5);
    }

    public void reload(TomcatModule tmId) {
        this.tmId = tmId;
        this.command = "reload?path=" + TomcatManagerImpl.encodePath(tmId.getPath());
        this.cmdType = CommandType.REDEPLOY;
        String msg = NbBundle.getMessage(TomcatManagerImpl.class, (String)"MSG_ReloadInProgress");
        this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, this.cmdType, msg, StateType.RUNNING));
        TomcatManagerImpl.rp().post((Runnable)this, 0, 5);
    }

    public void incrementalRedeploy(TomcatModule tmId) {
        try {
            this.tmId = tmId;
            String docBase = tmId.getDocRoot();
            assert (docBase != null);
            String docBaseURI = new File(docBase).toURI().toASCIIString();
            File contextXml = new File(docBase + "/META-INF/context.xml");
            FileInputStream in = new FileInputStream(contextXml);
            Context ctx = Context.createGraph(in);
            String tmpContextXml = this.createTempContextXml(docBase, ctx);
            this.command = this.tm.isTomcat50() ? "deploy?config=" + tmpContextXml + "&war=" + docBaseURI : "deploy?config=" + tmpContextXml + "&path=" + TomcatManagerImpl.encodePath(tmId.getPath());
            this.cmdType = CommandType.DISTRIBUTE;
            String msg = NbBundle.getMessage(TomcatManagerImpl.class, (String)"MSG_DeployInProgress");
            this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, this.cmdType, msg, StateType.RUNNING));
            TomcatManagerImpl.rp().post((Runnable)this, 0, 5);
        }
        catch (IOException ioex) {
            this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, this.cmdType, ioex.getLocalizedMessage(), StateType.FAILED));
        }
        catch (RuntimeException e) {
            String msg = NbBundle.getMessage(TomcatManagerImpl.class, (String)"MSG_DeployBrokenContextXml");
            this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, this.cmdType, msg, StateType.FAILED));
            return;
        }
    }

    private static String encodePath(String str) {
        try {
            StringTokenizer st = new StringTokenizer(str, "/");
            if (!st.hasMoreTokens()) {
                return str;
            }
            StringBuilder result = new StringBuilder();
            while (st.hasMoreTokens()) {
                result.append("/").append(URLEncoder.encode(st.nextToken(), "UTF-8"));
            }
            return result.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private String createTempContextXml(String docBase, Context ctx) throws IOException {
        File tmpContextXml = File.createTempFile("context", ".xml");
        tmpContextXml.deleteOnExit();
        if (!docBase.equals(ctx.getAttributeValue("docBase"))) {
            ctx.setAttributeValue("docBase", docBase);
            FileOutputStream fos = new FileOutputStream(tmpContextXml);
            ctx.write(fos);
            fos.close();
        }
        URL url = tmpContextXml.toURI().toURL();
        String ret = URLEncoder.encode(url.toString(), "UTF-8");
        return ret;
    }

    TargetModuleID[] list(Target t, int state) throws IllegalStateException {
        this.command = "list";
        this.run();
        if (!this.authorized) {
            String errMsg = NbBundle.getMessage(TomcatManagerImpl.class, (String)"MSG_AuthorizationFailed", (Object)(this.tm.isAboveTomcat70() ? "manager-script" : "manager"));
            IllegalStateException ise = new IllegalStateException(errMsg);
            throw (IllegalStateException)ise.initCause(new AuthorizationException());
        }
        ArrayList<TomcatModule> modules = new ArrayList<TomcatModule>();
        boolean first = true;
        StringTokenizer stok = new StringTokenizer(this.output, "\r\n");
        while (stok.hasMoreTokens()) {
            String line = stok.nextToken();
            if (first) {
                first = false;
                continue;
            }
            StringTokenizer ltok = new StringTokenizer(line, ":");
            try {
                String ctx = ltok.nextToken();
                String s = ltok.nextToken();
                String tag = ltok.nextToken();
                String path = null;
                if (ltok.hasMoreTokens()) {
                    path = line.substring(ctx.length() + s.length() + tag.length() + 3);
                }
                if ("running".equals(s) && (state == 0 || state == 1)) {
                    modules.add(new TomcatModule(t, ctx, path));
                }
                if (!"stopped".equals(s) || state != 0 && state != 2) continue;
                modules.add(new TomcatModule(t, ctx, path));
            }
            catch (NoSuchElementException e) {
                LOGGER.log(Level.FINE, line, e);
                System.err.println(line);
                e.printStackTrace();
            }
        }
        return modules.toArray(new TargetModuleID[modules.size()]);
    }

    public String jmxProxy(String query) {
        this.command = "jmxproxy/" + query;
        this.run();
        return this.output;
    }

    public ClientConfiguration getClientConfiguration(TargetModuleID targetModuleID) {
        return null;
    }

    public DeploymentStatus getDeploymentStatus() {
        return this.pes.getDeploymentStatus();
    }

    public TargetModuleID[] getResultTargetModuleIDs() {
        return new TargetModuleID[]{this.tmId};
    }

    public boolean isCancelSupported() {
        return false;
    }

    public void cancel() throws OperationUnsupportedException {
        throw new OperationUnsupportedException("cancel not supported in Tomcat deployment");
    }

    public boolean isStopSupported() {
        return false;
    }

    public void stop() throws OperationUnsupportedException {
        throw new OperationUnsupportedException("stop not supported in Tomcat deployment");
    }

    public void addProgressListener(ProgressListener l) {
        this.pes.addProgressListener(l);
    }

    public void removeProgressListener(ProgressListener l) {
        this.pes.removeProgressListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        LOGGER.log(Level.FINE, this.command);
        this.pes.fireHandleProgressEvent(this.tmId, new Status(ActionType.EXECUTE, this.cmdType, this.command, StateType.RUNNING));
        this.output = "";
        this.authorized = true;
        int retries = 4;
        URLConnection conn = null;
        InputStreamReader reader = null;
        URL urlToConnectTo = null;
        boolean failed = false;
        String msg = null;
        while (retries >= 0) {
            --retries;
            try {
                boolean first;
                String uri = this.tm.getPlainUri();
                String withoutSpaces = (uri + this.command).replaceAll(" ", "%20");
                urlToConnectTo = new URL(withoutSpaces);
                if (Boolean.getBoolean("org.netbeans.modules.tomcat5.LogManagerCommands")) {
                    String message = "Tomcat 5 sending manager command: " + urlToConnectTo;
                    Logger.getLogger(TomcatManagerImpl.class.getName()).log(Level.FINE, null, new Exception(message));
                }
                conn = this.tm.isMisconfiguredProxy() ? urlToConnectTo.openConnection(Proxy.NO_PROXY) : urlToConnectTo.openConnection();
                HttpURLConnection hconn = (HttpURLConnection)conn;
                hconn.setAllowUserInteraction(false);
                hconn.setDoInput(true);
                hconn.setUseCaches(false);
                if (this.istream != null) {
                    hconn.setDoOutput(true);
                    hconn.setRequestMethod("PUT");
                    hconn.setRequestProperty("Content-Type", "application/octet-stream");
                } else {
                    hconn.setDoOutput(false);
                    hconn.setRequestMethod("GET");
                }
                hconn.setRequestProperty("User-Agent", "NetBeansIDE-Tomcat-Manager/1.0");
                TomcatProperties tp = this.tm.getTomcatProperties();
                String input = tp.getUsername() + ":" + tp.getPassword();
                String auth = new String(Base64.encode(input.getBytes()));
                hconn.setRequestProperty("Authorization", "Basic " + auth);
                hconn.connect();
                int respCode = hconn.getResponseCode();
                if (respCode == 401 || respCode == 403) {
                    this.authorized = false;
                    String errMsg = NbBundle.getMessage(TomcatManagerImpl.class, (String)"MSG_AuthorizationFailed");
                    this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, this.cmdType, errMsg, StateType.FAILED));
                    return;
                }
                if (respCode == 502) {
                    throw new IOException(Integer.toString(respCode));
                }
                if (Boolean.getBoolean("org.netbeans.modules.tomcat5.LogManagerCommands")) {
                    int code = hconn.getResponseCode();
                    String message = "Tomcat 5 receiving response, code: " + code;
                    System.out.println(message);
                    Logger.getLogger(TomcatManagerImpl.class.getName()).log(Level.INFO, null, new Exception(message));
                }
                if (this.istream != null) {
                    int n;
                    BufferedOutputStream ostream = new BufferedOutputStream(hconn.getOutputStream(), 1024);
                    byte[] buffer = new byte[1024];
                    while ((n = this.istream.read(buffer)) >= 0) {
                        ostream.write(buffer, 0, n);
                    }
                    ostream.flush();
                    ostream.close();
                    this.istream.close();
                }
                reader = new InputStreamReader(hconn.getInputStream(), "UTF-8");
                retries = -1;
                StringBuffer buff = new StringBuffer();
                String error = null;
                msg = null;
                boolean bl = first = !this.command.startsWith("jmxproxy");
                while (true) {
                    int ch;
                    if ((ch = reader.read()) < 0) break;
                    if (ch == 13 || ch == 10) {
                        String line = buff.toString();
                        buff.setLength(0);
                        LOGGER.log(Level.FINE, line);
                        if (first) {
                            String japaneseOK = "\u6210\u529f";
                            msg = line;
                            if (line.indexOf("java.lang.ThreadDeath") != -1) {
                                String warning = NbBundle.getMessage(TomcatManagerImpl.class, (String)"MSG_ThreadDeathWarning");
                                this.pes.fireHandleProgressEvent(this.tmId, new Status(ActionType.EXECUTE, this.cmdType, warning, StateType.RUNNING));
                            } else if (!line.startsWith("OK -") && !line.startsWith(japaneseOK)) {
                                error = line;
                            }
                            first = false;
                        }
                        this.output = this.output + line + "\n";
                        continue;
                    }
                    buff.append((char)ch);
                }
                this.output = this.output + buff.toString() + "\n";
                if (buff.length() > 0) {
                    LOGGER.log(Level.FINE, buff.toString());
                }
                if (error != null) {
                    LOGGER.log(Level.INFO, "TomcatManagerImpl connecting to: " + urlToConnectTo, error);
                    this.pes.fireHandleProgressEvent(this.tmId, new Status(ActionType.EXECUTE, this.cmdType, error, StateType.FAILED));
                    failed = true;
                }
                if (msg == null) {
                    msg = buff.toString();
                }
            }
            catch (Exception e) {
                if (e instanceof IOException && e.getMessage() != null && e.getMessage().contains(Integer.toString(502))) {
                    this.tm.setMisconfiguredProxy(true);
                    LOGGER.log(Level.INFO, "Proxy is misconfigured for localhost");
                } else if (this.tm.isMisconfiguredProxy()) {
                    this.tm.setMisconfiguredProxy(false);
                }
                if (retries < 0) {
                    LOGGER.log(Level.INFO, "TomcatManagerImpl connecting to: " + urlToConnectTo, e);
                    this.pes.fireHandleProgressEvent(this.tmId, new Status(ActionType.EXECUTE, this.cmdType, e.getLocalizedMessage(), StateType.FAILED));
                    failed = true;
                }
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                    reader = null;
                }
                if (this.istream != null) {
                    try {
                        this.istream.close();
                    }
                    catch (IOException iOException) {}
                    this.istream = null;
                }
            }
            if (retries < 0) continue;
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!failed) {
            this.pes.fireHandleProgressEvent(this.tmId, new Status(ActionType.EXECUTE, this.cmdType, msg, StateType.COMPLETED));
        }
    }

    static {
        LOGGER = Logger.getLogger(TomcatManagerImpl.class.getName());
    }
}

