/*
 * Decompiled with CFR 0.152.
 */
package org.openide.modules;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Lookup;

public abstract class Places {
    private static final Logger LOG = Logger.getLogger(Places.class.getName());

    public static synchronized File getUserDirectory() {
        Places places = (Places)Lookup.getDefault().lookup(Places.class);
        if (places != null) {
            return places.findUserDirectory();
        }
        String p = System.getProperty("netbeans.user");
        return p != null ? new File(p) : null;
    }

    public static synchronized File getCacheDirectory() {
        File cache;
        Places places = (Places)Lookup.getDefault().lookup(Places.class);
        if (places != null && (cache = places.findCacheDirectory()) != null) {
            return cache;
        }
        File userdir = Places.getUserDirectory();
        if (userdir != null) {
            return new File(new File(userdir, "var"), "cache");
        }
        return new File(System.getProperty("java.io.tmpdir"), "nbcache");
    }

    public static File getCacheSubdirectory(String path) {
        File d = new File(Places.getCacheDirectory(), path);
        if (!d.isDirectory() && !d.mkdirs()) {
            LOG.log(Level.WARNING, "could not create {0}", d);
        }
        return d;
    }

    public static File getCacheSubfile(String path) {
        File f = new File(Places.getCacheDirectory(), path);
        File d = f.getParentFile();
        if (!d.isDirectory() && !d.mkdirs()) {
            LOG.log(Level.WARNING, "could not create {0}", d);
        }
        return f;
    }

    protected Places() {
    }

    protected abstract File findCacheDirectory();

    protected abstract File findUserDirectory();
}

