/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support.impl;

import org.clank.java.std;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.llvm.adt.StringRef;
import org.llvm.support.llvm;
import org.llvm.support.spi.ExecuteProgramProvider;
import org.llvm.support.sys.ProcessInfo;
import org.openide.util.Lookup;

public final class ProgramStatics {
    public static boolean Execute(ProcessInfo PI, StringRef Program, type.ptr<char.ptr> args, type.ptr<char.ptr> envp, type.ptr<StringRef> redirects, int memoryLimit, std.string ErrMsg) throws Throwable {
        ExecuteProgramProvider provider = ProgramStatics.findExecuteProvider(Program);
        if (provider == null) {
            llvm.errs().$out("Execute is not yet implemented for ").$out(Program).$out(NativePointer.$LF);
            llvm.errs().$out("Implement ExecuteProgramProvider in corresponding module as @ServiceProvider\n");
            throw new UnsupportedOperationException("trying to invoke " + Program + args + " natively");
        }
        return provider.Execute(PI, Program, args, envp, redirects, memoryLimit, ErrMsg);
    }

    private static ExecuteProgramProvider findExecuteProvider(StringRef Program) {
        ExecuteProgramProvider out = null;
        for (ExecuteProgramProvider p : Lookup.getDefault().lookupAll(ExecuteProgramProvider.class)) {
            if (!p.canExecute(Program)) continue;
            if (out == null) {
                out = p;
                continue;
            }
            llvm.errs().$out("Providers collision for ").$out(Program).$out(NativePointer.$LF);
            llvm.errs().$out("Found ").$out(out.getClass().getName());
            llvm.errs().$out(" and ").$out(out.getClass().getName()).$out(NativePointer.$LF);
        }
        return out;
    }
}

