/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.palette.items;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.web.core.palette.JspPaletteUtilities;
import org.netbeans.modules.web.core.palette.items.GetPropertyCustomizer;
import org.netbeans.modules.web.jsps.parserapi.PageInfo;
import org.openide.text.ActiveEditorDrop;

public class GetProperty
implements ActiveEditorDrop {
    public static final String[] implicitBeans = new String[]{"request", "response", "pageContext", "session", "application", "out", "config", "page", "exception"};
    public static final int BEAN_DEFAULT = 0;
    public static final String[] implicitTypes = new String[]{"javax.servlet.http.HttpServletRequest", "javax.servlet.http.HttpServletResponse", "javax.servlet.jsp.PageContext", "javax.servlet.http.HttpSession", "javax.servlet.ServletContext", "javax.servlet.jsp.JspWriter", "javax.servlet.ServletConfig", "java.lang.Object", "java.lang.Throwable"};
    protected List<BeanDescr> allBeans = new ArrayList<BeanDescr>();
    private int beanIndex = 0;
    private String bean = "";
    private String property = "";

    public boolean handleTransfer(JTextComponent targetComponent) {
        this.allBeans = this.initAllBeans(targetComponent);
        GetPropertyCustomizer c = new GetPropertyCustomizer(this, targetComponent);
        boolean accept = c.showDialog();
        if (accept) {
            String body = this.createBody();
            try {
                JspPaletteUtilities.insert(body, targetComponent);
            }
            catch (BadLocationException ble) {
                accept = false;
            }
        }
        return accept;
    }

    private String createBody() {
        String strBean = " name=\"\"";
        strBean = this.beanIndex == -1 ? " name=\"" + this.bean + "\"" : " name=\"" + this.allBeans.get(this.beanIndex).getId() + "\"";
        String strProperty = " property=\"" + this.property + "\"";
        String gp = "<jsp:getProperty" + strBean + strProperty + " />";
        return gp;
    }

    public int getBeanIndex() {
        return this.beanIndex;
    }

    public void setBeanIndex(int beanIndex) {
        this.beanIndex = beanIndex;
    }

    public String getBean() {
        return this.bean;
    }

    public void setBean(String bean) {
        this.bean = bean;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    protected List<BeanDescr> initAllBeans(JTextComponent targetComponent) {
        ArrayList<BeanDescr> res = new ArrayList<BeanDescr>();
        for (int i = 0; i < implicitBeans.length; ++i) {
            String id = implicitBeans[i];
            String fqcn = implicitTypes[i];
            res.add(new BeanDescr(id, fqcn));
        }
        PageInfo.BeanData[] bd = JspPaletteUtilities.getAllBeans(targetComponent);
        if (bd != null) {
            for (PageInfo.BeanData beanData : bd) {
                res.add(new BeanDescr(beanData.getId(), beanData.getClassName()));
            }
        }
        return res;
    }

    public List<BeanDescr> getAllBeans() {
        return this.allBeans;
    }

    class BeanDescr {
        private String id;
        private String fqcn;

        public void setFqcn(String fqcn) {
            this.fqcn = fqcn;
        }

        public String getFqcn() {
            return this.fqcn;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public BeanDescr(String id, String fqcn) {
            this.id = id;
            this.fqcn = fqcn;
        }

        public String toString() {
            return this.id;
        }
    }
}

