/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grails.api;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import org.netbeans.modules.groovy.grails.api.GrailsPlatform;
import org.netbeans.modules.groovy.grails.api.GrailsProjectConfig;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class ExecutionSupport {
    private static ExecutionSupport instance;
    private final GrailsPlatform platform;

    private ExecutionSupport(GrailsPlatform platform) {
        this.platform = platform;
    }

    public static synchronized ExecutionSupport getInstance() {
        if (instance == null) {
            instance = new ExecutionSupport(GrailsPlatform.getDefault());
        }
        return instance;
    }

    private static ExecutionSupport forRuntime(GrailsPlatform runtime) {
        if (runtime == null) {
            throw new NullPointerException("Runtime is null");
        }
        if (!runtime.isConfigured()) {
            return null;
        }
        return new ExecutionSupport(runtime);
    }

    public Callable<Process> createCreateApp(final File directory) {
        return new Callable<Process>(){

            @Override
            public Process call() throws Exception {
                if (directory.exists()) {
                    throw new IOException("Project directory already exists");
                }
                File work = directory.getAbsoluteFile().getParentFile();
                FileUtil.createFolder((File)work);
                String name = directory.getName();
                String[] args = GrailsPlatform.Version.VERSION_1_1.compareTo(ExecutionSupport.this.platform.getVersion()) <= 0 ? new String[]{"--non-interactive", name} : new String[]{name};
                GrailsPlatform.CommandDescriptor descriptor = GrailsPlatform.CommandDescriptor.forProject("create-app", work, null, args, null);
                return ExecutionSupport.this.platform.createCommand(descriptor).call();
            }
        };
    }

    public Callable<Process> createRunApp(final GrailsProjectConfig config, final boolean debug, final String ... arguments) {
        return new Callable<Process>(){

            @Override
            public Process call() throws Exception {
                File directory = FileUtil.toFile((FileObject)config.getProject().getProjectDirectory());
                GrailsPlatform.CommandDescriptor descriptor = GrailsPlatform.CommandDescriptor.forProject("run-app", directory, config, arguments, null, debug);
                return ExecutionSupport.this.platform.createCommand(descriptor).call();
            }
        };
    }

    public Callable<Process> createSimpleCommand(String command, GrailsProjectConfig config, String ... arguments) {
        return this.createSimpleCommand(command, false, config, arguments);
    }

    public Callable<Process> createSimpleCommand(final String command, final boolean debug, final GrailsProjectConfig config, final String ... arguments) {
        return new Callable<Process>(){

            @Override
            public Process call() throws Exception {
                File directory = FileUtil.toFile((FileObject)config.getProject().getProjectDirectory());
                GrailsPlatform.CommandDescriptor descriptor = GrailsPlatform.CommandDescriptor.forProject(command, directory, config, arguments, null, debug);
                return ExecutionSupport.this.platform.createCommand(descriptor).call();
            }
        };
    }
}

