/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.project.deps;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.javacard.project.deps.ArtifactKind;
import org.netbeans.modules.javacard.project.deps.DependenciesResolver;
import org.netbeans.modules.javacard.project.deps.Dependency;
import org.netbeans.modules.javacard.project.deps.DependencyKind;
import org.netbeans.modules.javacard.project.deps.DeploymentStrategy;
import org.netbeans.modules.javacard.project.deps.Path;
import org.openide.filesystems.FileObject;

public class ResolvedDependency {
    private Dependency dep;
    protected final DependenciesResolver resolver;
    private Map<ArtifactKind, String> initialPaths = new HashMap<ArtifactKind, String>();
    private Map<ArtifactKind, String> paths = new HashMap<ArtifactKind, String>();
    private final boolean initialized;
    private DeploymentStrategy depStrategy;

    public ResolvedDependency(Dependency dep, DependenciesResolver resolver) {
        this(dep, resolver, null);
    }

    public ResolvedDependency(Dependency dep, DependenciesResolver resolver, Map<ArtifactKind, String> m) {
        this.dep = dep;
        this.resolver = resolver;
        if (m == null) {
            for (ArtifactKind kind : dep.getKind().supportedArtifacts()) {
                String path = this.getOriginalPath(kind);
                if (path == null) continue;
                this.initialPaths.put(kind, path);
                this.paths.put(kind, path);
            }
        } else {
            this.initialPaths.putAll(m);
            this.paths.putAll(m);
        }
        this.initialized = true;
    }

    public boolean isValid() {
        return this.resolver.isValid(this.getDependency());
    }

    Dependency dep() {
        return this.dep;
    }

    public boolean isProject() {
        return this.dep.getKind().isProjectDependency();
    }

    public FileObject resolve(ArtifactKind kind) {
        String path = this.getPath(kind);
        if (path == null) {
            return null;
        }
        return this.resolver.resolveArtifact(this.getDependency(), kind);
    }

    public String getPath(ArtifactKind kind) {
        String path = this.paths.get((Object)kind);
        if (path == null) {
            return this.getOriginalPath(kind);
        }
        return path;
    }

    public Path getAntPath(ArtifactKind kind) {
        return this.resolver.resolveAntPath(this.getPath(kind));
    }

    private String getOriginalPath(ArtifactKind kind) {
        if (!this.initialized) {
            File f = this.resolver.resolveFile(this.getDependency(), kind);
            return f == null ? this.initialPaths.get((Object)kind) : f.getAbsolutePath();
        }
        return this.initialPaths.get((Object)kind);
    }

    public void setPath(ArtifactKind kind, String path) {
        this.paths.put(kind, path);
    }

    public void reset(ArtifactKind kind) {
        this.paths.remove((Object)kind);
    }

    public DependencyKind getKind() {
        return this.dep.getKind();
    }

    public DeploymentStrategy getDeploymentStrategy() {
        return this.depStrategy == null ? this.dep.getDeploymentStrategy() : this.depStrategy;
    }

    public void setDeploymentStrategy(DeploymentStrategy depStrategy) {
        this.depStrategy = depStrategy;
    }

    public boolean isModified() {
        boolean result = this.isPathsModified() || this.isDependencyModified();
        return result;
    }

    public boolean isPathsModified() {
        boolean result = !this.initialPaths.equals(this.paths);
        return result;
    }

    public boolean isDependencyModified() {
        return this.depStrategy != null && !this.depStrategy.equals((Object)this.dep.getDeploymentStrategy());
    }

    public File resolveFile(ArtifactKind kind) {
        String initialPath;
        File f = this.resolver.resolveFile(this.getDependency(), kind);
        if (f == null && (initialPath = this.initialPaths.get((Object)kind)) != null && new File(initialPath).exists()) {
            f = new File(initialPath);
        }
        return f;
    }

    public Set<ArtifactKind> getModifiedArtifactKinds() {
        HashSet<ArtifactKind> result = new HashSet<ArtifactKind>();
        for (Map.Entry<ArtifactKind, String> e : this.paths.entrySet()) {
            String origPath;
            ArtifactKind a = e.getKey();
            String path = e.getValue();
            boolean unequal = path == null != ((origPath = this.initialPaths.get((Object)a)) == null) || path != null && !path.equals(origPath);
            if (!unequal) continue;
            result.add(a);
        }
        return result;
    }

    public Set<DeploymentStrategy> supportedDeploymentStrategies() {
        return this.getKind().supportedDeploymentStrategies();
    }

    public Set<ArtifactKind> supportedArtifactKinds() {
        return this.getKind().supportedArtifacts();
    }

    public Dependency getDependency() {
        if (this.isModified()) {
            return new Dependency(this.dep.getID(), this.dep.getKind(), this.getDeploymentStrategy());
        }
        return this.dep;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != ResolvedDependency.class) {
            return false;
        }
        ResolvedDependency r = (ResolvedDependency)o;
        return this.getDependency().equals(r.getDependency());
    }

    public int hashCode() {
        return this.getDependency().hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("[");
        for (ArtifactKind k : ArtifactKind.values()) {
            if (!this.supportedArtifactKinds().contains((Object)k)) continue;
            File f = this.resolveFile(k);
            sb.append((Object)k);
            sb.append("=");
            sb.append(f == null ? "null" : f.getPath());
        }
        sb.append("]");
        return sb.toString();
    }
}

