/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.spi.ProjectMetadataFactory;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class StandardHeadersProjectMetadataFactory
implements ProjectMetadataFactory {
    public static final String C_STANDARD_HEADERS_INDEXER = "c_standard_headers_indexer.c";
    public static final String CPP_STANDARD_HEADERS_INDEXER = "cpp_standard_headers_indexer.cpp";

    @Override
    public void read(FileObject projectDir) {
        FileObject nbproject = projectDir.getFileObject("nbproject");
        if (nbproject != null && nbproject.isValid()) {
            this.reload(projectDir);
        }
    }

    @Override
    public void write(FileObject projectDir) {
    }

    private void reload(FileObject projectDir) {
        FileObject nbProjectFolder = projectDir.getFileObject("nbproject");
        if (nbProjectFolder == null) {
            return;
        }
        FileObject privateNbFolder = projectDir.getFileObject("nbproject/private");
        if (privateNbFolder == null) {
            FileObject projectFolder = projectDir.getFileObject("nbproject");
            if (projectFolder == null || !projectFolder.canWrite()) {
                return;
            }
            try {
                privateNbFolder = nbProjectFolder.createFolder("private");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        FileObject c_standard = null;
        FileObject cpp_standard = null;
        if (privateNbFolder == null || !privateNbFolder.isValid() || !privateNbFolder.canWrite()) {
            return;
        }
        c_standard = privateNbFolder.getFileObject(C_STANDARD_HEADERS_INDEXER);
        cpp_standard = privateNbFolder.getFileObject(CPP_STANDARD_HEADERS_INDEXER);
        try {
            if (c_standard == null || !c_standard.isValid()) {
                this.writeStandardHeaders(C_STANDARD_HEADERS_INDEXER, privateNbFolder);
            }
            if (cpp_standard == null || !cpp_standard.isValid()) {
                this.writeStandardHeaders(CPP_STANDARD_HEADERS_INDEXER, privateNbFolder);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeStandardHeaders(String headers, FileObject privateNbFolder) throws IOException {
        InputStream is;
        String resource = "/org/netbeans/modules/cnd/makeproject/resources/" + headers;
        OutputStream os = null;
        try {
            URL url = new URL("nbresloc:" + resource);
            is = url.openStream();
        }
        catch (Exception e) {
            is = MakeConfigurationDescriptor.class.getResourceAsStream(resource);
        }
        if (is == null) {
            return;
        }
        FileObject dest = null;
        try {
            dest = FileUtil.createData((FileObject)privateNbFolder, (String)headers);
            os = dest.getOutputStream();
            FileUtil.copy((InputStream)is, (OutputStream)os);
            os.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.err);
        }
        is.close();
    }
}

