/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.resolver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmNamedElement;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceAlias;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmUsingDeclaration;
import org.netbeans.modules.cnd.api.model.CsmUsingDirective;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.deep.CsmDeclarationStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmExpression;
import org.netbeans.modules.cnd.api.model.deep.CsmReturnStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.api.model.services.CsmCacheManager;
import org.netbeans.modules.cnd.api.model.services.CsmCacheMap;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.NamespaceImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.resolver.Resolver3;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.openide.util.CharSequences;

public final class FileMapsCollector {
    private final CsmFile currentFile;
    private final CsmFile startFile;
    private final int stopAtOffset;
    private CsmCacheMap filesCollectorCache;
    private boolean collectedDependencies;
    private final Map<CharSequence, CsmObject> usedNamespaces = new LinkedHashMap<CharSequence, CsmObject>();
    private final Map<CharSequence, CsmObject> namespaceAliases = new HashMap<CharSequence, CsmObject>();
    private final Map<CharSequence, ArrayList<CsmObject>> usingDeclarations = new HashMap<CharSequence, ArrayList<CsmObject>>();
    private final Set<CsmFile> visitedFiles = new HashSet<CsmFile>();
    private static final int INCLUDE_STACK_MARKER = -1;
    private static final CsmSelect.CsmFilter NO_FILTER = CsmSelect.getFilterBuilder().createOffsetFilter(0, Integer.MAX_VALUE);
    private static final CsmSelect.CsmFilter NAMESPACE_FILTER = CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.NAMESPACE_DEFINITION, CsmDeclaration.Kind.NAMESPACE_ALIAS, CsmDeclaration.Kind.USING_DECLARATION, CsmDeclaration.Kind.USING_DIRECTIVE});
    private static final CsmSelect.CsmFilter CLASS_FILTER = CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.NAMESPACE_DEFINITION, CsmDeclaration.Kind.NAMESPACE_ALIAS, CsmDeclaration.Kind.USING_DECLARATION, CsmDeclaration.Kind.USING_DIRECTIVE, CsmDeclaration.Kind.TYPEDEF, CsmDeclaration.Kind.TYPEALIAS, CsmDeclaration.Kind.CLASS, CsmDeclaration.Kind.ENUM, CsmDeclaration.Kind.STRUCT, CsmDeclaration.Kind.UNION});
    private static final Callback EMPTY_CALLBACK = new Callback(){

        @Override
        public boolean needToTraverseDeeper(CsmScope scope) {
            if (CsmKindUtilities.isNamespace((Object)scope) || CsmKindUtilities.isNamespaceDefinition((CsmObject)scope)) {
                return ((CsmNamedElement)scope).getName().length() == 0;
            }
            return false;
        }

        @Override
        public void onVisibleClassifier(CsmClassifier cls) {
        }
    };
    private static final Callable<CsmCacheMap> CACHE_INITIALIZER = new Callable<CsmCacheMap>(){

        @Override
        public CsmCacheMap call() {
            return new CsmCacheMap("FileMaps Cache");
        }
    };

    public FileMapsCollector(CsmFile file, CsmFile startFile, int stopAtOffset) {
        this.currentFile = file;
        this.startFile = startFile;
        this.stopAtOffset = stopAtOffset;
        this.collectedDependencies = false;
    }

    CsmDeclaration getUsingDeclaration(CharSequence name) {
        CharSequence s = CharSequences.create((CharSequence)name);
        ArrayList<CsmObject> list = this.usingDeclarations.get(s);
        if (list == null) {
            return null;
        }
        ListIterator<CsmObject> listIterator = list.listIterator(list.size());
        while (listIterator.hasPrevious()) {
            CsmObject obj = listIterator.previous();
            if (CsmKindUtilities.isUsingDeclaration((CsmObject)obj)) {
                CsmDeclaration decl = ((CsmUsingDeclaration)obj).getReferencedDeclaration();
                listIterator.set((CsmObject)decl);
                if (decl == null) continue;
                return decl;
            }
            if (!CsmKindUtilities.isDeclaration((CsmObject)obj)) continue;
            return (CsmDeclaration)obj;
        }
        return null;
    }

    Object getNamespaceAlias(CharSequence name) {
        CharSequence s = CharSequences.create((CharSequence)name);
        CsmObject obj = this.namespaceAliases.get(s);
        CsmNamespace ns = null;
        if (CsmKindUtilities.isNamespaceAlias((CsmObject)obj)) {
            CsmNamespaceAlias alias = (CsmNamespaceAlias)obj;
            ns = alias.getReferencedNamespace();
            this.namespaceAliases.put(s, (CsmObject)ns);
        } else if (CsmKindUtilities.isNamespace((Object)obj)) {
            ns = (CsmNamespace)obj;
        }
        return ns;
    }

    Map<CharSequence, CsmObject> getUsedNamespaces() {
        return this.usedNamespaces;
    }

    void rememberResolvedUsing(CharSequence key, CsmNamespace value) {
    }

    void initFileMaps(boolean needClassifiers, Callback callback) {
        if (!FileImpl.isFileBeingParsedInCurrentThread(this.currentFile) && !this.collectedDependencies) {
            CsmInclude inc;
            this.filesCollectorCache = (CsmCacheMap)CsmCacheManager.getClientCache(FileMapsCollector.class, CACHE_INITIALIZER);
            this.collectedDependencies = true;
            int lastIncludeOffset = 0;
            ArrayList<CsmInclude> incBeforeOffset = new ArrayList<CsmInclude>();
            Iterator iter = CsmSelect.getIncludes((CsmFile)this.currentFile, (CsmSelect.CsmFilter)CsmSelect.getFilterBuilder().createOffsetFilter(0, this.stopAtOffset));
            while (iter.hasNext() && (inc = (CsmInclude)iter.next()).getStartOffset() < this.stopAtOffset) {
                incBeforeOffset.add(inc);
                lastIncludeOffset = inc.getEndOffset();
            }
            MapsCollection out = new MapsCollection(EMPTY_CALLBACK, needClassifiers, this.visitedFiles, this.usedNamespaces, this.namespaceAliases, this.usingDeclarations);
            FileMapsCacheKey incKey = new FileMapsCacheKey(lastIncludeOffset, this.startFile, this.currentFile, out.needClassifiers());
            if (!this.findInCache(incKey, out)) {
                long allTime = System.currentTimeMillis();
                List includeStack = CsmFileInfoQuery.getDefault().getIncludeStack(this.currentFile);
                for (CsmInclude inc2 : includeStack) {
                    CsmFile includedFrom = inc2.getContainingFile();
                    int incOffset = inc2.getStartOffset();
                    FileMapsCollector.gatherMaps(includedFrom, incOffset, out);
                }
                if (Resolver3.LOGGER.isLoggable(Level.FINE)) {
                    Resolver3.LOGGER.log(Level.FINE, "{0}ms initMapsFromIncludeStack for {1}\n\twith start file {2}\n", new Object[]{System.currentTimeMillis() - allTime, this.currentFile.getAbsolutePath(), this.startFile.getAbsolutePath()});
                }
                long incTime = System.currentTimeMillis();
                for (CsmInclude inc3 : incBeforeOffset) {
                    CsmFile incFile = inc3.getIncludeFile();
                    if (incFile == null) continue;
                    FileMapsCollector.gatherMaps(incFile, Integer.MAX_VALUE, out);
                }
                if (Resolver3.LOGGER.isLoggable(Level.FINE)) {
                    Resolver3.LOGGER.log(Level.FINE, "{0}ms initMapsFromIncludes for {1}\n\twith start file {2}\n", new Object[]{System.currentTimeMillis() - incTime, this.currentFile.getAbsolutePath(), this.startFile.getAbsolutePath()});
                }
                allTime = System.currentTimeMillis() - allTime;
                if (this.filesCollectorCache != null) {
                    if (Resolver3.LOGGER.isLoggable(Level.FINE)) {
                        Resolver3.LOGGER.log(Level.FINE, "KEEP INCLUDE STACK {0}=>{1} ({2}) Took {3}ms\n", new Object[]{this.startFile, this.currentFile, out.needClassifiers(), allTime});
                    }
                    this.filesCollectorCache.put((Object)incKey, (CsmCacheMap.Value)new FileMapsCacheValue(out, allTime));
                }
            }
        }
        this.initMapsFromCurrentFileOnly(needClassifiers, this.stopAtOffset, callback);
    }

    void initMapsFromCurrentFileOnly(boolean needClassifiers, int stopAtOffset, Callback callback) {
        assert (stopAtOffset != Integer.MAX_VALUE);
        CsmSelect.CsmFilter filter = CsmSelect.getFilterBuilder().createOffsetFilter(0, stopAtOffset);
        Iterator declarations = CsmSelect.getDeclarations((CsmFile)this.currentFile, (CsmSelect.CsmFilter)filter);
        MapsCollection out = new MapsCollection(callback, needClassifiers, this.visitedFiles, this.usedNamespaces, this.namespaceAliases, this.usingDeclarations);
        FileMapsCollector.gatherMaps(declarations, false, stopAtOffset, out);
    }

    private boolean findInCache(FileMapsCacheKey cacheKey, MapsCollection maps) {
        FileMapsCacheValue cacheValue = null;
        if (this.filesCollectorCache != null) {
            cacheValue = (FileMapsCacheValue)this.filesCollectorCache.get((Object)cacheKey);
        }
        if (cacheValue != null) {
            String kind;
            cacheValue.copyTo(maps);
            ++cacheValue.hits;
            String string = kind = cacheKey.lastSearchedIncudeOffset == -1 ? "STACK" : "INCLUDE";
            if (Resolver3.LOGGER.isLoggable(Level.FINE)) {
                Resolver3.LOGGER.log(Level.FINE, "HIT {4} {0}=>{1} ({2}) Hits {3}\n", new Object[]{this.startFile, this.currentFile, maps.needClassifiers(), cacheValue.hits, kind});
            }
            return true;
        }
        return false;
    }

    private static void gatherMaps(CsmFile file, int stopAtOffset, MapsCollection out) {
        CsmInclude inc;
        if (file == null || !file.isValid() || out.antiLoop.contains(file)) {
            return;
        }
        out.antiLoop.add(file);
        CsmSelect.CsmFilter filter = stopAtOffset == Integer.MAX_VALUE ? NO_FILTER : CsmSelect.getFilterBuilder().createOffsetFilter(0, stopAtOffset);
        Iterator iter = CsmSelect.getIncludes((CsmFile)file, (CsmSelect.CsmFilter)filter);
        while (iter.hasNext() && (inc = (CsmInclude)iter.next()).getStartOffset() < stopAtOffset) {
            CsmFile incFile = inc.getIncludeFile();
            if (incFile == null) continue;
            FileMapsCollector.gatherMaps(incFile, Integer.MAX_VALUE, out);
        }
        if (stopAtOffset == Integer.MAX_VALUE) {
            filter = out.needClassifiers() ? CLASS_FILTER : NAMESPACE_FILTER;
        }
        Iterator declarations = CsmSelect.getDeclarations((CsmFile)file, (CsmSelect.CsmFilter)filter);
        FileMapsCollector.gatherMaps(declarations, false, stopAtOffset, out);
    }

    private static void gatherMaps(Iterator<? extends CsmObject> it, boolean inLocalContext, int stopAtOffset, MapsCollection out) {
        while (it.hasNext()) {
            CsmObject o = it.next();
            assert (o == null || CsmKindUtilities.isOffsetable((Object)o)) : "non CsmOffsetable" + o;
            if (o == null) {
                if (!FileImpl.reportErrors) continue;
                DiagnosticExceptoins.register(new NullPointerException("Unexpected NULL element in declarations collection"));
                continue;
            }
            int start = ((CsmOffsetable)o).getStartOffset();
            int end = ((CsmOffsetable)o).getEndOffset();
            if (start >= stopAtOffset) break;
            if (CsmKindUtilities.isScopeElement((CsmObject)o)) {
                if (!inLocalContext && CsmKindUtilities.isFunctionDefinition((CsmObject)o)) {
                    if (end < stopAtOffset) continue;
                    FileMapsCollector.gatherMaps((CsmScopeElement)o, end, true, stopAtOffset, out);
                    continue;
                }
                FileMapsCollector.gatherMaps((CsmScopeElement)o, end, inLocalContext, stopAtOffset, out);
                continue;
            }
            if (!FileImpl.reportErrors) continue;
            System.err.println("Expected CsmScopeElement, got " + o);
        }
    }

    private static void gatherMaps(CsmScopeElement element, int endOfScopeElement, boolean inLocalContext, int stopAtOffset, MapsCollection out) {
        CsmDeclaration.Kind kind;
        CsmDeclaration.Kind kind2 = kind = CsmKindUtilities.isDeclaration((CsmObject)element) ? ((CsmDeclaration)element).getKind() : null;
        if (kind != null) {
            switch (kind) {
                case NAMESPACE_DEFINITION: {
                    CsmNamespaceDefinition nsd = (CsmNamespaceDefinition)element;
                    if (nsd.getName().length() == 0) {
                        out.usedNamespaces.put(nsd.getQualifiedName(), nsd.getNamespace());
                    }
                    if (stopAtOffset < endOfScopeElement || out.needToTraverseDeeper((CsmScope)nsd)) {
                        if (nsd.getNamespace() instanceof NamespaceImpl) {
                            NamespaceImpl namespace = (NamespaceImpl)nsd.getNamespace();
                            for (CsmUID<CsmUsingDirective> directiveUID : namespace.getUsingDirectives()) {
                                CsmUsingDirective directive = (CsmUsingDirective)directiveUID.getObject();
                                if (directive == null || directive.getContainingFile() == null) continue;
                                int stopAtOffsetDirective = directive.getContainingFile().equals(nsd.getContainingFile()) ? stopAtOffset : Integer.MAX_VALUE;
                                FileMapsCollector.gatherMaps((CsmScopeElement)directive, directive.getEndOffset(), inLocalContext, stopAtOffsetDirective, out);
                            }
                            Iterator udecls = CsmSelect.getDeclarations((CsmNamespace)namespace, (CsmSelect.CsmFilter)CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.USING_DECLARATION}));
                            while (udecls.hasNext()) {
                                CsmUsingDeclaration usingDecl = (CsmUsingDeclaration)udecls.next();
                                int stopAtOffsetDecl = usingDecl.getContainingFile().equals(nsd.getContainingFile()) ? stopAtOffset : Integer.MAX_VALUE;
                                FileMapsCollector.gatherMaps((CsmScopeElement)usingDecl, usingDecl.getEndOffset(), inLocalContext, stopAtOffsetDecl, out);
                            }
                        } else {
                            Resolver3.LOGGER.log(Level.WARNING, "Unexpected implementation of logical namespace: {0}", nsd.getNamespace().getClass());
                        }
                        FileMapsCollector.gatherMaps(nsd.getDeclarations().iterator(), inLocalContext, stopAtOffset, out);
                    } else if (out.needClassifiers()) {
                        // empty if block
                    }
                    return;
                }
                case NAMESPACE_ALIAS: {
                    if (stopAtOffset > endOfScopeElement) {
                        CsmNamespaceAlias alias = (CsmNamespaceAlias)element;
                        out.namespaceAliases.put(alias.getAlias(), (CsmNamespaceAlias)element);
                    }
                    return;
                }
                case USING_DECLARATION: {
                    if (stopAtOffset > endOfScopeElement) {
                        CsmUsingDeclaration usingDecl = (CsmUsingDeclaration)element;
                        CharSequence name = usingDecl.getName();
                        int lastIndex = CharSequenceUtils.lastIndexOf((CharSequence)name, (CharSequence)"::");
                        if (lastIndex >= 0) {
                            name = name.subSequence(lastIndex + 2, name.length());
                        }
                        name = CharSequences.create((CharSequence)name);
                        ArrayList<CsmUsingDeclaration> list = (ArrayList<CsmUsingDeclaration>)out.usingDeclarations.get(name);
                        if (list == null) {
                            list = new ArrayList<CsmUsingDeclaration>();
                            out.usingDeclarations.put(name, list);
                        }
                        if (!list.contains(usingDecl)) {
                            list.add(usingDecl);
                        }
                    }
                    return;
                }
                case USING_DIRECTIVE: {
                    if (stopAtOffset > endOfScopeElement) {
                        CsmUsingDirective udir = (CsmUsingDirective)element;
                        CharSequence name = udir.getName();
                        if (!out.usedNamespaces.containsKey(name)) {
                            out.usedNamespaces.put(name, udir);
                        }
                    }
                    return;
                }
                case TYPEALIAS: 
                case TYPEDEF: {
                    CsmTypedef typedef = (CsmTypedef)element;
                    if (stopAtOffset > endOfScopeElement) {
                        out.onVisibleClassifier((CsmClassifier)typedef);
                    }
                    return;
                }
            }
        }
        if (CsmKindUtilities.isDeclarationStatement((CsmObject)element)) {
            CsmDeclarationStatement ds = (CsmDeclarationStatement)element;
            if (ds.getStartOffset() < stopAtOffset) {
                FileMapsCollector.gatherMaps(((CsmDeclarationStatement)element).getDeclarators().iterator(), inLocalContext, stopAtOffset, out);
            }
        } else if (CsmKindUtilities.isScope((CsmObject)element)) {
            if (inLocalContext && out.needClassifiers() && CsmKindUtilities.isClassifier((CsmObject)element) && (!CsmKindUtilities.isClassForwardDeclaration((CsmObject)element) || stopAtOffset > endOfScopeElement)) {
                out.onVisibleClassifier((CsmClassifier)element);
            }
            if (stopAtOffset < endOfScopeElement || out.needToTraverseDeeper((CsmScope)element)) {
                FileMapsCollector.gatherMaps(((CsmScope)element).getScopeElements().iterator(), inLocalContext, stopAtOffset, out);
            }
        } else if (CsmKindUtilities.isVariable((CsmObject)element)) {
            FileMapsCollector.gatherMaps(((CsmVariable)element).getInitialValue(), inLocalContext, stopAtOffset, out);
        } else if (CsmKindUtilities.isReturnStatement((CsmObject)element)) {
            FileMapsCollector.gatherMaps(((CsmReturnStatement)element).getReturnExpression(), inLocalContext, stopAtOffset, out);
        }
    }

    private static void gatherMaps(CsmExpression expr, boolean inLocalContext, int stopAtOffset, MapsCollection out) {
        if (expr != null && expr.getLambdas() != null) {
            for (CsmStatement lambdaStmt : expr.getLambdas()) {
                assert (CsmKindUtilities.isDeclarationStatement((CsmObject)lambdaStmt)) : "Found lamda statement of type: " + lambdaStmt.getClass();
                CsmDeclarationStatement ds = (CsmDeclarationStatement)lambdaStmt;
                if (ds.getStartOffset() >= stopAtOffset) continue;
                FileMapsCollector.gatherMaps(ds.getDeclarators().iterator(), inLocalContext, stopAtOffset, out);
            }
        }
    }

    private static final class FileMapsCacheValue
    implements CsmCacheMap.TraceValue {
        private final Map<CharSequence, CsmObject> usedNamespaces;
        private final Map<CharSequence, CsmObject> namespaceAliases;
        private final Map<CharSequence, ArrayList<CsmObject>> usingDeclarations;
        private final Set<CsmFile> antiLoop;
        final long resolveTime;
        int hits = 0;

        public FileMapsCacheValue(MapsCollection out, long resolveTime) {
            this.antiLoop = new HashSet<CsmFile>(out.antiLoop);
            this.usedNamespaces = new LinkedHashMap<CharSequence, CsmObject>(out.usedNamespaces);
            this.namespaceAliases = new HashMap<CharSequence, CsmObject>(out.namespaceAliases);
            this.usingDeclarations = new HashMap<CharSequence, ArrayList<CsmObject>>(out.usingDeclarations);
            this.resolveTime = resolveTime;
        }

        public void copyTo(MapsCollection out) {
            out.antiLoop.addAll(this.antiLoop);
            out.usedNamespaces.putAll(this.usedNamespaces);
            out.namespaceAliases.putAll(this.namespaceAliases);
            out.usingDeclarations.putAll(this.usingDeclarations);
        }

        public String toString() {
            String saved = "";
            if (this.hits > 0 && this.resolveTime > 0L) {
                saved = ", saved=" + (long)this.hits * this.resolveTime + "ms";
            }
            return "HITS=" + this.hits + ", resolveTime=" + this.resolveTime + saved;
        }

        public Object getResult() {
            return this;
        }

        public int onCacheHit() {
            return ++this.hits;
        }

        public int getHitsCount() {
            return this.hits;
        }

        public long getCalculationTime() {
            return this.resolveTime;
        }
    }

    private static final class FileMapsCacheKey {
        private final CsmFile startFile;
        private final CsmFile file;
        private final boolean needClassifiers;
        private final int lastSearchedIncudeOffset;
        private int hashCode = 0;

        public FileMapsCacheKey(int lastSearchedIncudeOffset, CsmFile startFile, CsmFile file, boolean needClassifiers) {
            this.startFile = startFile;
            this.file = file;
            this.lastSearchedIncudeOffset = lastSearchedIncudeOffset;
            this.needClassifiers = needClassifiers;
        }

        public String toString() {
            return "FileMapsCacheKey{file=" + this.file + "startFile=" + this.startFile + ", needClassifiers=" + this.needClassifiers + ", hashCode=" + this.hashCode + '}';
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int hash = 7;
                hash = 41 * hash + this.lastSearchedIncudeOffset;
                hash = 41 * hash + Objects.hashCode(this.startFile);
                hash = 41 * hash + Objects.hashCode(this.file);
                this.hashCode = hash = 41 * hash + (this.needClassifiers ? 0 : 1);
            }
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FileMapsCacheKey other = (FileMapsCacheKey)obj;
            if (this.hashCode != other.hashCode && this.hashCode != 0 && other.hashCode != 0) {
                return false;
            }
            if (this.lastSearchedIncudeOffset != other.lastSearchedIncudeOffset) {
                return false;
            }
            if (this.needClassifiers != other.needClassifiers) {
                return false;
            }
            if (!Objects.equals(this.file, other.file)) {
                return false;
            }
            return Objects.equals(this.startFile, other.startFile);
        }
    }

    private static final class MapsCollection {
        final boolean needClassifiers;
        private final Set<CsmFile> antiLoop;
        private final Map<CharSequence, CsmObject> usedNamespaces;
        private final Map<CharSequence, CsmObject> namespaceAliases;
        private final Map<CharSequence, ArrayList<CsmObject>> usingDeclarations;
        private final Callback callback;

        public MapsCollection(Callback cb, boolean needClassifiers, Set<CsmFile> antiLoop, Map<CharSequence, CsmObject> usedNamespaces, Map<CharSequence, CsmObject> namespaceAliases, Map<CharSequence, ArrayList<CsmObject>> usingDeclarations) {
            this.callback = cb;
            this.needClassifiers = needClassifiers;
            this.antiLoop = antiLoop;
            this.usedNamespaces = usedNamespaces;
            this.namespaceAliases = namespaceAliases;
            this.usingDeclarations = usingDeclarations;
        }

        public boolean needClassifiers() {
            return this.needClassifiers;
        }

        public boolean needToTraverseDeeper(CsmScope scope) {
            return this.callback.needToTraverseDeeper(scope);
        }

        public void onVisibleClassifier(CsmClassifier cls) {
            this.callback.onVisibleClassifier(cls);
        }
    }

    static interface Callback {
        public boolean needToTraverseDeeper(CsmScope var1);

        public void onVisibleClassifier(CsmClassifier var1);
    }
}

