/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.impl.services;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.cnd.api.model.CsmErrorDirective;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.services.CsmCompilationUnit;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.project.IncludePath;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.project.NativeProjectSupport;
import org.netbeans.modules.cnd.apt.debug.APTTraceFlags;
import org.netbeans.modules.cnd.apt.support.APTHandlersSupport;
import org.netbeans.modules.cnd.apt.support.api.PPIncludeHandler;
import org.netbeans.modules.cnd.apt.support.api.PreprocHandler;
import org.netbeans.modules.cnd.apt.support.api.StartEntry;
import org.netbeans.modules.cnd.modelimpl.content.project.FileContainer;
import org.netbeans.modules.cnd.modelimpl.csm.IncludeImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ErrorDirectiveImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileBuffer;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.FilePreprocessorConditionState;
import org.netbeans.modules.cnd.modelimpl.csm.core.PreprocessorStatePair;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.parser.apt.APTFileInfoQuerySupport;
import org.netbeans.modules.cnd.modelimpl.parser.clank.ClankFileInfoQuerySupport;
import org.netbeans.modules.cnd.modelimpl.platform.CndParserResult;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;
import org.netbeans.modules.cnd.support.Interrupter;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.text.NbDocument;
import org.openide.util.Pair;

public final class FileInfoQueryImpl
extends CsmFileInfoQuery {
    private final ConcurrentMap<CsmFile, Object> macroUsagesLocks = new ConcurrentHashMap<CsmFile, Object>();

    public boolean isCpp98OrLater(CsmFile csmFile) {
        Pair<NativeFileItem.Language, NativeFileItem.LanguageFlavor> languageFlavor;
        return csmFile != null && (NativeFileItem.Language.CPP == (languageFlavor = this.getFileLanguageFlavor(csmFile)).first() || NativeFileItem.Language.C_HEADER == languageFlavor.first());
    }

    public boolean isCpp11OrLater(CsmFile csmFile) {
        Pair<NativeFileItem.Language, NativeFileItem.LanguageFlavor> languageFlavor;
        if (csmFile != null && (NativeFileItem.Language.CPP == (languageFlavor = this.getFileLanguageFlavor(csmFile)).first() || NativeFileItem.Language.C_HEADER == languageFlavor.first())) {
            switch ((NativeFileItem.LanguageFlavor)languageFlavor.second()) {
                case CPP11: 
                case CPP14: {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isCpp14OrLater(CsmFile csmFile) {
        Pair<NativeFileItem.Language, NativeFileItem.LanguageFlavor> languageFlavor;
        if (csmFile != null && (NativeFileItem.Language.CPP == (languageFlavor = this.getFileLanguageFlavor(csmFile)).first() || NativeFileItem.Language.C_HEADER == languageFlavor.first())) {
            switch ((NativeFileItem.LanguageFlavor)languageFlavor.second()) {
                case CPP14: {
                    return true;
                }
            }
        }
        return false;
    }

    public List<IncludePath> getSystemIncludePaths(CsmFile file) {
        return this.getIncludePaths(file, true);
    }

    public List<IncludePath> getUserIncludePaths(CsmFile file) {
        return this.getIncludePaths(file, false);
    }

    private List<IncludePath> getIncludePaths(CsmFile file, boolean system) {
        NativeFileItem item;
        List out = Collections.emptyList();
        if (file instanceof FileImpl && (item = Utils.getCompiledFileItem((FileImpl)file)) != null) {
            if (item.getLanguage() == NativeFileItem.Language.C_HEADER) {
                NativeProject nativeProject = item.getNativeProject();
                if (nativeProject != null) {
                    out = system ? nativeProject.getSystemIncludePaths() : nativeProject.getUserIncludePaths();
                }
            } else {
                out = system ? item.getSystemIncludePaths() : item.getUserIncludePaths();
            }
        }
        return out;
    }

    public List<CsmOffsetable> getUnusedCodeBlocks(CsmFile file, Interrupter interrupter) {
        List<CsmOffsetable> out;
        block2: {
            FileImpl fileImpl;
            block3: {
                out = Collections.emptyList();
                if (!(file instanceof FileImpl)) break block2;
                fileImpl = (FileImpl)file;
                Collection<PreprocessorStatePair> statePairs = fileImpl.getPreprocStatePairs();
                List<CsmOffsetable> result = new ArrayList<CsmOffsetable>();
                boolean first = true;
                for (PreprocessorStatePair pair : statePairs) {
                    FilePreprocessorConditionState state = pair.pcState;
                    if (state == FilePreprocessorConditionState.PARSING || state.isFromErrorDirective()) continue;
                    List<CsmOffsetable> blocks = state.createBlocksForFile(fileImpl);
                    if (first) {
                        result = blocks;
                        first = false;
                        continue;
                    }
                    if (!(result = FileInfoQueryImpl.intersection(result, blocks)).isEmpty()) continue;
                    break;
                }
                if (result.isEmpty()) break block3;
                out = result;
                break block2;
            }
            CsmOffsetable error = null;
            Iterator<CsmErrorDirective> iterator = fileImpl.getErrors().iterator();
            if (!iterator.hasNext()) break block2;
            CsmErrorDirective csmErrorDirective = iterator.next();
            error = Utils.createOffsetable(fileImpl, csmErrorDirective.getEndOffset(), Integer.MAX_VALUE);
            out = Collections.singletonList(error);
        }
        return out;
    }

    private static boolean contains(CsmOffsetable bigger, CsmOffsetable smaller) {
        return bigger != null && smaller != null && bigger.getStartOffset() <= smaller.getStartOffset() && smaller.getEndOffset() <= bigger.getEndOffset();
    }

    private static List<CsmOffsetable> intersection(Collection<CsmOffsetable> first, Collection<CsmOffsetable> second) {
        ArrayList<CsmOffsetable> result = new ArrayList<CsmOffsetable>(Math.max(first.size(), second.size()));
        for (CsmOffsetable o1 : first) {
            for (CsmOffsetable o2 : second) {
                if (o1 == null) continue;
                if (o1.equals(o2)) {
                    result.add(o1);
                    continue;
                }
                if (FileInfoQueryImpl.contains(o1, o2)) {
                    result.add(o2);
                    continue;
                }
                if (!FileInfoQueryImpl.contains(o2, o1)) continue;
                result.add(o1);
            }
        }
        return result;
    }

    public CharSequence getName(CsmUID<CsmFile> fileUID) {
        return FileInfoQueryImpl.getFileName(fileUID);
    }

    public static CharSequence getFileName(CsmUID<CsmFile> fileUID) {
        CharSequence filePath = UIDUtilities.getFileName(fileUID);
        int indx = CharSequenceUtilities.lastIndexOf((CharSequence)filePath, (int)47);
        if (indx < 0) {
            indx = CharSequenceUtilities.lastIndexOf((CharSequence)filePath, (int)92);
        }
        if (indx > 0 && indx < filePath.length()) {
            filePath = CharSequenceUtilities.toString((CharSequence)filePath, (int)(indx + 1), (int)filePath.length());
        }
        return filePath;
    }

    public CharSequence getAbsolutePath(CsmUID<CsmFile> fileUID) {
        return UIDUtilities.getFileName(fileUID);
    }

    public boolean isDocumentBasedFile(CsmFile file) {
        if (file instanceof FileImpl) {
            FileImpl impl = (FileImpl)file;
            FileBuffer buffer = impl.getBuffer();
            return !buffer.isFileBased();
        }
        return false;
    }

    public CsmFile getCsmFile(Parser.Result parseResult) {
        if (parseResult instanceof CndParserResult) {
            return ((CndParserResult)parseResult).getCsmFile();
        }
        return null;
    }

    public static int getIncludeDirectiveIndex(CsmInclude inc) {
        if (inc instanceof IncludeImpl) {
            return ((IncludeImpl)inc).getIncludeDirectiveIndex();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CsmReference> getMacroUsages(CsmFile file, Document doc, Interrupter interrupter) {
        List<CsmReference> out = Collections.emptyList();
        if (file instanceof FileImpl) {
            FileImpl fileImpl = (FileImpl)file;
            Object lock = new NamedLock(file.getAbsolutePath());
            Object prevLock = this.macroUsagesLocks.putIfAbsent(fileImpl, lock);
            lock = prevLock != null ? prevLock : lock;
            try {
                Object object = lock;
                synchronized (object) {
                    block15: {
                        List<CsmReference> res = fileImpl.getLastMacroUsages();
                        if (res == null) break block15;
                        List<CsmReference> list = res;
                        return list;
                    }
                    try {
                        long lastParsedTime = fileImpl.getLastParsedTime();
                        out = APTTraceFlags.USE_CLANK ? ClankFileInfoQuerySupport.getMacroUsages(fileImpl, interrupter) : APTFileInfoQuerySupport.getMacroUsages(fileImpl, interrupter);
                        if (lastParsedTime == fileImpl.getLastParsedTime() && !interrupter.cancelled()) {
                            if (!out.isEmpty() && doc != null) {
                                ArrayList<CsmReference> wrapper = new ArrayList<CsmReference>(out.size());
                                for (CsmReference ref : out) {
                                    wrapper.add(new ProxyReference(ref, doc));
                                }
                                out = wrapper;
                            }
                            fileImpl.setLastMacroUsages(out);
                        }
                    }
                    catch (FileNotFoundException lastParsedTime) {
                    }
                    catch (IOException ex) {
                        System.err.println("skip marking macros\nreason:" + ex.getMessage());
                        DiagnosticExceptoins.register(ex);
                    }
                }
            }
            finally {
                this.macroUsagesLocks.remove(fileImpl, lock);
            }
        }
        return out;
    }

    public CsmOffsetable getGuardOffset(CsmFile file) {
        if (file instanceof FileImpl) {
            FileImpl fileImpl = (FileImpl)file;
            if (APTTraceFlags.USE_CLANK) {
                return ClankFileInfoQuerySupport.getGuardOffset(fileImpl);
            }
            return APTFileInfoQuerySupport.getGuardOffset(fileImpl);
        }
        return null;
    }

    public boolean hasGuardBlock(CsmFile file) {
        if (file instanceof FileImpl) {
            FileImpl fileImpl = (FileImpl)file;
            if (APTTraceFlags.USE_CLANK) {
                return ClankFileInfoQuerySupport.hasGuardBlock(fileImpl);
            }
            return APTFileInfoQuerySupport.hasGuardBlock(fileImpl);
        }
        return false;
    }

    public NativeFileItem getNativeFileItem(CsmFile file) {
        if (file instanceof FileImpl) {
            return ((FileImpl)file).getNativeFileItem();
        }
        return null;
    }

    public Pair<NativeFileItem.Language, NativeFileItem.LanguageFlavor> getFileLanguageFlavor(CsmFile csmFile) {
        if (csmFile != null) {
            Collection<CsmCompilationUnit> compilationUnits = this.getCompilationUnits(csmFile, 0);
            if (!compilationUnits.isEmpty()) {
                NativeFileItem.Language bestLanguage = null;
                NativeFileItem.LanguageFlavor bestFlavor = null;
                for (CsmCompilationUnit cu : compilationUnits) {
                    NativeFileItem startItem = this.getNativeFileItem(cu.getStartFile());
                    if (startItem == null) continue;
                    if (this.getLangPriority(bestLanguage) < this.getLangPriority(startItem.getLanguage())) {
                        bestLanguage = startItem.getLanguage();
                    }
                    if (this.getFlavorPriority(bestFlavor) >= this.getFlavorPriority(startItem.getLanguageFlavor())) continue;
                    bestFlavor = startItem.getLanguageFlavor();
                }
                if (bestLanguage != null && bestFlavor != null) {
                    if (bestFlavor == NativeFileItem.LanguageFlavor.UNKNOWN) {
                        bestFlavor = NativeProjectSupport.getDefaultLanguageFlavor(bestLanguage);
                    }
                    return Pair.of(bestLanguage, (Object)bestFlavor);
                }
            }
            if (csmFile.isHeaderFile()) {
                return Pair.of((Object)NativeFileItem.Language.C_HEADER, (Object)NativeProjectSupport.getDefaultHeaderStandard());
            }
            if (csmFile.isSourceFile()) {
                return Pair.of((Object)NativeFileItem.Language.CPP, (Object)NativeProjectSupport.getDefaultCppStandard());
            }
        }
        return Pair.of((Object)NativeFileItem.Language.OTHER, (Object)NativeFileItem.LanguageFlavor.UNKNOWN);
    }

    private int getLangPriority(NativeFileItem.Language lang) {
        if (lang == null) {
            return -1;
        }
        switch (lang) {
            case OTHER: {
                return 0;
            }
            case C_HEADER: {
                return 1;
            }
            case C: {
                return 2;
            }
            case CPP: {
                return 3;
            }
        }
        return 0;
    }

    private int getFlavorPriority(NativeFileItem.LanguageFlavor flavor) {
        if (flavor == null) {
            return -1;
        }
        switch (flavor) {
            case DEFAULT: 
            case UNKNOWN: {
                return 0;
            }
            case C: {
                return 1;
            }
            case C89: {
                return 2;
            }
            case C99: {
                return 3;
            }
            case C11: {
                return 4;
            }
            case CPP: {
                return 5;
            }
            case CPP11: {
                return 6;
            }
            case CPP14: {
                return 7;
            }
        }
        return 0;
    }

    public Pair<String, String> getAPTLanguageFlavor(Pair<NativeFileItem.Language, NativeFileItem.LanguageFlavor> langFlavor) {
        String aptLang = "Unknown Language";
        switch ((NativeFileItem.Language)langFlavor.first()) {
            case C: {
                aptLang = "Gnu C Language";
                break;
            }
            case CPP: {
                aptLang = "Gnu C++ Language";
                break;
            }
            case C_HEADER: {
                aptLang = "Gnu C++ Language";
                break;
            }
            case FORTRAN: {
                aptLang = "Fortran Language";
            }
        }
        String aptFlavor = "";
        switch ((NativeFileItem.LanguageFlavor)langFlavor.second()) {
            case C: 
            case C89: 
            case C99: 
            case C11: {
                aptFlavor = "";
                break;
            }
            case CPP11: 
            case CPP14: 
            case CPP: {
                aptFlavor = "C++11";
                break;
            }
            case F77: 
            case F90: 
            case F95: {
                aptFlavor = "Fortran Free";
            }
        }
        return Pair.of((Object)aptLang, (Object)aptFlavor);
    }

    public Collection<CsmCompilationUnit> getCompilationUnits(CsmFile file, int contextOffset) {
        ArrayList<CsmCompilationUnit> out = new ArrayList<CsmCompilationUnit>(1);
        boolean addBackup = true;
        if (file instanceof FileImpl) {
            FileImpl impl = (FileImpl)file;
            ProjectBase prjImpl = (ProjectBase)impl.getProject();
            Collection<PreprocHandler.State> states = prjImpl.getIncludedPreprocStates(impl);
            ArrayList<CsmCompilationUnit> otherPrjCUs = new ArrayList<CsmCompilationUnit>(1);
            for (PreprocHandler.State state : states) {
                StartEntry startEntry = APTHandlersSupport.extractStartEntry((PreprocHandler.State)state);
                ProjectBase startProject = Utils.getStartProject(startEntry);
                if (startProject == null) continue;
                CharSequence path = startEntry.getStartFile();
                FileImpl startFile = startProject.getFile(path, false);
                if (startFile != null) {
                    addBackup = false;
                }
                CsmCompilationUnit cu = CsmCompilationUnit.createCompilationUnit((CsmProject)startProject, (CharSequence)path, (CsmFile)startFile);
                if (prjImpl.equals(startProject)) {
                    out.add(cu);
                    continue;
                }
                otherPrjCUs.add(cu);
            }
            out.addAll(otherPrjCUs);
        }
        if (addBackup) {
            out.add(CsmCompilationUnit.createCompilationUnit((CsmProject)file.getProject(), (CharSequence)file.getAbsolutePath(), (CsmFile)file));
        }
        return out;
    }

    public List<CsmInclude> getIncludeStack(CsmErrorDirective err) {
        PreprocHandler.State state = null;
        if (err instanceof ErrorDirectiveImpl) {
            state = ((ErrorDirectiveImpl)err).getState();
        }
        return this.getIncludeStackImpl(state);
    }

    public List<CsmInclude> getIncludeStack(CsmInclude inc) {
        return this.getIncludeStack(inc.getContainingFile());
    }

    public List<CsmInclude> getIncludeStack(CsmFile file) {
        PreprocHandler.State state = null;
        if (file instanceof FileImpl) {
            FileImpl impl = (FileImpl)file;
            CharSequence fileKey = FileContainer.getFileKey(impl.getAbsolutePath(), false);
            state = ((ProjectBase)impl.getProject()).getFirstValidPreprocState(fileKey);
        }
        return this.getIncludeStackImpl(state);
    }

    private List<CsmInclude> getIncludeStackImpl(PreprocHandler.State state) {
        FileImpl includeOwner;
        if (state == null) {
            return Collections.emptyList();
        }
        CndUtils.assertNotNull((Object)state, (String)"state must not be null in non empty collection");
        LinkedList includeChain = APTHandlersSupport.extractIncludeStack((PreprocHandler.State)state);
        StartEntry startEntry = APTHandlersSupport.extractStartEntry((PreprocHandler.State)state);
        ProjectBase startProject = Utils.getStartProject(startEntry);
        if (startProject != null && (includeOwner = startProject.getFile(startEntry.getStartFile(), false)) != null) {
            ArrayList<CsmInclude> res = new ArrayList<CsmInclude>();
            for (PPIncludeHandler.IncludeInfo info : includeChain) {
                int includeDirectiveIndex = info.getIncludeDirectiveIndex();
                CharSequence includedPath = info.getIncludedPath();
                CsmInclude foundDirective = null;
                CsmFile foundIncludedFile = null;
                for (CsmInclude inc : includeOwner.getIncludes()) {
                    CsmFile includedFile;
                    int currentIncludeIndex = FileInfoQueryImpl.getIncludeDirectiveIndex(inc);
                    if (includeDirectiveIndex != currentIncludeIndex || (includedFile = inc.getIncludeFile()) == null || !CharSequenceUtils.contentEquals((CharSequence)includedPath, (CharSequence)includedFile.getAbsolutePath())) continue;
                    foundDirective = inc;
                    foundIncludedFile = includedFile;
                    if (inc.getStartOffset() != info.getIncludeDirectiveOffset()) continue;
                    break;
                }
                if (foundDirective == null) {
                    return Collections.emptyList();
                }
                assert (foundIncludedFile != null) : "must be initialized with " + foundDirective;
                includeOwner = foundIncludedFile;
                res.add(foundDirective);
            }
            return res;
        }
        return Collections.emptyList();
    }

    public boolean hasBrokenIncludes(CsmFile file) {
        if (file instanceof FileImpl) {
            FileImpl impl = (FileImpl)file;
            boolean res = impl.hasBrokenIncludes();
            if (res && this.isStandardHeadersIndexer(file)) {
                return false;
            }
            return res;
        }
        return false;
    }

    public boolean isStandardHeadersIndexer(CsmFile file) {
        NativeProject nativeProject;
        FileImpl impl;
        NativeFileItem nativeFileItem;
        return file instanceof FileImpl && (nativeFileItem = (impl = (FileImpl)file).getNativeFileItem()) != null && (nativeProject = nativeFileItem.getNativeProject()) != null && nativeProject.getStandardHeadersIndexers().contains(nativeFileItem);
    }

    public Collection<CsmInclude> getBrokenIncludes(CsmFile file) {
        if (file instanceof FileImpl && ((FileImpl)file).hasBrokenIncludes()) {
            return ((FileImpl)file).getBrokenIncludes();
        }
        return Collections.emptyList();
    }

    public long getFileVersion(CsmFile file) {
        if (file instanceof FileImpl) {
            return FileImpl.getLongParseCount();
        }
        return 0L;
    }

    public long getOffset(CsmFile file, int line, int column) {
        if (file instanceof FileImpl) {
            return ((FileImpl)file).getOffset(line, column);
        }
        return 0L;
    }

    public int getLineCount(CsmFile file) {
        if (file instanceof FileImpl) {
            try {
                return ((FileImpl)file).getBuffer().getLineCount();
            }
            catch (IOException ex) {
                CndUtils.assertTrueInConsole((boolean)false, (String)ex.getMessage());
            }
        }
        return 0;
    }

    public int[] getLineColumnByOffset(CsmFile file, int offset) {
        if (file instanceof FileImpl) {
            return ((FileImpl)file).getLineColumn(offset);
        }
        return new int[]{0, 0};
    }

    private static final class ProxyPosition
    implements CsmOffsetable.Position {
        private final Position position;
        private final CsmOffsetable.Position owner;

        private ProxyPosition(Position delegate, CsmOffsetable.Position owner) {
            this.position = delegate;
            this.owner = owner;
        }

        public int getOffset() {
            if (this.position != null) {
                return this.position.getOffset();
            }
            return this.owner.getOffset();
        }

        public int getLine() {
            return this.owner.getLine();
        }

        public int getColumn() {
            return this.owner.getColumn();
        }
    }

    private static final class ProxyReference
    implements CsmReference {
        private final CsmReference delegate;
        private Position startPosition;
        private Position endPosition;

        private ProxyReference(CsmReference delegate, Document doc) {
            this.delegate = delegate;
            try {
                this.startPosition = NbDocument.createPosition((Document)doc, (int)delegate.getStartOffset(), (Position.Bias)Position.Bias.Forward);
                this.endPosition = NbDocument.createPosition((Document)doc, (int)delegate.getEndOffset(), (Position.Bias)Position.Bias.Backward);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        public CsmReferenceKind getKind() {
            return this.delegate.getKind();
        }

        public CsmObject getReferencedObject() {
            return this.delegate.getReferencedObject();
        }

        public CsmObject getOwner() {
            return this.delegate.getOwner();
        }

        public CsmObject getClosestTopLevelObject() {
            return this.delegate.getClosestTopLevelObject();
        }

        public CsmFile getContainingFile() {
            return this.delegate.getContainingFile();
        }

        public int getStartOffset() {
            return this.getStartPosition().getOffset();
        }

        public int getEndOffset() {
            return this.getEndPosition().getOffset();
        }

        public CsmOffsetable.Position getStartPosition() {
            return new ProxyPosition(this.startPosition, this.delegate.getStartPosition());
        }

        public CsmOffsetable.Position getEndPosition() {
            return new ProxyPosition(this.endPosition, this.delegate.getEndPosition());
        }

        public CharSequence getText() {
            return this.delegate.getText();
        }
    }

    private static final class NamedLock {
        private final CharSequence name;

        public NamedLock(CharSequence name) {
            this.name = name;
        }

        public String toString() {
            return "getMacroUsages lock for " + this.name;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NamedLock other = (NamedLock)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public int hashCode() {
            int hash = 5;
            hash = 97 * hash + (this.name != null ? this.name.hashCode() : 0);
            return hash;
        }
    }
}

