/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.parser.clank;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.netbeans.modules.cnd.apt.support.APTHandlersSupport;
import org.netbeans.modules.cnd.apt.support.ClankDriver;
import org.netbeans.modules.cnd.apt.support.ResolvedPath;
import org.netbeans.modules.cnd.apt.support.api.PPIncludeHandler;
import org.netbeans.modules.cnd.apt.support.api.PreprocHandler;
import org.netbeans.modules.cnd.apt.support.api.StartEntry;
import org.netbeans.modules.cnd.apt.support.lang.APTLanguageFilter;
import org.netbeans.modules.cnd.apt.utils.APTCommentsFilter;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.modelimpl.content.file.FileContent;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileBuffer;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileBufferFile;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.FilePreprocessorConditionState;
import org.netbeans.modules.cnd.modelimpl.csm.core.Line2Offset;
import org.netbeans.modules.cnd.modelimpl.csm.core.PreprocessorStatePair;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.parser.clank.ClankToCsmSupport;
import org.netbeans.modules.cnd.modelimpl.parser.clank.ClankTokenStreamProducerParameters;
import org.netbeans.modules.cnd.modelimpl.parser.spi.TokenStreamProducer;
import org.netbeans.modules.cnd.support.Interrupter;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;

public final class ClankTokenStreamProducer
extends TokenStreamProducer {
    private int[] skipped;

    private ClankTokenStreamProducer(FileImpl file, FileContent newFileContent, boolean fromEnsureParsed) {
        super(file, newFileContent, fromEnsureParsed);
    }

    public static TokenStreamProducer createImpl(FileImpl file, FileContent newFileContent, boolean fromEnsureParsed) {
        return new ClankTokenStreamProducer(file, newFileContent, fromEnsureParsed);
    }

    public static List<CsmReference> getMacroUsages(FileImpl file, PreprocHandler handler, Interrupter interrupter) {
        FileContent newFileContent = FileContent.getHardReferenceBasedCopy(file.getCurrentFileContent(), true);
        ClankTokenStreamProducer tsp = new ClankTokenStreamProducer(file, newFileContent, false);
        PreprocHandler.State ppState = handler.getState();
        String contextLanguage = file.getContextLanguage(ppState);
        String contextLanguageFlavor = file.getContextLanguageFlavor(ppState);
        tsp.prepare(handler, contextLanguage, contextLanguageFlavor, false);
        ClankTokenStreamProducerParameters params = ClankTokenStreamProducerParameters.createForMacroUsages();
        List<CsmReference> res = tsp.getMacroUsages(params, interrupter);
        tsp.release();
        return res;
    }

    @Override
    public TokenStream getTokenStreamOfIncludedFile(PreprocHandler.State includeOwnerState, CsmInclude include, Interrupter interrupter) {
        FileImpl includeDirecitveFileOwner = this.getInterestedFile();
        FileImpl includedFile = (FileImpl)include.getIncludeFile();
        if (includedFile == null) {
            return null;
        }
        ProjectBase projectImpl = includedFile.getProjectImpl(true);
        if (projectImpl == null) {
            return null;
        }
        PPIncludeHandler.IncludeInfo inclInfo = ClankTokenStreamProducer.createIncludeInfo(include);
        if (inclInfo == null) {
            return null;
        }
        PreprocHandler ppHandler = projectImpl.createPreprocHandlerFromState(includeDirecitveFileOwner.getAbsolutePath(), includeOwnerState);
        includeOwnerState = ppHandler.getState();
        LinkedList includeChain = APTHandlersSupport.extractIncludeStack((PreprocHandler.State)includeOwnerState);
        if (CndUtils.isDebugMode()) {
            StartEntry startEntry = APTHandlersSupport.extractStartEntry((PreprocHandler.State)includeOwnerState);
            if (includeChain.isEmpty()) {
                assert (startEntry.getFileSystem() == includeDirecitveFileOwner.getFileSystem());
                CndUtils.assertPathsEqualInConsole((CharSequence)startEntry.getStartFile(), (CharSequence)includeDirecitveFileOwner.getAbsolutePath(), (String)"different paths {0} vs. {1}", (Object[])new Object[]{startEntry, includeDirecitveFileOwner});
            } else {
                PPIncludeHandler.IncludeInfo includer = (PPIncludeHandler.IncludeInfo)includeChain.getLast();
                CndUtils.assertPathsEqualInConsole((CharSequence)includer.getIncludedPath(), (CharSequence)includeDirecitveFileOwner.getAbsolutePath(), (String)"different paths {0} vs. {1}", (Object[])new Object[]{includer, includeDirecitveFileOwner});
                assert (includer.getFileSystem() == includeDirecitveFileOwner.getFileSystem());
            }
        }
        includeChain.addLast(inclInfo);
        ClankTokenStreamProducerParameters params = ClankTokenStreamProducerParameters.createForIncludedTokenStream(this.getLanguage());
        VisitIncludeChainPreprocessorCallback callback = new VisitIncludeChainPreprocessorCallback(includeChain, params);
        boolean success = ClankDriver.preprocess((APTFileBuffer)includeDirecitveFileOwner.getBuffer(), (PreprocHandler)ppHandler, (ClankDriver.ClankPreprocessorCallback)callback, (Interrupter)interrupter);
        if (!success) {
            return null;
        }
        ClankDriver.ClankPreprocessorOutput ppOutput = callback.getPreparedPreprocessorOutput();
        if (ppOutput == null) {
            return null;
        }
        TokenStream tokenStream = ppOutput.getTokenStream();
        if (tokenStream == null) {
            return null;
        }
        this.skipped = new int[0];
        return tokenStream;
    }

    @Override
    public TokenStream getTokenStreamForParsingAndCaching(Interrupter interrupter) {
        ClankTokenStreamProducerParameters params = ClankTokenStreamProducerParameters.createForParsingAndTokenStreamCaching();
        ClankTokenStreamProducer.assertParamsReadyForCache(params);
        return this.preprocessAndGetFileTokenStream(this.getInterestedFile(), params, interrupter);
    }

    @Override
    public TokenStream getTokenStreamForParsing(String language, Interrupter interrupter) {
        FileImpl interestedFile = this.getInterestedFile();
        assert (interestedFile != null);
        PreprocHandler ppHandler = this.getCurrentPreprocHandler();
        ClankDriver.ClankPreprocessorOutput ppOutput = ClankDriver.extractPreprocessorOutput((PreprocHandler)ppHandler);
        assert (ppOutput != null);
        ClankTokenStreamProducerParameters params = ClankTokenStreamProducerParameters.createForParsing(language);
        TokenStream out = ppOutput.hasTokenStream() ? this.postProcessAndExtractTokenStream(interestedFile, ppOutput, params) : this.preprocessAndGetFileTokenStream(interestedFile, params, interrupter);
        return out;
    }

    @Override
    public TokenStream getTokenStreamForCaching(Interrupter interrupter) {
        ClankTokenStreamProducerParameters params = ClankTokenStreamProducerParameters.createForTokenStreamCaching();
        ClankTokenStreamProducer.assertParamsReadyForCache(params);
        return this.preprocessAndGetFileTokenStream(this.getInterestedFile(), params, interrupter);
    }

    @Override
    public FilePreprocessorConditionState release() {
        return FilePreprocessorConditionState.build(this.getInterestedFile().getAbsolutePath(), this.skipped);
    }

    private static void assertParamsReadyForCache(ClankTokenStreamProducerParameters params) {
        boolean ready;
        boolean bl = ready = params.needTokens != 1 && params.needComments != 1 && params.needMacroExpansion != 1 && !params.applyLanguageFilter;
        if (!ready) {
            CndUtils.assertTrue((boolean)false, (String)("Should be ready for cahcing: " + params));
        }
    }

    private List<CsmReference> getMacroUsages(ClankTokenStreamProducerParameters parameters, Interrupter interrupter) {
        FileImpl interestedFile = this.getInterestedFile();
        ClankDriver.ClankPreprocessorOutput foundFileInfo = this.getPreprocessorOutputForInterestedFile(interestedFile, parameters, interrupter);
        List<CsmReference> out = ClankToCsmSupport.getMacroUsages(interestedFile, this.getStartFile(), foundFileInfo);
        return out;
    }

    private TokenStream preprocessAndGetFileTokenStream(FileImpl fileImpl, ClankTokenStreamProducerParameters parameters, Interrupter interrupter) {
        ClankDriver.ClankPreprocessorOutput ppOutput = this.getPreprocessorOutputForInterestedFile(fileImpl, parameters, interrupter);
        if (ppOutput == null) {
            return null;
        }
        TokenStream tokenStream = this.postProcessAndExtractTokenStream(fileImpl, ppOutput, parameters);
        return tokenStream;
    }

    private TokenStream postProcessAndExtractTokenStream(FileImpl fileImpl, ClankDriver.ClankPreprocessorOutput ppOutput, ClankTokenStreamProducerParameters parameters) {
        assert (ppOutput != null);
        assert (ppOutput.hasTokenStream()) : "Only valid one can be asked to extract TS " + ppOutput;
        this.cacheMacroUsagesInFileIfNeed(fileImpl, parameters, ppOutput);
        if (super.isFromEnsureParsed()) {
            ClankToCsmSupport.addPreprocessorDirectives(fileImpl, this.getFileContent(), ppOutput);
            ClankToCsmSupport.addMacroExpansions(fileImpl, this.getFileContent(), this.getStartFile(), ppOutput);
            ClankToCsmSupport.setFileGuard(fileImpl, this.getFileContent(), ppOutput);
        }
        this.skipped = ppOutput.getSkippedRanges();
        TokenStream tokenStream = ppOutput.getTokenStream();
        if (tokenStream == null) {
            return null;
        }
        if (parameters.applyLanguageFilter) {
            PreprocHandler ppHandler = this.getCurrentPreprocHandler();
            APTLanguageFilter languageFilter = fileImpl.getLanguageFilter(ppHandler.getState());
            tokenStream = languageFilter.getFilteredStream((TokenStream)new APTCommentsFilter(tokenStream));
        }
        return tokenStream;
    }

    private ClankDriver.ClankPreprocessorOutput getPreprocessorOutputForInterestedFile(FileImpl interestedFile, ClankTokenStreamProducerParameters parameters, Interrupter interrupter) {
        ProjectBase projectImpl;
        FileBuffer buffer = interestedFile.getBuffer();
        if (this.getCodePatch() != null) {
            buffer = new PatchedFileBuffer(buffer, this.getCodePatch());
        }
        PreprocHandler ppHandler = this.getCurrentPreprocHandler();
        PreprocHandler.State state = ppHandler.getState();
        FileImpl startFile = this.getStartFile();
        ClankDriver.ClankPreprocessorOutput out = this.preprocessWithHandler(startFile, interestedFile, ppHandler, parameters, buffer, interrupter);
        if (out == null && super.isFromEnsureParsed() && (projectImpl = interestedFile.getProjectImpl(true)) != null && projectImpl.isValid()) {
            ppHandler = projectImpl.createDefaultPreprocHandler(interestedFile.getAbsolutePath());
            super.resetHandler(ppHandler);
            out = this.preprocessWithHandler(interestedFile, interestedFile, ppHandler, parameters, buffer, interrupter);
        }
        return out;
    }

    protected ClankDriver.ClankPreprocessorOutput preprocessWithHandler(FileImpl startFile, FileImpl interestedFile, PreprocHandler ppHandler, ClankTokenStreamProducerParameters parameters, FileBuffer buffer, Interrupter interrupter) {
        FileImplPreprocessorCallback callback = new FileImplPreprocessorCallback(startFile, interestedFile, ppHandler, parameters);
        if (ClankDriver.preprocess((APTFileBuffer)buffer, (PreprocHandler)ppHandler, (ClankDriver.ClankPreprocessorCallback)callback, (Interrupter)interrupter)) {
            return callback.getPreparedPreprocessorOutput();
        }
        return null;
    }

    private void cacheMacroUsagesInFileIfNeed(FileImpl fileImpl, ClankTokenStreamProducerParameters parameters, ClankDriver.ClankPreprocessorOutput foundFileInfo) {
        if (foundFileInfo == null) {
            return;
        }
        if (parameters.needMacroExpansion == 2 && parameters.needPPDirectives == 2) {
            List<CsmReference> macroUsages = ClankToCsmSupport.getMacroUsages(fileImpl, this.getStartFile(), foundFileInfo);
            fileImpl.setLastMacroUsages(macroUsages);
        }
    }

    private static final class PatchedFileBuffer
    implements FileBuffer {
        private final FileBuffer delegate;
        private final TokenStreamProducer.CodePatch codePatch;
        private char[] res;
        private Line2Offset lines;

        private PatchedFileBuffer(FileBuffer delegate, TokenStreamProducer.CodePatch patchCode) {
            this.delegate = delegate;
            this.codePatch = patchCode;
        }

        @Override
        public void addChangeListener(ChangeListener listener) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeChangeListener(ChangeListener listener) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isFileBased() {
            return this.delegate.isFileBased();
        }

        @Override
        public FileObject getFileObject() {
            return this.delegate.getFileObject();
        }

        @Override
        public CharSequence getUrl() {
            return this.delegate.getUrl();
        }

        @Override
        public String getText(int start, int end) throws IOException {
            return new String(this.getCharBuffer(), start, end - start);
        }

        @Override
        public CharSequence getText() throws IOException {
            return new FileBufferFile.MyCharSequence(this.getCharBuffer());
        }

        @Override
        public long lastModified() {
            return this.delegate.lastModified() + 1L;
        }

        @Override
        public long getCRC() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int[] getLineColumnByOffset(int offset) throws IOException {
            if (this.lines == null) {
                this.lines = new Line2Offset(this.getCharBuffer());
            }
            return this.lines.getLineColumnByOffset(offset);
        }

        @Override
        public int getLineCount() throws IOException {
            if (this.lines == null) {
                this.lines = new Line2Offset(this.getCharBuffer());
            }
            return this.lines.getLineCount();
        }

        @Override
        public int getOffsetByLineColumn(int line, int column) throws IOException {
            if (this.lines == null) {
                this.lines = new Line2Offset(this.getCharBuffer());
            }
            return this.lines.getOffsetByLineColumn(line, column);
        }

        public CharSequence getAbsolutePath() {
            return this.delegate.getAbsolutePath();
        }

        public FileSystem getFileSystem() {
            return this.delegate.getFileSystem();
        }

        public char[] getCharBuffer() throws IOException {
            if (this.res == null) {
                char[] charBuffer = this.delegate.getCharBuffer();
                char[] patch = this.codePatch.getPatch().toCharArray();
                this.res = new char[charBuffer.length - (this.codePatch.getEndOffset() - this.codePatch.getStartOffset()) + patch.length];
                System.arraycopy(charBuffer, 0, this.res, 0, this.codePatch.getStartOffset());
                System.arraycopy(patch, 0, this.res, this.codePatch.getStartOffset(), patch.length);
                System.arraycopy(charBuffer, this.codePatch.getEndOffset(), this.res, this.codePatch.getStartOffset() + patch.length, charBuffer.length - this.codePatch.getEndOffset());
            }
            return this.res;
        }

        public APTFileBuffer.BufferType getType() {
            return this.delegate.getType();
        }
    }

    private static final class FileImplPreprocessorCallback
    extends VisitIncludeChainPreprocessorCallback {
        private final FileImpl startFile;
        private final FileImpl interestedFile;
        private final ProjectBase startProject;
        private final PreprocHandler ppHandler;
        private final List<FileImpl> curFiles = new ArrayList<FileImpl>();

        public FileImplPreprocessorCallback(FileImpl startFile, FileImpl interestedFile, PreprocHandler ppHandler, ClankTokenStreamProducerParameters params) {
            super(APTHandlersSupport.extractIncludeStack((PreprocHandler.State)ppHandler.getState()), params);
            this.startFile = startFile;
            this.interestedFile = interestedFile;
            this.startProject = startFile.getProjectImpl(true);
            this.ppHandler = ppHandler;
        }

        private FileImpl getCurFile(boolean pop) {
            assert (this.curFiles.size() > 0);
            FileImpl curFile = pop ? this.curFiles.remove(this.curFiles.size() - 1) : this.curFiles.get(this.curFiles.size() - 1);
            assert (curFile != null);
            return curFile;
        }

        private void pushCurrentFile(FileImpl enteredToFileImpl) {
            this.curFiles.add(enteredToFileImpl);
        }

        @Override
        public void include(ClankDriver.ClankInclusionDirective directive) {
            ResolvedPath resolvedPath = directive.getResolvedPath();
            if (resolvedPath == null) {
                directive.setAnnotation((Object)ClankToCsmSupport.UnresolvedIncludeDirectiveReason.NULL_PATH);
                return;
            }
            FileImpl curFile = this.getCurFile(false);
            CharSequence path = resolvedPath.getPath();
            ProjectBase aStartProject = this.startProject;
            if (aStartProject != null) {
                if (aStartProject.isValid() && curFile.isValid()) {
                    FileImpl includedFile;
                    ProjectBase inclFileOwner = aStartProject.getLibraryManager().resolveFileProjectOnInclude(aStartProject, curFile, resolvedPath);
                    if (inclFileOwner == null && aStartProject.getFileSystem() == resolvedPath.getFileSystem()) {
                        inclFileOwner = aStartProject;
                    }
                    if (inclFileOwner == null) {
                        directive.setAnnotation((Object)new ClankToCsmSupport.UnresolvedIncludeDirectiveAnnotation(ClankToCsmSupport.UnresolvedIncludeDirectiveReason.UNRESOLVED_FILE_OWNER, resolvedPath));
                        return;
                    }
                    if (CndUtils.isDebugMode()) {
                        CndUtils.assertTrue((inclFileOwner.getFileSystem() == resolvedPath.getFileSystem() ? 1 : 0) != 0, (String)("Different FS for " + path + ": " + inclFileOwner.getFileSystem() + " vs " + resolvedPath.getFileSystem()));
                    }
                    if ((includedFile = inclFileOwner.prepareIncludedFile(aStartProject, path, this.ppHandler)) == null) {
                        if (CsmModelAccessor.isModelAlive() && inclFileOwner.isValid()) {
                            if (aStartProject.isValid()) {
                                APTUtils.LOG.log(Level.INFO, "something wrong when including {0} from {1}", new Object[]{path, curFile});
                                directive.setAnnotation((Object)new ClankToCsmSupport.UnresolvedIncludeDirectiveAnnotation(ClankToCsmSupport.UnresolvedIncludeDirectiveReason.START_PROJECT_CLOSED, this.startProject, resolvedPath, curFile));
                            } else {
                                APTUtils.LOG.log(Level.INFO, "invalid start project {0} when including {1} from {2}", new Object[]{aStartProject, path, curFile});
                                directive.setAnnotation((Object)new ClankToCsmSupport.UnresolvedIncludeDirectiveAnnotation(ClankToCsmSupport.UnresolvedIncludeDirectiveReason.INVALID_START_PROJECT, aStartProject, resolvedPath, curFile));
                            }
                        } else {
                            APTUtils.LOG.log(Level.INFO, "Start project {0} can not create by path {1} from {2}", new Object[]{aStartProject, path, curFile});
                            directive.setAnnotation((Object)new ClankToCsmSupport.UnresolvedIncludeDirectiveAnnotation(ClankToCsmSupport.UnresolvedIncludeDirectiveReason.START_PROJECT_CANNOT_CREATE_FILE, aStartProject, resolvedPath, curFile));
                        }
                    } else {
                        directive.setAnnotation((Object)includedFile);
                    }
                } else {
                    APTUtils.LOG.log(Level.INFO, "invalid start project {0} or file when including {1} from {2}", new Object[]{aStartProject, path, curFile});
                    directive.setAnnotation((Object)new ClankToCsmSupport.UnresolvedIncludeDirectiveAnnotation(ClankToCsmSupport.UnresolvedIncludeDirectiveReason.INVALID_START_PROJECT, aStartProject, resolvedPath, curFile));
                }
            } else {
                APTUtils.LOG.log(Level.SEVERE, "FileTokenStreamCallback: file {0} without project!!!", new Object[]{path});
                directive.setAnnotation((Object)new ClankToCsmSupport.UnresolvedIncludeDirectiveAnnotation(ClankToCsmSupport.UnresolvedIncludeDirectiveReason.NULL_START_PROJECT, resolvedPath, curFile));
            }
        }

        @Override
        protected boolean pushEnteredFile(ClankDriver.ClankFileInfo enteredFrom, ClankDriver.ClankFileInfo enteredTo) {
            FileImpl enteredToFileImpl;
            assert (enteredTo != null);
            ClankDriver.ClankInclusionDirective enteredAsInclusion = enteredTo.getInclusionDirective();
            assert (enteredFrom == null == (enteredAsInclusion == null)) : "inclusion directive is null if and only if entering main file " + enteredFrom + " vs. " + enteredAsInclusion;
            if (enteredFrom == null) {
                enteredToFileImpl = this.startFile;
            } else {
                Object inclusionAnnotation = enteredAsInclusion.getAnnotation();
                if (inclusionAnnotation instanceof FileImpl) {
                    enteredToFileImpl = (FileImpl)inclusionAnnotation;
                } else {
                    APTUtils.LOG.log(Level.INFO, inclusionAnnotation.toString());
                    return false;
                }
            }
            if (CndUtils.isDebugMode()) {
                boolean anAssert;
                boolean bl = anAssert = !this.isInsideInterestedFile() || this.interestedFile.equals(enteredToFileImpl);
                if (!anAssert) {
                    CndUtils.assertTrueInConsole((boolean)anAssert, (String)("" + this.isInsideInterestedFile() + ": inconsistency between " + this.interestedFile + " and "), (Object)enteredToFileImpl);
                }
                CndUtils.assertPathsEqualInConsole((CharSequence)enteredToFileImpl.getAbsolutePath(), (CharSequence)enteredTo.getFilePath(), (String)"Expected {0}\n got {1}", (Object[])new Object[]{enteredToFileImpl, enteredTo});
            }
            this.pushCurrentFile(enteredToFileImpl);
            return true;
        }

        @Override
        protected boolean popExitedFile(ClankDriver.ClankFileInfo exitedFrom, ClankDriver.ClankFileInfo exitedTo, VisitIncludeChainPreprocessorCallback.State state, boolean exitingFromInterestedFile) {
            CharSequence exitedFromFileInfoPath;
            assert (exitedFrom != null);
            FileImpl exitedFromFileImpl = this.getCurFile(true);
            assert (exitedFromFileImpl != null);
            ClankDriver.ClankInclusionDirective exitedInclusion = exitedFrom.getInclusionDirective();
            assert (exitedInclusion == null == (exitedTo == null)) : "inclusion directive is null if and only if exiting main file " + exitedTo + " vs. " + exitedInclusion;
            if (state == VisitIncludeChainPreprocessorCallback.State.CORRUPTED_INCLUDE_CHAIN) {
                return false;
            }
            CharSequence exitedFromFileImplPath = exitedFromFileImpl.getAbsolutePath();
            if (!CharSequenceUtils.contentEquals((CharSequence)exitedFromFileImplPath, (CharSequence)(exitedFromFileInfoPath = exitedFrom.getFilePath()))) {
                CndUtils.assertPathsEqualInConsole((CharSequence)exitedFromFileImplPath, (CharSequence)exitedFromFileInfoPath, (String)"Expected Exit From {0}\n got {1}", (Object[])new Object[]{exitedFromFileImpl, exitedFrom});
                return false;
            }
            if (CndUtils.isDebugMode()) {
                if (exitedTo != null) {
                    if (this.curFiles.size() > 0) {
                        FileImpl exitedToFileImpl = this.getCurFile(false);
                        CndUtils.assertPathsEqualInConsole((CharSequence)exitedToFileImpl.getAbsolutePath(), (CharSequence)exitedTo.getFilePath(), (String)"Expected Exit To {0}\n got {1}", (Object[])new Object[]{exitedToFileImpl, exitedTo});
                    } else {
                        CndUtils.assertTrueInConsole((boolean)false, (String)"no more files in stack for ", (Object)exitedTo);
                    }
                } else assert (exitedFromFileImpl == this.startFile) : "exited from " + exitedFromFileImpl + "\nexpected " + this.startFile;
                if (exitingFromInterestedFile) {
                    CndUtils.assertPathsEqualInConsole((CharSequence)exitedFromFileInfoPath, (CharSequence)this.interestedFile.getAbsolutePath(), (String)"Expected {0}\n got {1}", (Object[])new Object[]{this.interestedFile, exitedFrom});
                    assert (state == VisitIncludeChainPreprocessorCallback.State.DONE) : "expected DONE instead of " + (Object)((Object)state) + " for " + this.interestedFile;
                }
            }
            if (exitedInclusion != null) {
                if (state == VisitIncludeChainPreprocessorCallback.State.DONE && !exitingFromInterestedFile) {
                    return true;
                }
                return this.postIncludeAction(exitedFromFileImpl, exitedFrom);
            }
            return true;
        }

        protected boolean postIncludeAction(FileImpl exitedFromFileImpl, ClankDriver.ClankFileInfo exitedFrom) {
            if (this.parameters.triggerParsingActivity) {
                try {
                    assert (ClankDriver.extractPreprocessorOutput((PreprocHandler)this.ppHandler).hasTokenStream());
                    PreprocHandler.State inclState = this.ppHandler.getState();
                    assert (!inclState.isCleaned());
                    CharSequence inclPath = exitedFrom.getFilePath();
                    ProjectBase inclFileOwnerProject = exitedFromFileImpl.getProjectImpl(true);
                    ProjectBase aStartProject = this.startProject;
                    if (inclFileOwnerProject.isDisposing() || aStartProject.isDisposing()) {
                        if (TraceFlags.TRACE_VALIDATION || TraceFlags.TRACE_MODEL_STATE) {
                            System.err.printf("onFileIncluded: %s file [%s] is interrupted on disposing project%n", inclPath, inclFileOwnerProject.getName());
                        }
                        return false;
                    }
                    FilePreprocessorConditionState pcState = FilePreprocessorConditionState.build(inclPath, exitedFrom.getSkippedRanges());
                    PreprocessorStatePair ppStatePair = new PreprocessorStatePair(inclState, pcState);
                    inclFileOwnerProject.postIncludeFile(aStartProject, exitedFromFileImpl, inclPath, ppStatePair, null);
                }
                catch (Exception ex) {
                    APTUtils.LOG.log(Level.SEVERE, "MyClankPreprocessorCallback: error on including {0}:%n{1}", new Object[]{exitedFrom.getFilePath(), ex});
                    DiagnosticExceptoins.register(ex);
                    return false;
                }
            }
            return true;
        }
    }

    private static class VisitIncludeChainPreprocessorCallback
    implements ClankDriver.ClankPreprocessorCallback {
        protected final ClankTokenStreamProducerParameters parameters;
        private final LinkedList<PPIncludeHandler.IncludeInfo> remainingChainToInterestedFile;
        private PPIncludeHandler.IncludeInfo seekEnterToThisIncludeInfo;
        private ClankDriver.ClankFileInfo waitExitFromThisFileInfo = null;
        private ClankDriver.ClankFileInfo seenInterestedFileInfo = null;
        private ClankDriver.ClankPreprocessorOutput preparedPreprocessorOutput = null;
        private boolean insideInterestedFile = false;
        private State state;

        private VisitIncludeChainPreprocessorCallback(LinkedList<PPIncludeHandler.IncludeInfo> includeChain, ClankTokenStreamProducerParameters params) {
            this.remainingChainToInterestedFile = includeChain;
            this.state = State.WAIT_COMPILATION_UNIT_FILE;
            this.parameters = params;
        }

        private boolean valueOf(int param) {
            switch (param) {
                case 0: {
                    return true;
                }
                case 1: {
                    return false;
                }
                case 2: {
                    return this.insideInterestedFile;
                }
            }
            throw new AssertionError((Object)("unknown" + param));
        }

        public boolean isCorruptedIncludeChain() {
            return this.state == State.CORRUPTED_INCLUDE_CHAIN;
        }

        public boolean needPPDirectives() {
            return this.valueOf(this.parameters.needPPDirectives);
        }

        public boolean needTokens() {
            return this.valueOf(this.parameters.needTokens);
        }

        public boolean needSkippedRanges() {
            return this.valueOf(this.parameters.needSkippedRanges);
        }

        public boolean needMacroExpansion() {
            return this.valueOf(this.parameters.needMacroExpansion);
        }

        public boolean needComments() {
            return this.valueOf(this.parameters.needComments);
        }

        protected final boolean isInsideInterestedFile() {
            return this.insideInterestedFile;
        }

        protected boolean pushEnteredFile(ClankDriver.ClankFileInfo enteredFrom, ClankDriver.ClankFileInfo enteredTo) {
            return true;
        }

        protected boolean popExitedFile(ClankDriver.ClankFileInfo exitedFrom, ClankDriver.ClankFileInfo exitedTo, State state, boolean exitingFromInterestedFile) {
            return true;
        }

        protected void include(ClankDriver.ClankInclusionDirective directive) {
        }

        public final void onInclusionDirective(ClankDriver.ClankFileInfo directiveOwner, ClankDriver.ClankInclusionDirective directive) {
            switch (this.state) {
                case WAIT_EXIT_FROM_FILE: 
                case SEEK_ENTER_TO_INCLUDED_FILE: 
                case INSIDE_INITERESTED_FILE: {
                    this.include(directive);
                    break;
                }
                case WAIT_COMPILATION_UNIT_FILE: {
                    assert (false);
                    break;
                }
                case CORRUPTED_INCLUDE_CHAIN: 
                case DONE: {
                    return;
                }
                default: {
                    throw new AssertionError((Object)this.state.name());
                }
            }
        }

        public final boolean onEnter(ClankDriver.ClankFileInfo enteredFrom, ClankDriver.ClankFileInfo enteredTo) {
            boolean continuePreprocessing;
            assert (enteredTo != null);
            this.insideInterestedFile = false;
            assert (this.state != null) : "null state when enter from\n" + enteredFrom + "\nTo\n" + enteredTo;
            switch (this.state) {
                case CORRUPTED_INCLUDE_CHAIN: {
                    continuePreprocessing = false;
                    break;
                }
                case DONE: {
                    continuePreprocessing = false;
                    break;
                }
                case WAIT_COMPILATION_UNIT_FILE: {
                    assert (enteredFrom == null) : "expected null instead of " + enteredFrom;
                    assert (this.waitExitFromThisFileInfo == null) : "expected null instead of " + this.waitExitFromThisFileInfo;
                    if (this.remainingChainToInterestedFile.isEmpty()) {
                        this.state = State.INSIDE_INITERESTED_FILE;
                        this.seenInterestedFileInfo = enteredTo;
                        this.insideInterestedFile = true;
                    } else {
                        this.seekEnterToThisIncludeInfo = this.remainingChainToInterestedFile.removeFirst();
                        assert (this.seekEnterToThisIncludeInfo != null);
                        this.state = State.SEEK_ENTER_TO_INCLUDED_FILE;
                    }
                    continuePreprocessing = true;
                    break;
                }
                case INSIDE_INITERESTED_FILE: {
                    assert (this.remainingChainToInterestedFile.isEmpty()) : "we are inside interested file only when walked whole chain: " + this.remainingChainToInterestedFile;
                    assert (this.waitExitFromThisFileInfo == null) : "expected null instead of " + this.waitExitFromThisFileInfo;
                    this.waitExitFromThisFileInfo = enteredTo;
                    this.state = State.WAIT_EXIT_FROM_FILE;
                    continuePreprocessing = true;
                    break;
                }
                case WAIT_EXIT_FROM_FILE: {
                    assert (this.waitExitFromThisFileInfo != null);
                    assert (this.waitExitFromThisFileInfo != enteredTo) : "unexpected to enter into file " + enteredTo + " which we wait to exit from";
                    continuePreprocessing = true;
                    break;
                }
                case SEEK_ENTER_TO_INCLUDED_FILE: {
                    assert (this.seekEnterToThisIncludeInfo != null);
                    assert (this.waitExitFromThisFileInfo == null) : "expected null instead of " + this.waitExitFromThisFileInfo;
                    assert (enteredFrom != null);
                    ClankDriver.ClankInclusionDirective inclDirective = enteredTo.getInclusionDirective();
                    assert (inclDirective != null) : "main file is the only one without include directive, but had to be handled above " + enteredTo;
                    int includeDirectiveIndex = inclDirective.getIncludeDirectiveIndex();
                    if (includeDirectiveIndex == this.seekEnterToThisIncludeInfo.getIncludeDirectiveIndex()) {
                        if (CharSequenceUtils.contentEquals((CharSequence)this.seekEnterToThisIncludeInfo.getIncludedPath(), (CharSequence)enteredTo.getFilePath())) {
                            if (this.remainingChainToInterestedFile.isEmpty()) {
                                assert (this.seenInterestedFileInfo == null) : "can not enter twice " + this.seenInterestedFileInfo;
                                this.state = State.INSIDE_INITERESTED_FILE;
                                this.seenInterestedFileInfo = enteredTo;
                                this.insideInterestedFile = true;
                            } else {
                                this.seekEnterToThisIncludeInfo = this.remainingChainToInterestedFile.removeFirst();
                                assert (this.seekEnterToThisIncludeInfo != null);
                                this.state = State.SEEK_ENTER_TO_INCLUDED_FILE;
                            }
                            continuePreprocessing = true;
                            break;
                        }
                        this.state = State.CORRUPTED_INCLUDE_CHAIN;
                        assert (this.preparedPreprocessorOutput == null);
                        continuePreprocessing = false;
                        break;
                    }
                    if (includeDirectiveIndex > this.seekEnterToThisIncludeInfo.getIncludeDirectiveIndex()) {
                        this.state = State.CORRUPTED_INCLUDE_CHAIN;
                        assert (this.preparedPreprocessorOutput == null);
                        continuePreprocessing = false;
                        break;
                    }
                    assert (includeDirectiveIndex < this.seekEnterToThisIncludeInfo.getIncludeDirectiveIndex()) : "why hasn't stopped after interested file? " + this.seekEnterToThisIncludeInfo;
                    assert (this.waitExitFromThisFileInfo == null) : "expected null instead of " + this.waitExitFromThisFileInfo;
                    this.waitExitFromThisFileInfo = enteredTo;
                    this.state = State.WAIT_EXIT_FROM_FILE;
                    continuePreprocessing = true;
                    break;
                }
                default: {
                    assert (false) : "unexpected state = " + (Object)((Object)this.state);
                    this.state = State.CORRUPTED_INCLUDE_CHAIN;
                    continuePreprocessing = false;
                }
            }
            if (!this.pushEnteredFile(enteredFrom, enteredTo)) {
                this.state = State.CORRUPTED_INCLUDE_CHAIN;
                this.insideInterestedFile = false;
                this.preparedPreprocessorOutput = null;
                continuePreprocessing = false;
            }
            return continuePreprocessing;
        }

        public final boolean onExit(ClankDriver.ClankFileInfo exitedFrom, ClankDriver.ClankFileInfo exitedTo) {
            boolean continuePreprocessing;
            assert (this.state != State.WAIT_COMPILATION_UNIT_FILE) : "can not exit before entering compilation unit file ";
            boolean exitingFromInterestedFile = this.insideInterestedFile;
            this.insideInterestedFile = false;
            if (this.preparedPreprocessorOutput != null) {
                assert (this.state == State.DONE);
                continuePreprocessing = false;
            } else if (this.state == State.CORRUPTED_INCLUDE_CHAIN) {
                assert (this.preparedPreprocessorOutput == null);
                continuePreprocessing = false;
            } else {
                assert (exitedFrom != null);
                assert (this.seenInterestedFileInfo != null || this.waitExitFromThisFileInfo != null || this.state == State.SEEK_ENTER_TO_INCLUDED_FILE) : "in state " + (Object)((Object)this.state) + " we exit from enexpected include branch ? " + exitedFrom + "\nback to\n" + exitedTo;
                if (exitedFrom == this.seenInterestedFileInfo) {
                    assert (this.waitExitFromThisFileInfo == null);
                    this.preparedPreprocessorOutput = ClankDriver.extractPreparedPreprocessorOutput((ClankDriver.ClankFileInfo)exitedFrom);
                    assert (this.preparedPreprocessorOutput != null);
                    this.state = State.DONE;
                    assert (exitingFromInterestedFile);
                    continuePreprocessing = false;
                } else if (exitedFrom == this.waitExitFromThisFileInfo) {
                    assert (this.state == State.WAIT_EXIT_FROM_FILE);
                    this.waitExitFromThisFileInfo = null;
                    if (this.seenInterestedFileInfo == null) {
                        this.state = State.SEEK_ENTER_TO_INCLUDED_FILE;
                    } else {
                        assert (this.seenInterestedFileInfo != null);
                        assert (exitedTo == this.seenInterestedFileInfo) : "unexpected to exit back to file " + exitedTo + "\nwhen we wait to exit into " + this.seenInterestedFileInfo;
                        assert (this.remainingChainToInterestedFile.isEmpty()) : "we are inside interested file only when walked whole chain: " + this.remainingChainToInterestedFile;
                        this.state = State.INSIDE_INITERESTED_FILE;
                        this.insideInterestedFile = true;
                    }
                    continuePreprocessing = true;
                } else if (this.state == State.SEEK_ENTER_TO_INCLUDED_FILE) {
                    this.state = State.CORRUPTED_INCLUDE_CHAIN;
                    continuePreprocessing = false;
                } else {
                    continuePreprocessing = true;
                }
            }
            if (!this.popExitedFile(exitedFrom, exitedTo, this.state, exitingFromInterestedFile)) {
                this.state = State.CORRUPTED_INCLUDE_CHAIN;
                this.insideInterestedFile = false;
                this.preparedPreprocessorOutput = null;
                continuePreprocessing = false;
            }
            return continuePreprocessing;
        }

        public ClankDriver.ClankPreprocessorOutput getPreparedPreprocessorOutput() {
            return this.preparedPreprocessorOutput;
        }

        protected static enum State {
            WAIT_COMPILATION_UNIT_FILE,
            WAIT_EXIT_FROM_FILE,
            SEEK_ENTER_TO_INCLUDED_FILE,
            INSIDE_INITERESTED_FILE,
            CORRUPTED_INCLUDE_CHAIN,
            DONE;

        }
    }
}

