/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.config.annotation;

import java.util.ArrayList;
import java.util.List;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;

public class ResourceHandlerRegistration {
    private final ResourceLoader resourceLoader;
    private final String[] pathPatterns;
    private final List<Resource> locations = new ArrayList<Resource>();
    private Integer cachePeriod;

    public ResourceHandlerRegistration(ResourceLoader resourceLoader, String ... pathPatterns) {
        Assert.notEmpty((Object[])pathPatterns, (String)"At least one path pattern is required for resource handling.");
        this.resourceLoader = resourceLoader;
        this.pathPatterns = pathPatterns;
    }

    public ResourceHandlerRegistration addResourceLocations(String ... resourceLocations) {
        for (String location : resourceLocations) {
            this.locations.add(this.resourceLoader.getResource(location));
        }
        return this;
    }

    public ResourceHandlerRegistration setCachePeriod(Integer cachePeriod) {
        this.cachePeriod = cachePeriod;
        return this;
    }

    protected String[] getPathPatterns() {
        return this.pathPatterns;
    }

    protected ResourceHttpRequestHandler getRequestHandler() {
        Assert.isTrue((!CollectionUtils.isEmpty(this.locations) ? 1 : 0) != 0, (String)"At least one location is required for resource handling.");
        ResourceHttpRequestHandler requestHandler = new ResourceHttpRequestHandler();
        requestHandler.setLocations(this.locations);
        if (this.cachePeriod != null) {
            requestHandler.setCacheSeconds(this.cachePeriod);
        }
        return requestHandler;
    }
}

