/*
 * Decompiled with CFR 0.152.
 */
package org.clang.frontend.impl;

import org.clang.basic.DirectoryEntry;
import org.clang.basic.SrcMgr;
import org.clang.lex.DirectoryLookup;
import org.clang.lex.HeaderMap;
import org.clank.java.std;
import org.clank.support.NativePointer;
import org.llvm.adt.SmallPtrSet;
import org.llvm.adt.StringRef;
import org.llvm.support.llvm;
import org.llvm.support.sys.path;

public final class InitHeaderSearchStatics {
    public static boolean CanPrefixSysroot(StringRef Path) {
        return path.is_absolute((StringRef)Path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int RemoveDuplicates(std.vector<DirectoryLookup> SearchList, int First, boolean Verbose) {
        SmallPtrSet SeenDirs = null;
        SmallPtrSet SeenFrameworkDirs = null;
        SmallPtrSet SeenHeaderMaps = null;
        try {
            SeenDirs = new SmallPtrSet(DirectoryEntry.DenseMapInfo, 8);
            SeenFrameworkDirs = new SmallPtrSet(DirectoryEntry.DenseMapInfo, 8);
            SeenHeaderMaps = new SmallPtrSet(HeaderMap.DenseMapInfo, 8);
            int NonSystemRemoved = 0;
            for (int i = First; i != SearchList.size(); ++i) {
                int DirToRemove = i;
                DirectoryLookup CurEntry = (DirectoryLookup)SearchList.$at(i);
                if (CurEntry.isNormalDir()) {
                    if (SeenDirs.insert((Object)CurEntry.getDir()).second) {
                        continue;
                    }
                } else if (CurEntry.isFramework()) {
                    if (SeenFrameworkDirs.insert((Object)CurEntry.getFrameworkDir()).second) {
                        continue;
                    }
                } else {
                    assert (CurEntry.isHeaderMap()) : "Not a headermap or normal dir?";
                    if (SeenHeaderMaps.insert((Object)CurEntry.getHeaderMap()).second) continue;
                }
                if (CurEntry.getDirCharacteristic() != SrcMgr.CharacteristicKind.C_User) {
                    int FirstDir = 0;
                    while (true) {
                        assert (FirstDir != i) : "Didn't find dupe?";
                        DirectoryLookup SearchEntry = (DirectoryLookup)SearchList.$at(FirstDir);
                        if (SearchEntry.getLookupType() == CurEntry.getLookupType()) {
                            boolean isSame;
                            if (CurEntry.isNormalDir()) {
                                isSame = SearchEntry.getDir() == CurEntry.getDir();
                            } else if (CurEntry.isFramework()) {
                                isSame = SearchEntry.getFrameworkDir() == CurEntry.getFrameworkDir();
                            } else {
                                assert (CurEntry.isHeaderMap()) : "Not a headermap or normal dir?";
                                boolean bl = isSame = SearchEntry.getHeaderMap() == CurEntry.getHeaderMap();
                            }
                            if (isSame) break;
                        }
                        ++FirstDir;
                    }
                    if (((DirectoryLookup)SearchList.$at(FirstDir)).getDirCharacteristic() == SrcMgr.CharacteristicKind.C_User) {
                        DirToRemove = FirstDir;
                    }
                }
                if (Verbose) {
                    llvm.errs().$out(NativePointer.$((String)"ignoring duplicate directory \"")).$out(CurEntry.getName()).$out(NativePointer.$QUOTE_LF);
                    if (DirToRemove != i) {
                        llvm.errs().$out(NativePointer.$((String)"  as it is a non-system directory that duplicates ")).$out(NativePointer.$((String)"a system directory\n"));
                    }
                }
                if (DirToRemove != i) {
                    ++NonSystemRemoved;
                }
                SearchList.erase(SearchList.begin().$add(DirToRemove));
                --i;
            }
            int n = NonSystemRemoved;
            return n;
        }
        finally {
            if (SeenHeaderMaps != null) {
                SeenHeaderMaps.$destroy();
            }
            if (SeenFrameworkDirs != null) {
                SeenFrameworkDirs.$destroy();
            }
            if (SeenDirs != null) {
                SeenDirs.$destroy();
            }
        }
    }
}

