/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.simpleunit.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.builds.MakefileTargetProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class MakefileUtils {
    private MakefileUtils() {
    }

    public static FileObject getMakefile(Project project) {
        MakeConfigurationDescriptor makeConfDescriptor;
        ConfigurationDescriptorProvider confDescriptorProvider = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        if (confDescriptorProvider != null && (makeConfDescriptor = confDescriptorProvider.getConfigurationDescriptor()) != null && !makeConfDescriptor.getProjectMakefileName().isEmpty()) {
            return project.getProjectDirectory().getFileObject(makeConfDescriptor.getProjectMakefileName());
        }
        return null;
    }

    public static boolean hasTestTargets(Project project) {
        FileObject makefile = MakefileUtils.getMakefile(project);
        if (makefile != null && makefile.isValid()) {
            try {
                DataObject dataObject = DataObject.find((FileObject)makefile);
                MakefileTargetProvider targetProvider = (MakefileTargetProvider)dataObject.getLookup().lookup(MakefileTargetProvider.class);
                if (targetProvider != null) {
                    Set targets = targetProvider.getRunnableTargets();
                    return targets.contains("test") || targets.contains("build-tests");
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createTestTargets(Project project) {
        if (MakefileUtils.hasTestTargets(project)) {
            return;
        }
        FileObject makefile = MakefileUtils.getMakefile(project);
        try {
            StringBuilder makefiledata = new StringBuilder(makefile.asText());
            makefiledata.append("\n\n").append("# build tests\n").append("build-tests: .build-tests-post\n").append("\n").append(".build-tests-pre:\n").append("# Add your pre 'build-tests' code here...\n").append("\n").append(".build-tests-post: .build-tests-impl\n").append("# Add your post 'build-tests' code here...\n").append("\n").append("\n").append("# run tests\n").append("test: .test-post\n").append("\n").append(".test-pre:\n").append("# Add your pre 'test' code here...\n").append("\n").append(".test-post: .test-impl\n").append("# Add your post 'test' code here...\n");
            OutputStream outputStream = makefile.getOutputStream();
            try {
                outputStream.write(makefiledata.toString().getBytes());
            }
            finally {
                outputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

