/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.junit;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.netbeans.junit.Manager;
import org.netbeans.junit.MemoryMeasurementFailedException;

public class MemoryMeasurement {
    public static final String IDE_PID_SYSTEM_PROPERTY = "netbeans.pid";
    private static final long UNKNOWN_VALUE = -1L;
    private static final String SOLARIS = "solaris";
    private static final String LINUX = "linux";
    private static final String WINDOWS = "win32";
    private static final String UNKNOWN = "unknown";
    private static final String[][] SUPPORTED_PLATFORMS = new String[][]{{"SunOS", "solaris"}, {"Linux", "linux"}, {"Windows NT", "win32"}, {"Windows 2000", "win32"}, {"Windows XP", "win32"}};
    private static boolean libraryLoaded = false;

    private MemoryMeasurement() {
    }

    public static long getIdeMemoryFootPrint() throws MemoryMeasurementFailedException {
        String idePidString = System.getProperty(IDE_PID_SYSTEM_PROPERTY);
        if (idePidString != null) {
            try {
                long idePid = Long.parseLong(idePidString);
                return MemoryMeasurement.getProcessMemoryFootPrint(idePid);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new MemoryMeasurementFailedException("Cannot get IDE PID - obtained value: " + idePidString);
    }

    public static long getProcessMemoryFootPrint(long pid) throws MemoryMeasurementFailedException {
        String platform = MemoryMeasurement.getPlatform();
        if (platform.equals(SOLARIS) | platform.equals(LINUX)) {
            return MemoryMeasurement.getProcessMemoryFootPrintOnUnix(pid);
        }
        if (platform.equals(WINDOWS)) {
            return MemoryMeasurement.getProcessMemoryFootPrintOnWindows(pid);
        }
        throw new MemoryMeasurementFailedException("Cannot measure memory on unsupported platform " + platform);
    }

    private static String getPlatform() throws MemoryMeasurementFailedException {
        String osName = System.getProperty("os.name");
        for (int i = 0; i < SUPPORTED_PLATFORMS.length; ++i) {
            if (!SUPPORTED_PLATFORMS[i][0].equalsIgnoreCase(osName)) continue;
            return SUPPORTED_PLATFORMS[i][1];
        }
        throw new MemoryMeasurementFailedException("MemoryMeasurement does not support this operating system: " + osName);
    }

    private static long getProcessMemoryFootPrintOnUnix(long pid) throws MemoryMeasurementFailedException {
        try {
            File script = new File(Manager.getNbJUnitHome(), "memory-measurement.unix.sh");
            if (!script.exists()) {
                throw new MemoryMeasurementFailedException("Cannot locate script '" + script.getName() + "', please make sure it is available in nbjunit.home");
            }
            String command = "/bin/sh " + script.getAbsolutePath() + " " + pid;
            Process process = Runtime.getRuntime().exec(command);
            long obtainedValue = MemoryMeasurement.getOutputValue(process);
            process.waitFor();
            if (obtainedValue == -1L) {
                throw new MemoryMeasurementFailedException("Memory measurement call failed " + obtainedValue);
            }
            return obtainedValue;
        }
        catch (IOException ioe) {
            throw new MemoryMeasurementFailedException("MemoryMeasurement failed, reason:" + ioe.getMessage(), ioe);
        }
        catch (InterruptedException ie) {
            throw new MemoryMeasurementFailedException("MemoryMeasurement failed, reason:" + ie.getMessage(), ie);
        }
    }

    private static long getProcessMemoryFootPrintOnWindows(long pid) throws MemoryMeasurementFailedException {
        MemoryMeasurement.loadMemoryMeasurementLibrary();
        long value = MemoryMeasurement.getProcessMemoryFootPrintNative(pid);
        if (value == -1L) {
            throw new MemoryMeasurementFailedException("Memory measurement call to native library failed - could not measure memory of process with pid " + pid + ".");
        }
        return value;
    }

    private static native long getProcessMemoryFootPrintNative(long var0);

    private static long getOutputValue(Process process) throws IOException {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String outputString = br.readLine();
            try {
                long l = Long.parseLong(outputString);
                return l;
            }
            catch (NumberFormatException nfe) {
                throw new IOException("Received String is not a number: " + outputString);
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }

    private static void loadMemoryMeasurementLibrary() throws MemoryMeasurementFailedException {
        if (!libraryLoaded) {
            try {
                File dllLibrary = new File(Manager.getNbJUnitHome(), "lib.memory-measurement.win32.dll");
                System.load(dllLibrary.getAbsolutePath());
                libraryLoaded = true;
            }
            catch (IOException ioe) {
                throw new MemoryMeasurementFailedException("Cannot load native memory measurement library lib.memory-measurement.win32.dll, reason: " + ioe.getMessage(), ioe);
            }
            catch (UnsatisfiedLinkError ule) {
                throw new MemoryMeasurementFailedException("Cannot load native memory measurement library lib.memory-measurement.win32.dll, reason: " + ule.getMessage(), ule);
            }
        }
    }
}

