/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.converters;

import com.sun.javacard.classfile.instructions.JInstrByteIndex;
import com.sun.javacard.converter.ConversionException;
import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.converter.converters.I2SException;
import com.sun.javacard.converter.converters.InstrContainer;
import com.sun.javacard.converter.converters.InstructionConverter;
import com.sun.javacard.converter.converters.MethodConverter;
import com.sun.javacard.converter.converters.OperandStack;
import com.sun.javacard.converter.converters.OperandStackEntry;
import com.sun.javacard.converter.converters.RecalculateIndexException;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.jcfile.JcLocalVariable;
import com.sun.javacard.jcfile.instructions.JcInstrByteIndex;
import com.sun.javacard.jcfile.instructions.JcInstrNoOperands;
import com.sun.javacard.jcfile.instructions.JcInstruction;

class InstrStoreConverter
extends InstructionConverter {
    public InstrStoreConverter(InstrContainer instrContainer, MethodConverter methodConverter) {
        super(instrContainer, methodConverter);
    }

    @Override
    public JcInstruction convert() throws Exception {
        int n;
        int n2 = this.java_instr.getOpcode();
        switch (n2) {
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                n = n2 - 59;
                break;
            }
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                n = n2 - 75;
                break;
            }
            case 54: {
                n = ((JInstrByteIndex)this.java_instr).getIndex();
                break;
            }
            case 58: {
                n = ((JInstrByteIndex)this.java_instr).getIndex();
                break;
            }
            default: {
                throw new ConverterInternalError();
            }
        }
        JcLocalVariable jcLocalVariable = this.method_converter.getLocalVariableConverter().getJcLocalVariable(n, this.java_instr);
        if (jcLocalVariable == null) {
            throw new ConverterInternalError();
        }
        try {
            this.createStoreInstruction(jcLocalVariable, this.operand_stack, n);
            this.operand_stack.pop();
        }
        catch (I2SException i2SException) {
            this.operand_stack.pop();
            throw i2SException;
        }
        return this.jc_instr;
    }

    private void createStoreInstruction(JcLocalVariable jcLocalVariable, OperandStack operandStack, int n) throws Exception {
        OperandStackEntry operandStackEntry = operandStack.peek(1);
        int n2 = operandStackEntry.getType();
        int n3 = jcLocalVariable.getType();
        if (n2 != 3 || n3 == 2) {
            // empty if block
        }
        if (!(this.method_converter.getLocalVariableConverter().getDefinedLocalVariablesSize() != 0 || !operandStackEntry.isTypeKnown() || jcLocalVariable.isVarTypeKnown() || jcLocalVariable.isPromoted() || n2 != 1 && n2 != 2 || n3 != 3)) {
            this.method_converter.getLocalVariableConverter().updateJcLocalVariable(n, "S");
            n3 = jcLocalVariable.getType();
        }
        if (this.method_converter.getLocalVariableConverter().getDefinedLocalVariablesSize() == 0 && !jcLocalVariable.isVarTypeKnown() && !jcLocalVariable.isPromoted() && n2 == 3 && n3 != 3) {
            this.method_converter.getLocalVariableConverter().updateJcLocalVariable(n, "I");
            jcLocalVariable.setPromoted(true);
            throw new RecalculateIndexException(n);
        }
        int n4 = jcLocalVariable.getJcIndex();
        switch (n3) {
            case 1: 
            case 2: {
                if (n2 != 3) {
                    this.jc_instr = n4 < 4 ? new JcInstrNoOperands(47 + n4) : new JcInstrByteIndex(41, n4);
                    return;
                }
                this.jc_instr = n4 < 4 ? new JcInstrNoOperands(47 + n4) : new JcInstrByteIndex(41, n4);
                throw new I2SException(this.jc_instr);
            }
            case 3: {
                if (!this.method_converter.isIntSupported()) {
                    Notifier.error(this.java_instr.getSourceLineNumber(), "int.5", this.method_converter.getClassName().replace('/', '.'));
                    throw new ConversionException();
                }
                Notifier.progress(this.java_instr.getSourceLineNumber(), "warning.5", this.method_converter.getClassName().replace('/', '.'));
                this.method_converter.getPackageConverter().setIntFlag(true);
                if (n2 != 3) {
                    operandStackEntry.rollBack();
                }
                this.jc_instr = n4 < 4 ? new JcInstrNoOperands(51 + n4) : new JcInstrByteIndex(42, n4);
                return;
            }
            case 10: {
                this.jc_instr = n4 < 4 ? new JcInstrNoOperands(43 + n4) : new JcInstrByteIndex(40, n4);
                return;
            }
        }
        throw new ConverterInternalError();
    }
}

