/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.Type;

class TypeBase
extends Type {
    int kind;
    static final int VOID = 1;
    static final int BOOLEAN = 2;
    static final int BYTE = 3;
    static final int SHORT = 4;
    static final int INT = 5;
    static final int INT2 = 6;

    TypeBase(int n) {
        this.kind = n;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof TypeBase && ((TypeBase)object).kind == this.kind;
    }

    @Override
    boolean isSubtype(Type type) {
        return type instanceof TypeBase && ((TypeBase)type).kind == this.kind;
    }

    @Override
    Type lub(Type type) {
        if (type instanceof TypeBase && ((TypeBase)type).kind == this.kind) {
            return this;
        }
        return null;
    }

    public int hashCode() {
        return this.kind;
    }

    @Override
    int wordSize() {
        return this.kind == 5 ? 2 : 1;
    }

    @Override
    Type normalize() {
        switch (this.kind) {
            case 2: 
            case 3: {
                TypeBase typeBase = new TypeBase(4);
                typeBase.beforeNormalization = this;
                return typeBase;
            }
        }
        return this;
    }

    @Override
    String toStringAux() {
        switch (this.kind) {
            case 1: {
                return "void";
            }
            case 2: {
                return "boolean";
            }
            case 3: {
                return "byte";
            }
            case 4: {
                return "short";
            }
            case 5: {
                return "int";
            }
            case 6: {
                return "int";
            }
        }
        return "<??" + this.kind + "??>";
    }
}

