/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.persistence.jpa.jpql.parser.AbsExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractDoubleEncapsulatedExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSchemaName;
import org.eclipse.persistence.jpa.jpql.parser.AbstractTraverseParentVisitor;
import org.eclipse.persistence.jpa.jpql.parser.AdditionExpression;
import org.eclipse.persistence.jpa.jpql.parser.AllOrAnyExpression;
import org.eclipse.persistence.jpa.jpql.parser.AndExpression;
import org.eclipse.persistence.jpa.jpql.parser.ArithmeticFactor;
import org.eclipse.persistence.jpa.jpql.parser.AvgFunction;
import org.eclipse.persistence.jpa.jpql.parser.BetweenExpression;
import org.eclipse.persistence.jpa.jpql.parser.CaseExpression;
import org.eclipse.persistence.jpa.jpql.parser.CoalesceExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionMemberExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionValuedPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.ComparisonExpression;
import org.eclipse.persistence.jpa.jpql.parser.CompoundExpression;
import org.eclipse.persistence.jpa.jpql.parser.ConcatExpression;
import org.eclipse.persistence.jpa.jpql.parser.ConstructorExpression;
import org.eclipse.persistence.jpa.jpql.parser.CountFunction;
import org.eclipse.persistence.jpa.jpql.parser.DateTime;
import org.eclipse.persistence.jpa.jpql.parser.DivisionExpression;
import org.eclipse.persistence.jpa.jpql.parser.EmptyCollectionComparisonExpression;
import org.eclipse.persistence.jpa.jpql.parser.EntityTypeLiteral;
import org.eclipse.persistence.jpa.jpql.parser.EntryExpression;
import org.eclipse.persistence.jpa.jpql.parser.ExistsExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.FunctionExpression;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.jpql.parser.InExpression;
import org.eclipse.persistence.jpa.jpql.parser.IndexExpression;
import org.eclipse.persistence.jpa.jpql.parser.InputParameter;
import org.eclipse.persistence.jpa.jpql.parser.KeyExpression;
import org.eclipse.persistence.jpa.jpql.parser.KeywordExpression;
import org.eclipse.persistence.jpa.jpql.parser.LengthExpression;
import org.eclipse.persistence.jpa.jpql.parser.LikeExpression;
import org.eclipse.persistence.jpa.jpql.parser.LocateExpression;
import org.eclipse.persistence.jpa.jpql.parser.LowerExpression;
import org.eclipse.persistence.jpa.jpql.parser.MaxFunction;
import org.eclipse.persistence.jpa.jpql.parser.MinFunction;
import org.eclipse.persistence.jpa.jpql.parser.ModExpression;
import org.eclipse.persistence.jpa.jpql.parser.MultiplicationExpression;
import org.eclipse.persistence.jpa.jpql.parser.NotExpression;
import org.eclipse.persistence.jpa.jpql.parser.NullComparisonExpression;
import org.eclipse.persistence.jpa.jpql.parser.NullIfExpression;
import org.eclipse.persistence.jpa.jpql.parser.NumericLiteral;
import org.eclipse.persistence.jpa.jpql.parser.ObjectExpression;
import org.eclipse.persistence.jpa.jpql.parser.OrExpression;
import org.eclipse.persistence.jpa.jpql.parser.SizeExpression;
import org.eclipse.persistence.jpa.jpql.parser.SqrtExpression;
import org.eclipse.persistence.jpa.jpql.parser.StateFieldPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.StringLiteral;
import org.eclipse.persistence.jpa.jpql.parser.SubstringExpression;
import org.eclipse.persistence.jpa.jpql.parser.SubtractionExpression;
import org.eclipse.persistence.jpa.jpql.parser.SumFunction;
import org.eclipse.persistence.jpa.jpql.parser.TrimExpression;
import org.eclipse.persistence.jpa.jpql.parser.TypeExpression;
import org.eclipse.persistence.jpa.jpql.parser.UpdateItem;
import org.eclipse.persistence.jpa.jpql.parser.UpperExpression;
import org.eclipse.persistence.jpa.jpql.parser.ValueExpression;
import org.eclipse.persistence.jpa.jpql.parser.WhenClause;

public abstract class ParameterTypeVisitor
extends AbstractTraverseParentVisitor {
    protected Expression expression;
    protected boolean ignoreType;
    protected InputParameter inputParameter;
    protected Class<?> type;
    protected String typeName;
    protected final Set<Expression> visitedExpressions = new HashSet<Expression>();

    protected ParameterTypeVisitor() {
    }

    public void dispose() {
        this.type = null;
        this.typeName = null;
        this.expression = null;
        this.ignoreType = false;
        this.inputParameter = null;
        this.visitedExpressions.clear();
    }

    public abstract Object getType();

    public void visit(AbsExpression expression) {
        this.expression = expression;
    }

    public void visit(AbstractSchemaName expression) {
        this.expression = expression;
    }

    public void visit(AdditionExpression expression) {
        this.visitCompoundExpression(expression);
    }

    public void visit(AllOrAnyExpression expression) {
        super.visit(expression);
    }

    public void visit(AndExpression expression) {
        this.visitCompoundExpression(expression);
    }

    public void visit(ArithmeticFactor expression) {
        super.visit(expression);
    }

    public void visit(AvgFunction expression) {
        this.expression = expression;
    }

    public void visit(BetweenExpression expression) {
        Expression betweenExpression = expression.getExpression();
        Expression lowerBound = expression.getLowerBoundExpression();
        Expression upperBound = expression.getUpperBoundExpression();
        if (betweenExpression.isAncestor(this.inputParameter)) {
            if (this.visitedExpressions.add(expression)) {
                lowerBound.accept(this);
                this.visitedExpressions.remove(expression);
            } else {
                this.type = null;
                this.ignoreType = true;
                expression = null;
            }
        } else if (lowerBound.isAncestor(this.inputParameter)) {
            if (this.visitedExpressions.add(expression)) {
                upperBound.accept(this);
                this.visitedExpressions.remove(expression);
                if (this.type == null && this.visitedExpressions.add(expression)) {
                    betweenExpression.accept(this);
                    this.visitedExpressions.remove(expression);
                }
            } else {
                this.type = null;
                this.ignoreType = true;
                expression = null;
            }
        } else if (upperBound.isAncestor(this.inputParameter)) {
            if (this.visitedExpressions.add(expression)) {
                lowerBound.accept(this);
                this.visitedExpressions.remove(expression);
                if (this.type == null && this.visitedExpressions.add(expression)) {
                    betweenExpression.accept(this);
                    this.visitedExpressions.remove(expression);
                }
            } else {
                this.type = null;
                this.ignoreType = true;
                expression = null;
            }
        } else {
            this.type = Boolean.class;
        }
    }

    public void visit(CaseExpression expression) {
        this.type = Object.class;
    }

    public void visit(CoalesceExpression expression) {
        this.type = Object.class;
    }

    public void visit(CollectionMemberExpression expression) {
        Expression pathExpression = expression.getCollectionValuedPathExpression();
        this.type = pathExpression.isAncestor(this.inputParameter) ? Collection.class : Object.class;
    }

    public void visit(CollectionValuedPathExpression expression) {
        this.expression = expression;
    }

    public void visit(ComparisonExpression expression) {
        this.visitCompoundExpression(expression);
    }

    public void visit(ConcatExpression expression) {
        if (expression.getExpression().isAncestor(this.inputParameter)) {
            this.expression = expression;
        }
    }

    public void visit(ConstructorExpression expression) {
        this.typeName = expression.getClassName();
    }

    public void visit(CountFunction expression) {
        this.expression = expression;
    }

    public void visit(DateTime expression) {
        this.expression = expression;
    }

    public void visit(DivisionExpression expression) {
        this.visitCompoundExpression(expression);
    }

    public void visit(EmptyCollectionComparisonExpression expression) {
        if (expression.getExpression().isAncestor(this.inputParameter)) {
            this.ignoreType = true;
        } else {
            super.visit(expression);
        }
    }

    public void visit(EntityTypeLiteral expression) {
        this.expression = expression;
    }

    public void visit(EntryExpression expression) {
        this.expression = expression;
    }

    public void visit(ExistsExpression expression) {
        this.expression = expression;
    }

    public void visit(FunctionExpression expression) {
        this.type = Object.class;
    }

    public void visit(IdentificationVariable expression) {
        this.expression = expression;
    }

    public void visit(IndexExpression expression) {
        this.expression = expression;
    }

    public void visit(InExpression expression) {
        if (expression.getInItems().isAncestor(this.inputParameter)) {
            if (expression.isSingleInputParameter()) {
                this.type = Collection.class;
            } else if (this.visitedExpressions.add(expression)) {
                expression.getExpression().accept(this);
                this.visitedExpressions.remove(expression);
            }
        }
    }

    public void visit(InputParameter expression) {
        if (this.inputParameter == null) {
            this.inputParameter = expression;
            expression.getParent().accept(this);
        }
    }

    public void visit(KeyExpression expression) {
        this.expression = expression;
    }

    public void visit(KeywordExpression expression) {
        this.expression = expression;
    }

    public void visit(LengthExpression expression) {
        this.type = expression.isAncestor(this.inputParameter) ? String.class : Integer.class;
    }

    public void visit(LikeExpression expression) {
        Expression patternValue = expression.getPatternValue();
        Expression stringExpression = expression.getStringExpression();
        Expression escapeCharacter = expression.getEscapeCharacter();
        if (escapeCharacter.isAncestor(this.inputParameter)) {
            this.type = Character.class;
        } else if (patternValue.isAncestor(this.inputParameter)) {
            this.expression = expression.getStringExpression();
        } else if (stringExpression.isAncestor(this.inputParameter)) {
            this.expression = expression;
        } else {
            this.type = Boolean.TYPE;
        }
    }

    public void visit(LocateExpression expression) {
        Expression firstExpression = expression.getFirstExpression();
        Expression secondExpression = expression.getSecondExpression();
        this.type = firstExpression.isAncestor(this.inputParameter) || secondExpression.isAncestor(this.inputParameter) ? String.class : Integer.class;
    }

    public void visit(LowerExpression expression) {
        this.expression = expression;
    }

    public void visit(MaxFunction expression) {
        this.expression = expression;
    }

    public void visit(MinFunction expression) {
        this.expression = expression;
    }

    public void visit(ModExpression expression) {
        this.visitDoubleEncapsulatedExpression(expression);
    }

    public void visit(MultiplicationExpression expression) {
        this.visitCompoundExpression(expression);
    }

    public void visit(NotExpression expression) {
        super.visit(expression);
    }

    public void visit(NullComparisonExpression expression) {
        if (expression.getExpression().isAncestor(this.inputParameter)) {
            this.ignoreType = true;
        } else {
            this.type = Object.class;
        }
    }

    public void visit(NullIfExpression expression) {
        this.visitDoubleEncapsulatedExpression(expression);
    }

    public void visit(NumericLiteral expression) {
        this.expression = expression;
    }

    public void visit(ObjectExpression expression) {
        super.visit(expression);
    }

    public void visit(OrExpression expression) {
        this.visitCompoundExpression(expression);
    }

    public void visit(SizeExpression expression) {
        this.expression = expression;
    }

    public void visit(SqrtExpression expression) {
        if (expression.isAncestor(this.inputParameter)) {
            super.visit(expression);
        } else {
            this.expression = expression;
        }
    }

    public void visit(StateFieldPathExpression expression) {
        this.expression = expression;
    }

    public void visit(StringLiteral expression) {
        this.expression = expression;
    }

    public void visit(SubstringExpression expression) {
        if (expression.getFirstExpression().isAncestor(this.inputParameter)) {
            this.type = String.class;
        } else if (expression.getSecondExpression().isAncestor(this.inputParameter) || expression.getThirdExpression().isAncestor(this.inputParameter)) {
            this.type = Integer.class;
        }
    }

    public void visit(SubtractionExpression expression) {
        this.visitCompoundExpression(expression);
    }

    public void visit(SumFunction expression) {
        this.expression = expression;
    }

    public void visit(TrimExpression expression) {
        if (expression.getTrimCharacter().isAncestor(this.inputParameter)) {
            this.type = Character.class;
        } else if (expression.getExpression().isAncestor(this.inputParameter)) {
            this.type = String.class;
        }
    }

    public void visit(TypeExpression expression) {
        if (expression.getExpression() != this.inputParameter) {
            this.type = Class.class;
        }
    }

    public void visit(UpdateItem expression) {
        expression.getStateFieldPathExpression().accept(this);
    }

    public void visit(UpperExpression expression) {
        this.expression = expression;
    }

    public void visit(ValueExpression expression) {
        this.expression = expression;
    }

    public void visit(WhenClause expression) {
        super.visit(expression);
    }

    protected void visitCompoundExpression(CompoundExpression expression) {
        this.visitDoubleExpressions(expression, expression.getLeftExpression(), expression.getRightExpression(), true);
    }

    protected void visitDoubleEncapsulatedExpression(AbstractDoubleEncapsulatedExpression expression) {
        this.visitDoubleExpressions(expression, expression.getFirstExpression(), expression.getSecondExpression(), false);
    }

    protected void visitDoubleExpressions(Expression expression, Expression firstExpression, Expression secondExpression, boolean traverseParent) {
        if (firstExpression.isAncestor(this.inputParameter)) {
            if (this.visitedExpressions.add(expression)) {
                secondExpression.accept(this);
                this.visitedExpressions.remove(expression);
            } else {
                this.type = null;
                this.ignoreType = true;
                expression = null;
            }
        } else if (secondExpression.isAncestor(this.inputParameter)) {
            if (this.visitedExpressions.add(expression)) {
                firstExpression.accept(this);
                this.visitedExpressions.remove(expression);
            } else {
                this.type = null;
                this.ignoreType = true;
                expression = null;
            }
        } else if (traverseParent) {
            super.visit(expression);
        } else {
            this.expression = expression;
        }
    }
}

