/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.diff;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.PanelUI;

class ScrollableMessagesList
extends JPanel
implements Scrollable {
    private static final int DEFAULT_VISIBLE_ROW_COUNT = 7;
    private final int rowCount;
    private int visibleRowCount = 7;
    private Dimension preferredSize;

    public ScrollableMessagesList(Collection<String> messages) {
        super(new GridLayout(0, 1));
        int lines = 0;
        for (String msg : messages) {
            this.add(new JLabel(msg));
            ++lines;
        }
        this.rowCount = lines;
    }

    public void setVisibleRowCount(int visibleRowCount) {
        if (visibleRowCount != this.visibleRowCount) {
            this.visibleRowCount = visibleRowCount;
            this.preferredSize = null;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.preferredSize == null) {
            this.preferredSize = super.getPreferredSize();
        }
        return this.preferredSize;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension prefSize = this.getPreferredSize();
        if (this.rowCount <= this.visibleRowCount) {
            return prefSize;
        }
        Dimension prefScrollableSize = new Dimension(prefSize);
        int rowHeight = prefSize.height / this.rowCount;
        prefScrollableSize.height = this.visibleRowCount * rowHeight;
        return prefScrollableSize;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        int scrollBy;
        int rowHeight = this.getRowHeight();
        if (orientation == 1) {
            int visibleSize = visibleRect.height;
            int coveredTop = visibleRect.y % rowHeight;
            if (visibleSize >= rowHeight) {
                scrollBy = direction < 0 ? (coveredTop == 0 ? rowHeight : coveredTop) : rowHeight - coveredTop;
            } else if (visibleSize >= 4 * rowHeight / 5) {
                int deltaHalf;
                int delta = rowHeight - visibleSize;
                int coveredBottom = rowHeight - visibleSize - coveredTop;
                if (coveredBottom < 0) {
                    coveredBottom += rowHeight;
                }
                scrollBy = direction < 0 ? (coveredTop <= (deltaHalf = (delta + 1) / 2) ? coveredTop - deltaHalf + rowHeight : coveredTop - deltaHalf) : (coveredBottom <= (deltaHalf = delta / 2) ? coveredBottom - deltaHalf + rowHeight : coveredBottom - deltaHalf);
            } else {
                scrollBy = (visibleSize + 2) / 3;
            }
        } else {
            scrollBy = (rowHeight * 3 + 1) / 2;
        }
        int remainder = this.computeRemainder(visibleRect, orientation, direction);
        return Math.min(remainder, scrollBy);
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        int scrollBy;
        int rowHeight = this.getRowHeight();
        if (orientation == 1) {
            int visibleSize = visibleRect.height;
            scrollBy = visibleSize * 9 / 10;
            if (scrollBy == 0) {
                scrollBy = 1;
            }
        } else {
            int visibleSize = visibleRect.width;
            scrollBy = visibleSize * 6 / 10;
            if (scrollBy == 0) {
                scrollBy = 1;
            }
        }
        int remainder = this.computeRemainder(visibleRect, orientation, direction);
        return Math.min(remainder, scrollBy);
    }

    private int computeRemainder(Rectangle visibleRect, int orientation, int direction) {
        int remainder = orientation == 1 ? (direction < 0 ? visibleRect.y : this.getSize().height - (visibleRect.y + visibleRect.height)) : (direction < 0 ? visibleRect.x : this.getSize().width - (visibleRect.x + visibleRect.width));
        return remainder;
    }

    private int getRowHeight() {
        return this.getPreferredSize().height / this.rowCount;
    }

    @Override
    public void setUI(PanelUI ui) {
        this.preferredSize = null;
        super.setUI(ui);
    }

    @Override
    protected void setUI(ComponentUI newUI) {
        this.preferredSize = null;
        super.setUI(newUI);
    }
}

