/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.introduce;

import java.util.List;
import java.util.Vector;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.refactoring.api.CsmContext;
import org.netbeans.modules.cnd.refactoring.api.IntroduceMethodRefactoring;
import org.netbeans.modules.cnd.refactoring.introduce.IntroduceMethodPanel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class IntroduceMethodUI
implements RefactoringUI {
    private final CsmObject selectedElement;
    private final CsmContext editorContext;
    private IntroduceMethodPanel panel;
    private final IntroduceMethodRefactoring refactoring;

    private IntroduceMethodUI(CsmObject selectedElement, CsmContext editorContext) {
        this.refactoring = new IntroduceMethodRefactoring(selectedElement, editorContext);
        this.selectedElement = selectedElement;
        this.editorContext = editorContext;
    }

    public static IntroduceMethodUI create(CsmObject selectedElement, CsmContext info) {
        return new IntroduceMethodUI(selectedElement, info);
    }

    public String getDescription() {
        switch (this.refactoring.getIntroduceMethodContext().getFunctionKind()) {
            case MethodDefinition: 
            case MethodDeclarationDefinition: {
                return NbBundle.getMessage(IntroduceMethodUI.class, (String)"CAP_IntroduceMethodMethod", (Object)this.refactoring.getFunctionName());
            }
        }
        return NbBundle.getMessage(IntroduceMethodUI.class, (String)"CAP_IntroduceMethodFunction", (Object)this.refactoring.getFunctionName());
    }

    public IntroduceMethodPanel getPanel(ChangeListener parent) {
        if (this.panel == null) {
            this.panel = new IntroduceMethodPanel(this.refactoring, this.selectedElement, this.editorContext, parent);
        }
        return this.panel;
    }

    public AbstractRefactoring getRefactoring() {
        return this.refactoring;
    }

    public boolean isQuery() {
        return false;
    }

    private Problem setParameters(boolean checkOnly) {
        Vector<Vector> data = this.panel.getTableModel().getDataVector();
        IntroduceMethodRefactoring.ParameterInfo[] paramList = new IntroduceMethodRefactoring.ParameterInfo[data.size()];
        int counter = 0;
        Problem problem = null;
        for (List list : data) {
            Boolean byRef = (Boolean)list.get(0);
            CharSequence name = (CharSequence)list.get(1);
            CharSequence type = (CharSequence)list.get(2);
            paramList[counter++] = new IntroduceMethodRefactoring.ParameterInfo(byRef, name, type);
        }
        this.refactoring.setParameterInfo(paramList);
        this.refactoring.setMethodDefinition(this.panel.getMethodDefinition());
        this.refactoring.setFunctionName(this.panel.getFunctionName());
        this.refactoring.setMethodCall(this.panel.getMethodCall());
        this.refactoring.setMethodDeclaration(this.panel.getMethodDeclarationString());
        this.refactoring.setDeclarationInsetOffset(this.panel.getInsertPoint());
        problem = checkOnly ? this.refactoring.fastCheckParameters() : this.refactoring.checkParameters();
        return problem;
    }

    public String getName() {
        return NbBundle.getMessage(IntroduceMethodUI.class, (String)"CAP_IntroduceMethod");
    }

    public Problem checkParameters() {
        return this.setParameters(true);
    }

    public Problem setParameters() {
        return this.setParameters(false);
    }

    public boolean hasParameters() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("IntroduceMethod");
    }
}

