/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.asm.core.editor;

import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.modules.cnd.asm.core.dataobjects.AsmObjectUtilities;
import org.netbeans.modules.cnd.asm.model.AbstractAsmModel;
import org.netbeans.modules.cnd.asm.model.AsmModel;
import org.netbeans.modules.cnd.asm.model.AsmModelAccessor;
import org.netbeans.modules.cnd.asm.model.AsmState;
import org.netbeans.modules.cnd.asm.model.AsmSyntax;
import org.netbeans.modules.cnd.asm.model.lang.AsmElement;
import org.netbeans.modules.cnd.asm.model.lang.BranchElement;
import org.netbeans.modules.cnd.asm.model.lang.LabelElement;
import org.netbeans.modules.cnd.asm.model.lang.syntax.AsmParser;
import org.netbeans.modules.cnd.asm.model.util.AsmModelUtilities;
import org.netbeans.modules.cnd.asm.model.util.EmptyAsmState;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class AsmModelAccessorImpl
implements AsmModelAccessor {
    private static final Logger LOGGER = Logger.getLogger(AsmModelAccessorImpl.class.getName());
    private static final RequestProcessor reqProc = new RequestProcessor("asm parser", 1);
    private static final int INPUT_REACTION_DELAY = 500;
    private AsmState lastState;
    private final Object stateLock;
    private final AbstractAsmModel model;
    private final AsmSyntax synt;
    private final Document doc;
    private final String docName;
    private final AsmDocumentListener docListener;
    private final RequestProcessor.Task reparseTask;
    private final List<AsmModelAccessor.ParseListener> listeners;

    public AsmModelAccessorImpl(AsmModel model, AsmSyntax synt, Document doc) {
        this.model = (AbstractAsmModel)model;
        this.synt = synt;
        this.doc = doc;
        FileObject fo = NbEditorUtilities.getFileObject((Document)doc);
        this.docName = fo != null ? fo.getName() : "";
        this.reparseTask = reqProc.create((Runnable)new ReparseTask(), true);
        this.listeners = new LinkedList<AsmModelAccessor.ParseListener>();
        this.notifyChange(true);
        this.docListener = new AsmDocumentListener(doc);
        this.stateLock = new Object();
        this.lastState = new EmptyAsmState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsmState getState() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.lastState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addParseListener(AsmModelAccessor.ParseListener list) {
        List<AsmModelAccessor.ParseListener> list2 = this.listeners;
        synchronized (list2) {
            this.listeners.add(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeParseListener(AsmModelAccessor.ParseListener list) {
        List<AsmModelAccessor.ParseListener> list2 = this.listeners;
        synchronized (list2) {
            this.listeners.remove(list);
        }
    }

    private void notifyChange(boolean immediate) {
        int delay = immediate ? 0 : 500;
        this.reparseTask.schedule(delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireParsed() {
        List<AsmModelAccessor.ParseListener> list = this.listeners;
        synchronized (list) {
            for (AsmModelAccessor.ParseListener l : this.listeners) {
                l.notifyParsed();
            }
        }
    }

    private class AsmDocumentListener
    implements DocumentListener {
        public AsmDocumentListener(Document doc) {
            doc.addDocumentListener(WeakListeners.document((DocumentListener)this, (Object)doc));
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            AsmModelAccessorImpl.this.notifyChange(false);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            AsmModelAccessorImpl.this.notifyChange(false);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    }

    private class X86AsmState
    implements AsmState {
        private final AsmElement elements;
        private final Lookup lookup;

        public X86AsmState(AsmElement elements, Lookup lookup) {
            this.elements = elements;
            this.lookup = lookup;
        }

        @Override
        public Lookup getServices() {
            return this.lookup;
        }

        @Override
        public AsmElement getElements() {
            return this.elements;
        }

        public boolean isActual() {
            return AsmModelAccessorImpl.this.lastState == this;
        }

        @Override
        public Pair<AsmElement, AsmElement> resolveLink(int pos) {
            AsmElement inital = AsmModelUtilities.findAtRecursive(this.elements, pos);
            if (inital instanceof BranchElement) {
                String name = ((BranchElement)inital).getName();
                LabelLinkResolver resolver = new LabelLinkResolver(name);
                AsmModelUtilities.walkCompound(this.elements, resolver);
                AsmElement result = resolver.getResult();
                if (result != null) {
                    return Pair.of((Object)inital, (Object)result);
                }
            }
            return null;
        }

        private class LabelLinkResolver
        implements AsmModelUtilities.AsmVisitor {
            private AsmElement result;
            private final String name;

            public LabelLinkResolver(String name) {
                this.name = name;
            }

            @Override
            public boolean visit(AsmElement comp) {
                LabelElement t_label;
                if (comp instanceof LabelElement && (t_label = (LabelElement)comp).getName().equals(this.name)) {
                    this.result = t_label;
                    return false;
                }
                return true;
            }

            public AsmElement getResult() {
                return this.result;
            }
        }
    }

    private class ReparseTask
    implements Runnable {
        private ReparseTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long start = System.currentTimeMillis();
            AsmParser parser = AsmModelAccessorImpl.this.synt.createParser();
            AsmElement res = parser.parse(new StringReader(AsmObjectUtilities.getText(AsmModelAccessorImpl.this.doc)));
            long end = System.currentTimeMillis();
            LOGGER.log(Level.FINE, String.format("%s parse time: %d ms", AsmModelAccessorImpl.this.docName, end - start));
            if (!Thread.currentThread().isInterrupted()) {
                Object object = AsmModelAccessorImpl.this.stateLock;
                synchronized (object) {
                    AsmModelAccessorImpl.this.lastState = new X86AsmState(res, parser.getServices());
                }
                AsmModelAccessorImpl.this.fireParsed();
            }
        }
    }
}

