/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.cos;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.runner.JavaRunner;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.maven.api.Constants;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.api.classpath.DependencyProjectsProvider;
import org.netbeans.modules.maven.api.execute.ExecutionContext;
import org.netbeans.modules.maven.api.execute.ExecutionResultChecker;
import org.netbeans.modules.maven.api.execute.LateBoundPrerequisitesChecker;
import org.netbeans.modules.maven.api.execute.PrerequisitesChecker;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.configurations.M2ConfigProvider;
import org.netbeans.modules.maven.configurations.M2Configuration;
import org.netbeans.modules.maven.cos.Bundle;
import org.netbeans.modules.maven.cos.CoSAlternativeExecutor;
import org.netbeans.modules.maven.cos.OldJavaRunnerCOS;
import org.netbeans.modules.maven.customizer.CustomizerProviderImpl;
import org.netbeans.modules.maven.execute.BeanRunConfig;
import org.netbeans.modules.maven.spi.cos.CompileOnSaveSkipper;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class CosChecker
implements PrerequisitesChecker,
LateBoundPrerequisitesChecker {
    static final String NB_COS = ".netbeans_automatic_build";
    static final String RUN_MAIN = "run.single.main";
    static final String DEBUG_MAIN = "debug.single.main";
    static final String PROFILE_MAIN = "profile.single.main";
    private static final Logger LOG = Logger.getLogger(CosChecker.class.getName());
    static final RequestProcessor RP = new RequestProcessor(CosChecker.class);
    public static final String USE_OLD_COS_EXECUTION = "use.old.cos.execution";
    public static final String NETBEANS_PROJECT_MAPPINGS = "netbeansProjectMappings";
    public static final String ENV_NETBEANS_PROJECT_MAPPINGS = "Env.netbeansProjectMappings";
    public static final String MAVENEXTCLASSPATH = "maven.ext.class.path";
    private static final String SUGGESTION = "org/netbeans/modules/maven/resources/suggestion.png";
    private static boolean warnedNoCoS;

    @Override
    public boolean checkRunConfig(RunConfig config) {
        if (config.getProject() == null) {
            return true;
        }
        Properties javarunnerCheckprops = config.getMavenProject().getProperties();
        if (javarunnerCheckprops != null && javarunnerCheckprops.containsKey(USE_OLD_COS_EXECUTION) || config.getProperties().containsKey(USE_OLD_COS_EXECUTION)) {
            if (!OldJavaRunnerCOS.checkRunMainClass(config)) {
                return false;
            }
            if (!OldJavaRunnerCOS.checkRunTest(config)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean checkRunConfig(RunConfig config, ExecutionContext con) {
        if (!"build".equals(config.getActionName()) && !"rebuild".equals(config.getActionName())) {
            Project[] opened;
            for (Project openprj : opened = OpenProjects.getDefault().getOpenProjects()) {
                CosChecker.touchProject(openprj);
            }
            if (!this.checkRunMainClass(config, con)) {
                return false;
            }
            this.checkRunTest(config, con);
        }
        return true;
    }

    private boolean checkRunMainClass(RunConfig config, ExecutionContext con) {
        String actionName = config.getActionName();
        if (RunUtils.isCompileOnSaveEnabled(config) && ("run".equals(actionName) || "debug".equals(actionName) || "profile".equals(actionName) || RUN_MAIN.equals(actionName) || DEBUG_MAIN.equals(actionName) || PROFILE_MAIN.equals(actionName))) {
            long stamp = CosChecker.getLastCoSLastTouch(config, false);
            if (CosChecker.checkImportantFiles(stamp, config)) {
                return true;
            }
            for (CompileOnSaveSkipper skipper : Lookup.getDefault().lookupAll(CompileOnSaveSkipper.class)) {
                if (!skipper.skip(config, false, stamp)) continue;
                return true;
            }
            Properties javarunnerCheckprops = config.getMavenProject().getProperties();
            if (javarunnerCheckprops != null && javarunnerCheckprops.containsKey(USE_OLD_COS_EXECUTION) || config.getProperties().containsKey(USE_OLD_COS_EXECUTION)) {
                LOG.fine("use.old.cos.execution found, using JavaRunner to execute.");
            } else {
                if (CoSAlternativeExecutor.execute(config, con)) {
                    return false;
                }
                if (config instanceof BeanRunConfig) {
                    BeanRunConfig brc = (BeanRunConfig)config;
                    ArrayList<String> processedGoals = new ArrayList<String>();
                    for (String goal : brc.getGoals()) {
                        if (Constants.DEFAULT_PHASES.contains(goal) || Constants.CLEAN_PHASES.contains(goal)) continue;
                        processedGoals.add(goal);
                    }
                    boolean containsResumeFrom = processedGoals.contains("--resume-from") || processedGoals.contains("-rf");
                    if (processedGoals.size() > (containsResumeFrom ? 2 : 0)) {
                        brc.setGoals(processedGoals);
                        this.injectDependencyProjects(brc, false, con);
                    }
                } else {
                    LOG.log(Level.INFO, "could not strip phase goals from RunConfig subclass {0}", config.getClass().getName());
                }
            }
        }
        return true;
    }

    private void checkRunTest(RunConfig config, ExecutionContext con) {
        String actionName = config.getActionName();
        if (!("test.single".equals(actionName) || "debug.test.single".equals(actionName) || "profile.test.single".equals(actionName))) {
            return;
        }
        if (RunUtils.isCompileOnSaveEnabled(config)) {
            String testng = PluginPropertyUtils.getPluginProperty(config.getMavenProject(), "org.apache.maven.plugins", "maven-surefire-plugin", "testNGArtifactName", "test", "testNGArtifactName");
            if (testng == null) {
                testng = "org.testng:testng";
            }
            List deps = config.getMavenProject().getTestDependencies();
            boolean haveJUnit = false;
            boolean haveTestNG = false;
            String testngVersion = null;
            for (Dependency d : deps) {
                if (d.getManagementKey().startsWith(testng)) {
                    testngVersion = d.getVersion();
                    haveTestNG = true;
                    continue;
                }
                if (!d.getManagementKey().startsWith("junit:junit")) continue;
                haveJUnit = true;
            }
            if (haveJUnit && haveTestNG && new ComparableVersion("6.5.1").compareTo(new ComparableVersion(testngVersion)) >= 0) {
                return;
            }
            long stamp = CosChecker.getLastCoSLastTouch(config, true);
            if (CosChecker.checkImportantFiles(stamp, config)) {
                return;
            }
            for (CompileOnSaveSkipper skipper : Lookup.getDefault().lookupAll(CompileOnSaveSkipper.class)) {
                if (!skipper.skip(config, true, stamp)) continue;
                return;
            }
            if (config instanceof BeanRunConfig) {
                BeanRunConfig brc = (BeanRunConfig)config;
                ArrayList<String> processedGoals = new ArrayList<String>();
                for (String goal : brc.getGoals()) {
                    if (Constants.DEFAULT_PHASES.contains(goal) || Constants.CLEAN_PHASES.contains(goal)) continue;
                    processedGoals.add(goal);
                }
                if (processedGoals.size() > 0) {
                    brc.setGoals(processedGoals);
                    this.injectDependencyProjects(brc, true, con);
                }
            } else {
                LOG.log(Level.INFO, "could not strip phase goals from RunConfig subclass {0}", config.getClass().getName());
            }
        } else {
            CosChecker.warnNoTestCoS(config);
        }
    }

    private static void cleanGeneratedClassfiles(Project p) throws IOException {
        ArrayList<ClassPath> executePaths = new ArrayList<ClassPath>();
        for (SourceGroup g : ProjectUtils.getSources((Project)p).getSourceGroups("java")) {
            FileObject root = g.getRootFolder();
            ClassPath cp = ClassPath.getClassPath((FileObject)root, (String)"classpath/execute");
            if (cp == null) continue;
            executePaths.add(cp);
        }
        int res = JavaRunner.execute((String)"clean", Collections.singletonMap("execute.classpath", ClassPathSupport.createProxyClassPath((ClassPath[])executePaths.toArray(new ClassPath[0])))).result();
        if (res != 0) {
            throw new IOException("Failed to clean NetBeans-generated classes");
        }
    }

    static boolean checkImportantFiles(long stamp, RunConfig rc) {
        String name;
        M2Configuration m2c;
        assert (rc.getProject() != null);
        FileObject prjDir = rc.getProject().getProjectDirectory();
        if (CosChecker.isNewer(stamp, prjDir.getFileObject("pom.xml"))) {
            return true;
        }
        if (CosChecker.isNewer(stamp, prjDir.getFileObject("nbactions.xml"))) {
            return true;
        }
        M2ConfigProvider prov = (M2ConfigProvider)rc.getProject().getLookup().lookup(M2ConfigProvider.class);
        return prov != null && (m2c = prov.getActiveConfiguration()) != null && CosChecker.isNewer(stamp, prjDir.getFileObject(name = M2Configuration.getFileNameExt(m2c.getId())));
    }

    private static boolean isNewer(long stamp, FileObject fo) {
        File fl;
        return fo != null && (fl = FileUtil.toFile((FileObject)fo)).lastModified() >= stamp;
    }

    private static File getCoSFile(RunConfig rc, boolean test) {
        if (rc.getProject() == null) {
            return null;
        }
        return CosChecker.getCoSFile(rc.getMavenProject(), test);
    }

    private static File getCoSFile(MavenProject mp, boolean test) {
        String path;
        if (mp == null) {
            return null;
        }
        Build build = mp.getBuild();
        if (build == null) {
            return null;
        }
        String string = path = test ? build.getTestOutputDirectory() : build.getOutputDirectory();
        if (path == null) {
            return null;
        }
        File fl = new File(path);
        fl = FileUtil.normalizeFile((File)fl);
        return new File(fl, NB_COS);
    }

    static long getLastCoSLastTouch(RunConfig rc, boolean test) {
        File fl = CosChecker.getCoSFile(rc, test);
        if (fl == null) {
            return 0L;
        }
        if (fl.getParentFile() == null || !fl.getParentFile().exists()) {
            return 0L;
        }
        if (!fl.exists()) {
            return Long.MAX_VALUE;
        }
        return fl.lastModified();
    }

    static boolean touchCoSTimeStamp(RunConfig rc, boolean test) {
        return CosChecker.touchCoSTimeStamp(rc, test, System.currentTimeMillis());
    }

    private static boolean touchCoSTimeStamp(RunConfig rc, boolean test, long stamp) {
        if (rc.getProject() == null) {
            return false;
        }
        return CosChecker.touchCoSTimeStamp(rc.getMavenProject(), test, stamp);
    }

    static boolean touchCoSTimeStamp(MavenProject mvn, boolean test) {
        return CosChecker.touchCoSTimeStamp(mvn, test, System.currentTimeMillis());
    }

    private static boolean touchCoSTimeStamp(MavenProject mvn, boolean test, long stamp) {
        boolean folderCreated;
        File fl = CosChecker.getCoSFile(mvn, test);
        if (fl == null) {
            return false;
        }
        if (!(fl.getParentFile() != null && fl.getParentFile().exists() || (folderCreated = fl.getParentFile().mkdir()))) {
            return false;
        }
        if (!fl.exists()) {
            try {
                return fl.createNewFile();
            }
            catch (IOException ex) {
                return false;
            }
        }
        return fl.setLastModified(stamp);
    }

    static void deleteCoSTimeStamp(RunConfig rc, boolean test) {
        File fl = CosChecker.getCoSFile(rc, test);
        if (fl != null && fl.exists()) {
            fl.delete();
        }
    }

    private static void deleteCoSTimeStamp(MavenProject mp, boolean test) {
        File fl = CosChecker.getCoSFile(mp, test);
        if (fl != null && fl.exists()) {
            fl.delete();
        }
    }

    static List<String> extractDebugJVMOptions(String argLine) throws Exception {
        String[] split = CommandLineUtils.translateCommandline((String)argLine);
        ArrayList<String> toRet = new ArrayList<String>();
        for (String arg : split) {
            if ("-Xdebug".equals(arg) || "-Djava.compiler=none".equals(arg) || "-Xnoagent".equals(arg) || arg.startsWith("-Xrunjdwp") || arg.trim().length() == 0) continue;
            toRet.add(arg);
        }
        return toRet;
    }

    static void touchProject(Project project) {
        NbMavenProject prj = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
        if (prj != null) {
            MavenProject mvn = prj.getMavenProject();
            if (RunUtils.isCompileOnSaveEnabled(project)) {
                CosChecker.touchCoSTimeStamp(mvn, false);
                CosChecker.touchCoSTimeStamp(mvn, true);
            } else {
                boolean doClean;
                File f = CosChecker.getCoSFile(mvn, false);
                boolean bl = doClean = f != null && f.exists();
                if (doClean) {
                    try {
                        CosChecker.cleanGeneratedClassfiles(project);
                    }
                    catch (IOException ex) {
                        LOG.log(Level.FINE, "Error cleaning up", ex);
                    }
                }
                CosChecker.deleteCoSTimeStamp(mvn, false);
                CosChecker.deleteCoSTimeStamp(mvn, true);
            }
        }
    }

    static void warnNoTestCoS(RunConfig config) {
        if (warnedNoCoS) {
            return;
        }
        final Project project = config.getProject();
        if (project == null) {
            return;
        }
        final Notification n = NotificationDisplayer.getDefault().notify(Bundle.CosChecker_no_test_cos_title(), (Icon)ImageUtilities.loadImageIcon((String)SUGGESTION, (boolean)true), Bundle.CosChecker_no_test_cos_details(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CosChecker.showCompilePanel(project);
            }
        }, NotificationDisplayer.Priority.LOW);
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                n.clear();
            }
        }, 15000);
        warnedNoCoS = true;
    }

    private static void showCompilePanel(Project project) {
        CustomizerProviderImpl prv = (CustomizerProviderImpl)project.getLookup().lookup(CustomizerProviderImpl.class);
        if (prv != null) {
            prv.showCustomizer("COMPILE");
        }
    }

    static void warnCoSInOutput(ExecutorTask tsk, RunConfig config) throws IOException {
    }

    private void injectDependencyProjects(BeanRunConfig brc, boolean test, ExecutionContext con) {
        if (brc.getProject() == null) {
            return;
        }
        File jar = InstalledFileLocator.getDefault().locate("maven-nblib/netbeans-cos.jar", "org.netbeans.modules.maven", false);
        assert (jar != null);
        DependencyProjectsProvider dep = (DependencyProjectsProvider)brc.getProject().getLookup().lookup(DependencyProjectsProvider.class);
        assert (dep != null);
        if (dep == null) {
            Project p = brc.getProject();
            LOG.log(Level.WARNING, "no DependencyProjectsProvider available for project {0} in {1}", new Object[]{p, p.getProjectDirectory()});
        }
        StringBuilder value = new StringBuilder();
        for (DependencyProjectsProvider.Pair pair : dep.getDependencyProjects()) {
            if (!test && "test".equals(pair.getArtifact().getScope())) continue;
            Artifact a = pair.getArtifact();
            if (pair.getArtifact().hasClassifier() && !"tests".equals(pair.getArtifact().getClassifier()) || !RunUtils.isCompileOnSaveEnabled(pair.getProject()) || !OpenProjects.getDefault().isProjectOpen(pair.getProject())) continue;
            if (value.length() != 0) {
                value.append(",");
            }
            value.append(a.getGroupId()).append(":").append(a.getArtifactId()).append(":").append(a.getBaseVersion());
            File f = FileUtil.toFile((FileObject)pair.getProject().getProjectDirectory());
            value.append("=").append(f.getAbsolutePath());
        }
        if (value.length() > 0) {
            String delimiter;
            String mavenPath = brc.getProperties().get(MAVENEXTCLASSPATH);
            String string = delimiter = Utilities.isWindows() ? ";" : ":";
            if (mavenPath == null) {
                mavenPath = "";
            } else {
                if (mavenPath.contains(jar + delimiter)) {
                    return;
                }
                mavenPath = mavenPath + delimiter;
            }
            mavenPath = mavenPath + jar.getAbsolutePath();
            brc.setProperty(MAVENEXTCLASSPATH, mavenPath);
        }
        brc.setProperty(ENV_NETBEANS_PROJECT_MAPPINGS, value.toString());
    }

    public static class COSExChecker
    implements ExecutionResultChecker {
        @Override
        public void executionResult(RunConfig config, ExecutionContext res, int resultCode) {
            if (RunUtils.isCompileOnSaveEnabled(config)) {
                CosChecker.touchCoSTimeStamp(config, false);
                CosChecker.touchCoSTimeStamp(config, true);
            } else {
                CosChecker.deleteCoSTimeStamp(config, false);
                CosChecker.deleteCoSTimeStamp(config, true);
            }
        }
    }

    public static class CosPOH
    extends ProjectOpenedHook {
        private final Project project;
        private final PropertyChangeListener listener;

        public CosPOH(Project prj) {
            this.project = prj;
            this.listener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("MavenProject".equals(evt.getPropertyName())) {
                        CosChecker.touchProject(project);
                    }
                }
            };
        }

        protected void projectOpened() {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    CosChecker.touchProject(project);
                }
            });
            NbMavenProject prj = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
            if (prj != null) {
                prj.addPropertyChangeListener(this.listener);
            }
        }

        protected void projectClosed() {
            NbMavenProject prj = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
            if (prj != null) {
                prj.removePropertyChangeListener(this.listener);
                final MavenProject mvn = prj.getMavenProject();
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        CosChecker.deleteCoSTimeStamp(mvn, true);
                        CosChecker.deleteCoSTimeStamp(mvn, false);
                    }
                });
            }
        }
    }
}

