/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.CompileTimeFunction;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.EmptySequence;

public class StaticBaseURI
extends CompileTimeFunction {
    String staticBaseURI;

    public void bindStaticContext(StaticContext env) throws XPathException {
        if (this.staticBaseURI == null) {
            this.staticBaseURI = env.getBaseURI();
        }
    }

    public Expression preEvaluate(ExpressionVisitor visitor) throws XPathException {
        if (this.staticBaseURI != null) {
            return Literal.makeLiteral(new AnyURIValue(this.staticBaseURI));
        }
        String baseURI = visitor.getStaticContext().getBaseURI();
        if (baseURI == null) {
            return Literal.makeEmptySequence();
        }
        return Literal.makeLiteral(new AnyURIValue(baseURI));
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        if (this.staticBaseURI == null) {
            return EmptySequence.getInstance();
        }
        return new AnyURIValue(this.staticBaseURI);
    }
}

