/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SessionUtils;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLHistoryDlg;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLHistoryItem;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLHistoryItemWrapper;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SqlPanelListener;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.SortableTableModel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class SQLHistoryController {
    private static final String PREF_KEY_SQL_HISTORY_COL_NAME_PREFIX_ = "Squirrel.sqlHistoryColIxPrefix_";
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SQLHistoryController.class);
    private SQLHistoryDlg _dlg;
    private ArrayList<SQLHistoryItemWrapper> _sqlHistoryItemWrappers;
    private boolean _dontReactToChkFiltered;
    private ISQLPanelAPI _sqlPanelAPI;
    private JPopupMenu _popUp = new JPopupMenu();

    public SQLHistoryController(ISession session, ISQLPanelAPI sqlPanelAPI, ArrayList<SQLHistoryItem> items) {
        this._sqlPanelAPI = sqlPanelAPI;
        this._sqlHistoryItemWrappers = SQLHistoryItemWrapper.wrap(items);
        this._dlg = new SQLHistoryDlg((JFrame)SessionUtils.getOwningFrame(session), session.getActiveSessionWindow().getTitle());
        GUIUtils.centerWithinParent(this._dlg);
        this._dlg.setVisible(true);
        this._sqlPanelAPI.addSqlPanelListener(new SqlPanelListener(){

            @Override
            public void panelParentWindowClosing() {
                SQLHistoryController.this._dlg.close();
            }
        });
        this._dlg.addWindowListener(new WindowAdapter(){
            boolean onWindowClosedCalled = false;

            @Override
            public void windowClosed(WindowEvent e) {
                if (!this.onWindowClosedCalled) {
                    SQLHistoryController.this.onWindowClosed();
                }
            }

            @Override
            public void windowClosing(WindowEvent e) {
                SQLHistoryController.this.onWindowClosed();
                this.onWindowClosedCalled = true;
            }
        });
        SortableTableModel stm = (SortableTableModel)this._dlg.tblHistoryItems.getModel();
        ArrayList<SQLHistoryItemWrapper> copy = new ArrayList<SQLHistoryItemWrapper>(this._sqlHistoryItemWrappers);
        SqlHistoryTableModel dtm = new SqlHistoryTableModel(copy, stm);
        stm.setActualModel(dtm);
        DefaultTableColumnModel tcm = new DefaultTableColumnModel();
        this._dlg.tblHistoryItems.setColumnModel(tcm);
        for (int i = 0; i < SQLHistoryItemWrapper.getColumns().length; ++i) {
            TableColumn col = new TableColumn(i);
            tcm.addColumn(col);
            String header = SQLHistoryItemWrapper.getColumns()[i];
            col.setHeaderValue(header);
            col.setPreferredWidth(Preferences.userRoot().getInt(PREF_KEY_SQL_HISTORY_COL_NAME_PREFIX_ + header, 50));
        }
        JMenuItem mnuAppendSelectionToEditor = new JMenuItem(s_stringMgr.getString("SQLHistoryController.mnuAppendSelectionToEditor"));
        mnuAppendSelectionToEditor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLHistoryController.this.onAppendSelectionToEditor();
            }
        });
        this._popUp.add(mnuAppendSelectionToEditor);
        this._dlg.tblHistoryItems.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SQLHistoryController.this.onTblSelectionChanged(e);
            }
        });
        this._dlg.tblHistoryItems.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    SQLHistoryController.this.onSQLSelected();
                }
            }
        });
        this._dlg.tblHistoryItems.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                SQLHistoryController.this.maybeShowPopup(evt);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                SQLHistoryController.this.maybeShowPopup(e);
            }
        });
        this._dlg.btnApplyFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLHistoryController.this.onApplyFilter();
            }
        });
        this._dlg.chkFiltered.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLHistoryController.this.onChckFiltered();
            }
        });
        this._dlg.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLHistoryController.this.closeAndSetFocus();
            }
        });
        AbstractAction closeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SQLHistoryController.this.closeAndSetFocus();
            }
        };
        KeyStroke escapeStroke = KeyStroke.getKeyStroke(27, 0);
        this._dlg.getRootPane().getInputMap(1).put(escapeStroke, "CloseAction");
        this._dlg.getRootPane().getInputMap(2).put(escapeStroke, "CloseAction");
        this._dlg.getRootPane().getInputMap(0).put(escapeStroke, "CloseAction");
        this._dlg.getRootPane().getActionMap().put("CloseAction", closeAction);
    }

    private void maybeShowPopup(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this._popUp.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void closeAndSetFocus() {
        this._dlg.close();
        this._sqlPanelAPI.getSQLEntryPanel().requestFocus();
    }

    private void onAppendSelectionToEditor() {
        int[] selRows = this._dlg.tblHistoryItems.getSelectedRows();
        if (0 < selRows.length) {
            for (int i = 0; i < selRows.length; ++i) {
                this._sqlPanelAPI.getSQLEntryPanel().appendText("\n" + this.getSQLFromRow(selRows[i]) + "\n");
            }
        }
    }

    private void onSQLSelected() {
        int[] selRows = this._dlg.tblHistoryItems.getSelectedRows();
        if (1 == selRows.length) {
            this._sqlPanelAPI.getSQLEntryPanel().appendText("\n" + this.getSQLFromRow(selRows[0]));
            this.closeAndSetFocus();
        }
    }

    private void onChckFiltered() {
        if (this._dontReactToChkFiltered) {
            return;
        }
        if (this._dlg.chkFiltered.isSelected()) {
            this.onApplyFilter();
        } else {
            SortableTableModel stm = (SortableTableModel)this._dlg.tblHistoryItems.getModel();
            SqlHistoryTableModel tm = (SqlHistoryTableModel)stm.getActualModel();
            ArrayList<SQLHistoryItemWrapper> clone = new ArrayList<SQLHistoryItemWrapper>(this._sqlHistoryItemWrappers);
            tm.setData(clone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onApplyFilter() {
        boolean filtered;
        SortableTableModel stm = (SortableTableModel)this._dlg.tblHistoryItems.getModel();
        SqlHistoryTableModel tm = (SqlHistoryTableModel)stm.getActualModel();
        if (this._dlg.chkFiltered.isSelected()) {
            ArrayList<SQLHistoryItemWrapper> clone = new ArrayList<SQLHistoryItemWrapper>(this._sqlHistoryItemWrappers);
            tm.setData(clone);
        }
        ArrayList<SQLHistoryItemWrapper> toRemove = new ArrayList<SQLHistoryItemWrapper>();
        for (SQLHistoryItemWrapper itemWrapper : tm.getData()) {
            if (this.matchesFilter(itemWrapper)) continue;
            toRemove.add(itemWrapper);
        }
        if (0 < toRemove.size()) {
            tm.removeData(toRemove);
            filtered = true;
        } else {
            filtered = false;
        }
        try {
            this._dontReactToChkFiltered = true;
            this._dlg.chkFiltered.setSelected(filtered);
        }
        finally {
            this._dontReactToChkFiltered = false;
        }
    }

    private boolean matchesFilter(SQLHistoryItemWrapper itemWrapper) {
        String filter = this._dlg.txtFilter.getText();
        if (null == filter || 0 == filter.length()) {
            return true;
        }
        SQLHistoryDlg.FilterCboItems sel = (SQLHistoryDlg.FilterCboItems)((Object)this._dlg.cboFilterItems.getSelectedItem());
        switch (sel) {
            case CONTAINS: {
                String ucfilter = filter.toUpperCase();
                return -1 < itemWrapper.getUpperCaseSQL().indexOf(ucfilter);
            }
            case STARTS_WITH: {
                String ucfilter = filter.toUpperCase();
                return itemWrapper.getUpperCaseSQL().startsWith(ucfilter);
            }
            case ENDS_WITH: {
                String ucfilter = filter.toUpperCase();
                return itemWrapper.getUpperCaseSQL().endsWith(ucfilter);
            }
            case REG_EX: {
                return itemWrapper.getUpperCaseSQL().matches(filter);
            }
        }
        throw new IllegalArgumentException("How can I ever get here?????");
    }

    private void onTblSelectionChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        int[] selRows = this._dlg.tblHistoryItems.getSelectedRows();
        if (1 == selRows.length) {
            this._dlg.txtSQL.setText(this.getSQLFromRow(selRows[0]));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((SQLHistoryController)SQLHistoryController.this)._dlg.txtSQL.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
                }
            });
        } else {
            this._dlg.txtSQL.setText(null);
        }
    }

    private String getSQLFromRow(int row) {
        TableModel tm = this._dlg.tblHistoryItems.getModel();
        return (String)tm.getValueAt(row, SQLHistoryItemWrapper.getSQLColIx());
    }

    private void onWindowClosed() {
        TableColumnModel tcm = this._dlg.tblHistoryItems.getColumnModel();
        for (int i = 0; i < tcm.getColumnCount(); ++i) {
            TableColumn col = tcm.getColumn(i);
            Preferences.userRoot().putInt(PREF_KEY_SQL_HISTORY_COL_NAME_PREFIX_ + col.getHeaderValue(), Math.max(col.getWidth(), 10));
        }
    }

    private static class SqlHistoryTableModel
    extends DefaultTableModel {
        private ArrayList<SQLHistoryItemWrapper> _tempSqlHistoryItemWrappers;
        private SortableTableModel _parent;

        public SqlHistoryTableModel(ArrayList<SQLHistoryItemWrapper> tempsqlHistoryItemWrappers, SortableTableModel parent) {
            this._tempSqlHistoryItemWrappers = tempsqlHistoryItemWrappers;
            this._parent = parent;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public Object getValueAt(int row, int column) {
            return this._tempSqlHistoryItemWrappers.get(row).getColum(column);
        }

        @Override
        public String getColumnName(int column) {
            return SQLHistoryItemWrapper.getColumns()[column];
        }

        @Override
        public int getRowCount() {
            if (null == this._tempSqlHistoryItemWrappers) {
                return 0;
            }
            return this._tempSqlHistoryItemWrappers.size();
        }

        @Override
        public int getColumnCount() {
            return SQLHistoryItemWrapper.getColumns().length;
        }

        ArrayList<SQLHistoryItemWrapper> getData() {
            return this._tempSqlHistoryItemWrappers;
        }

        public void setData(ArrayList<SQLHistoryItemWrapper> sqlHistoryItemWrappers) {
            this._tempSqlHistoryItemWrappers = sqlHistoryItemWrappers;
            this._parent.tableChanged();
        }

        public void removeData(ArrayList<SQLHistoryItemWrapper> toRemove) {
            this._tempSqlHistoryItemWrappers.removeAll(toRemove);
            this._parent.tableChanged();
        }
    }
}

