/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.event;

import java.io.Serializable;
import java.util.HashMap;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.ejb.event.Callback;
import org.hibernate.ejb.event.CallbackResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityCallbackHandler
implements Serializable {
    private HashMap<Class, Callback[]> preCreates = new HashMap();
    private HashMap<Class, Callback[]> postCreates = new HashMap();
    private HashMap<Class, Callback[]> preRemoves = new HashMap();
    private HashMap<Class, Callback[]> postRemoves = new HashMap();
    private HashMap<Class, Callback[]> preUpdates = new HashMap();
    private HashMap<Class, Callback[]> postUpdates = new HashMap();
    private HashMap<Class, Callback[]> postLoads = new HashMap();

    public void add(XClass entity, ReflectionManager reflectionManager) {
        this.addCallback(entity, this.preCreates, PrePersist.class, reflectionManager);
        this.addCallback(entity, this.postCreates, PostPersist.class, reflectionManager);
        this.addCallback(entity, this.preRemoves, PreRemove.class, reflectionManager);
        this.addCallback(entity, this.postRemoves, PostRemove.class, reflectionManager);
        this.addCallback(entity, this.preUpdates, PreUpdate.class, reflectionManager);
        this.addCallback(entity, this.postUpdates, PostUpdate.class, reflectionManager);
        this.addCallback(entity, this.postLoads, PostLoad.class, reflectionManager);
    }

    public boolean preCreate(Object bean) {
        return this.callback(this.preCreates.get(bean.getClass()), bean);
    }

    public boolean postCreate(Object bean) {
        return this.callback(this.postCreates.get(bean.getClass()), bean);
    }

    public boolean preRemove(Object bean) {
        return this.callback(this.preRemoves.get(bean.getClass()), bean);
    }

    public boolean postRemove(Object bean) {
        return this.callback(this.postRemoves.get(bean.getClass()), bean);
    }

    public boolean preUpdate(Object bean) {
        return this.callback(this.preUpdates.get(bean.getClass()), bean);
    }

    public boolean postUpdate(Object bean) {
        return this.callback(this.postUpdates.get(bean.getClass()), bean);
    }

    public boolean postLoad(Object bean) {
        return this.callback(this.postLoads.get(bean.getClass()), bean);
    }

    private boolean callback(Callback[] callbacks, Object bean) {
        if (callbacks != null && callbacks.length != 0) {
            for (Callback callback : callbacks) {
                callback.invoke(bean);
            }
            return true;
        }
        return false;
    }

    private void addCallback(XClass entity, HashMap<Class, Callback[]> map, Class annotation, ReflectionManager reflectionManager) {
        Callback[] callbacks = null;
        callbacks = CallbackResolver.resolveCallback(entity, annotation, reflectionManager);
        map.put(reflectionManager.toClass(entity), callbacks);
    }
}

