/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.inspector.gui;

import com.nitido.utils.toaster.Toaster;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingWorker;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.zookeeper.inspector.gui.ZooInspectorIconResources;
import org.apache.zookeeper.inspector.manager.NodeListener;
import org.apache.zookeeper.inspector.manager.ZooInspectorManager;

public class ZooInspectorTreeViewer
extends JPanel
implements NodeListener {
    private final ZooInspectorManager zooInspectorManager;
    private final JTree tree;
    private final Toaster toasterManager;

    public ZooInspectorTreeViewer(final ZooInspectorManager zooInspectorManager, TreeSelectionListener listener) {
        this.zooInspectorManager = zooInspectorManager;
        this.setLayout(new BorderLayout());
        final JPopupMenu popupMenu = new JPopupMenu();
        final JMenuItem addNotify = new JMenuItem("Add Change Notification");
        this.toasterManager = new Toaster();
        this.toasterManager.setBorderColor(Color.BLACK);
        this.toasterManager.setMessageColor(Color.BLACK);
        this.toasterManager.setToasterColor(Color.WHITE);
        addNotify.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<String> selectedNodes = ZooInspectorTreeViewer.this.getSelectedNodes();
                zooInspectorManager.addWatchers(selectedNodes, ZooInspectorTreeViewer.this);
            }
        });
        final JMenuItem removeNotify = new JMenuItem("Remove Change Notification");
        removeNotify.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<String> selectedNodes = ZooInspectorTreeViewer.this.getSelectedNodes();
                zooInspectorManager.removeWatchers(selectedNodes);
            }
        });
        this.tree = new JTree(new DefaultMutableTreeNode());
        this.tree.setCellRenderer(new ZooInspectorTreeCellRenderer());
        this.tree.setEditable(false);
        this.tree.getSelectionModel().addTreeSelectionListener(listener);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger() || e.getButton() == 3) {
                    popupMenu.removeAll();
                    popupMenu.add(addNotify);
                    popupMenu.add(removeNotify);
                    popupMenu.show(ZooInspectorTreeViewer.this, e.getX(), e.getY());
                }
            }
        });
        this.add((Component)this.tree, "Center");
    }

    public void refreshView() {
        final LinkedHashSet<TreePath> expandedNodes = new LinkedHashSet<TreePath>();
        int rowCount = this.tree.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            TreePath path = this.tree.getPathForRow(i);
            if (!this.tree.isExpanded(path)) continue;
            expandedNodes.add(path);
        }
        final TreePath[] selectedNodes = this.tree.getSelectionPaths();
        SwingWorker<Boolean, Void> worker = new SwingWorker<Boolean, Void>(){

            @Override
            protected Boolean doInBackground() throws Exception {
                ZooInspectorTreeViewer.this.tree.setModel(new DefaultTreeModel(new ZooInspectorTreeNode("/", null)));
                return true;
            }

            @Override
            protected void done() {
                for (TreePath path : expandedNodes) {
                    ZooInspectorTreeViewer.this.tree.expandPath(path);
                }
                ZooInspectorTreeViewer.this.tree.getSelectionModel().setSelectionPaths(selectedNodes);
            }
        };
        worker.execute();
    }

    public void clearView() {
        this.tree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode()));
    }

    public List<String> getSelectedNodes() {
        TreePath[] paths = this.tree.getSelectionPaths();
        ArrayList<String> selectedNodes = new ArrayList<String>();
        if (paths != null) {
            for (TreePath path : paths) {
                Object[] pathArray;
                StringBuilder sb = new StringBuilder();
                for (Object o : pathArray = path.getPath()) {
                    String nodeName = o.toString();
                    if (nodeName.length() <= 0) continue;
                    sb.append("/");
                    sb.append(o.toString());
                }
                selectedNodes.add(sb.toString());
            }
        }
        return selectedNodes;
    }

    @Override
    public void processEvent(String nodePath, String eventType, Map<String, String> eventInfo) {
        StringBuilder sb = new StringBuilder();
        sb.append("Node: ");
        sb.append(nodePath);
        sb.append("\nEvent: ");
        sb.append(eventType);
        if (eventInfo != null) {
            for (Map.Entry<String, String> entry : eventInfo.entrySet()) {
                sb.append("\n");
                sb.append(entry.getKey());
                sb.append(": ");
                sb.append(entry.getValue());
            }
        }
        this.toasterManager.showToaster((Icon)ZooInspectorIconResources.getInformationIcon(), sb.toString());
    }

    private class ZooInspectorTreeNode
    implements TreeNode {
        private final String nodePath;
        private final String nodeName;
        private final ZooInspectorTreeNode parent;

        public ZooInspectorTreeNode(String nodePath, ZooInspectorTreeNode parent) {
            this.parent = parent;
            this.nodePath = nodePath;
            int index = nodePath.lastIndexOf("/");
            if (index == -1) {
                throw new IllegalArgumentException("Invalid node path" + nodePath);
            }
            this.nodeName = nodePath.substring(index + 1);
        }

        public Enumeration<TreeNode> children() {
            List<String> children = ZooInspectorTreeViewer.this.zooInspectorManager.getChildren(this.nodePath);
            Collections.sort(children);
            ArrayList<ZooInspectorTreeNode> returnChildren = new ArrayList<ZooInspectorTreeNode>();
            for (String child : children) {
                returnChildren.add(new ZooInspectorTreeNode((this.nodePath.equals("/") ? "" : this.nodePath) + "/" + child, this));
            }
            return Collections.enumeration(returnChildren);
        }

        @Override
        public boolean getAllowsChildren() {
            return ZooInspectorTreeViewer.this.zooInspectorManager.isAllowsChildren(this.nodePath);
        }

        @Override
        public TreeNode getChildAt(int childIndex) {
            String child = ZooInspectorTreeViewer.this.zooInspectorManager.getNodeChild(this.nodePath, childIndex);
            if (child != null) {
                return new ZooInspectorTreeNode((this.nodePath.equals("/") ? "" : this.nodePath) + "/" + child, this);
            }
            return null;
        }

        @Override
        public int getChildCount() {
            return ZooInspectorTreeViewer.this.zooInspectorManager.getNumChildren(this.nodePath);
        }

        @Override
        public int getIndex(TreeNode node) {
            return ZooInspectorTreeViewer.this.zooInspectorManager.getNodeIndex(this.nodePath);
        }

        @Override
        public TreeNode getParent() {
            return this.parent;
        }

        @Override
        public boolean isLeaf() {
            return !ZooInspectorTreeViewer.this.zooInspectorManager.hasChildren(this.nodePath);
        }

        public String toString() {
            return this.nodeName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.nodePath == null ? 0 : this.nodePath.hashCode());
            result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ZooInspectorTreeNode other = (ZooInspectorTreeNode)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.nodePath == null ? other.nodePath != null : !this.nodePath.equals(other.nodePath)) {
                return false;
            }
            return !(this.parent == null ? other.parent != null : !this.parent.equals(other.parent));
        }

        private ZooInspectorTreeViewer getOuterType() {
            return ZooInspectorTreeViewer.this;
        }
    }

    private static class ZooInspectorTreeCellRenderer
    extends DefaultTreeCellRenderer {
        public ZooInspectorTreeCellRenderer() {
            this.setLeafIcon(ZooInspectorIconResources.getTreeLeafIcon());
            this.setOpenIcon(ZooInspectorIconResources.getTreeOpenIcon());
            this.setClosedIcon(ZooInspectorIconResources.getTreeClosedIcon());
        }
    }
}

