/*
* MyGoGrinder - a program to practice Go problems
* This class' code copyright (c): Ruediger Klehn (2015)
*   RuediRf@users.sourceforge.net
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
*
*/

/**
*@author Ruediger Klehn
*/

package GoGrinder.sgf;
// import java.io.File;
// import java.io.*;
import java.sql.Timestamp; // since Java 1.5
import java.util.*;
import javax.swing.*;

import GoGrinder.FileWorks;
import GoGrinder.FileWReadWrite;
import GoGrinder.FileWCpMv;
import GoGrinder.Main;
import GoGrinder.GS;

// what will here be logged: defect file, edited file, moved file
public class SGFLog{
  public static boolean alreadyReported = false; // when there is an error which can be bypassed, but with more than one occurence,
                                        // we get several messages for the same file; we stop that, but want other errors be reported
  private static String dateTime = "today";
 // private static String settings = "defaults";
  private static int bufferSize = GS.getSgfLogBufferSize();
  private static long warnLogFileSize = GS.getSgfLogWarnFileSize();
  private static String fileSizeMsg = "Size of the log file is now around " + warnLogFileSize + " bytes.\n"
                                    + "You should shorten the file.";
  private static String logString = "";
  private static boolean noLog = false; // NOT YET some messages may clutter the log, when we e.g. coded around an error or similar
  public static int errorType = 1; // "Defect:", "Cannot use file (unsupported feature):", ...
  private static StringBuffer collectedLogStrings = new StringBuffer("");
  static final String NL = Main.NEW_LINE;
  private static String logFile = Main.sgfLogFilePath; // als final in Main! sgflog.txt
  public static String displayString = ""; // public: we use it in SGFController for msg/question "edit?"
  public static boolean moveDefectFile = false;

  public static int logLevel = (Main.DEBUG2) ? 3 : GS.getSgfLogLevel(); // LogLevel rumbles, runs very unsmooth!
            // 0 = SHORT - file name - with just "Defect: " or "Can't use: "
            // 1 = NORMAL - file name, message;
            // 2 = DETAIL - file name, message, code example
            // 3 = DEBUG - file name, message, code example, origin // this is used, if Main.DEBUG2 = true // ... , ignored files ?

// we have as default all info and decide the written info, when logging is needed
// validate: with settings window: folder, level, if move defect files (only when working from GUI)
   
  public SGFLog(){} // call this to initialize variables?? (is this needed?)
  
  public static void SGFLog(String message){
    message += NL;
    if (SGFParser.VALIDATING)collectStrings(message);
    else writeSGFLog(message); // ###############################
  // for intro message, e.g. date, time, settings, searching path; dividing bar
  // also when only the file name is stored (??)
  // writeBar(), getSettings, changedSettings, 
  }

  // SGFLog(String, String)
  public static void SGFLog(String sgfFileName, String message){ // we used it to find a bug connected to SZ[]
                                                                 // -> Validator.validate(File) -> SGFUtils(95)
    logString = message + sgfFileName + NL;
    System.out.println(logString);
    if (SGFParser.VALIDATING)collectStrings(logString);
    else {writeSGFLog(logString);}
  }
  
  // we use this for debugging: when a bug is seemingly connected to the previous file (only built in in the validator))
  public static void SGFLogFileOK(String sgfFileName){ // this routine executes depending on "if (Main.DEBUG2)" in Validator
    String message = "# File O.K.: " + NL;
    //int len = sgfFileName.length();
    //if (len > 75) {sgfFileName = "..." + sgfFileName.substring(len - 75, len);}
    logString = message + sgfFileName + NL + NL;
    System.out.println(logString);
    collectStrings(logString);
  }
  
  public static String getCurrentFileName(){ // int origin // origin 1=probFrame, 2=Validator, 3=WGFFrame
    String currFileStr = "";
    if (GoGrinder.FileUtils.splitting) currFileStr = GoGrinder.FileUtils.splitThis;
    else if (SGFParser.checkingSGF) currFileStr = SGFParser.thisFileName; // this includes VALIDATING
    else if (GoGrinder.GS.getProbState()) currFileStr = GoGrinder.SGFController.currFile; // && !SGFParser.checkingSGF
    else {currFileStr = GoGrinder.WGFController.thisWGFFileStr;}
    // file name: shorten to ~ 75 char. for output on 80-char.-console
    //int len = currFileStr.length();
    //if (len > 75) {currFileStr = "..." + currFileStr.substring(len - 75, len);}
    return currFileStr;
  }

  public static String shortenCode(String sgfCode){
    if (sgfCode == null) return "";
    String returnStr = "";
    if (sgfCode.length() > 200){
      String msg2 = " ..." + NL + " (code example shortened from " + sgfCode.length() + " to 190 bytes)";
      returnStr = sgfCode.substring(0, 190).trim() + msg2;
    }
    else 
      returnStr = sgfCode.trim();
    return returnStr;
  }
  
  public static void SGFLog2(int localErrorType, String message, String code, String origin){
    logLevel = GS.getSgfLogLevel();
    // errorTypes: 0 - Collection file (no error);
    //             1 - File defect; 
    //             2 - File defect, but we bypass that; 
    //             3 - Cannot use file (unsupported feature)
    if (( logLevel == 0 || logLevel == 2) && !Main.DEBUG2) return;
      errorType = localErrorType; // we need to change this if we temporary want to use another errorType
      if (errorType == 2 && alreadyReported){
        errorType = 1;
        SGFLog("Repetition of the same error in the file:" + NL + "\"" + getCurrentFileName() + "\"" + NL);
        return;
      }
      if (errorType == 2)
        alreadyReported = true; // will be reset in SGFParser.parse()
      SGFLog(getCurrentFileName(), message, code, origin);
  }

  // SGFLog2(String, String, String, String)    in: Validator II
  public static void SGFLog2(String fileName, String message, String code, String origin){
    SGFLog(fileName, message, code, origin);
  }
  // SGFLog(String, String, String, String)       in SGFParseException I
  public static void SGFLog(String fileName, String message, String code, String origin){
    boolean doMove = false;
    String moveCategory = ""; // defect, notsupported
    logLevel = GS.getSgfLogLevel();
    String header = "";
    String styleStartCode = "<pre><span style=\"background-color:silver\">";
    String styleEndCode = "</span></pre>";
    String htmlBr = "<br>";

    displayString = "";
    String originMsg = " Happened in " + origin + NL;
    switch (errorType){
      case 0: header = "Collection file (no error): "; break; // private static boolean noLog = false;
      case 1: header = "File defect: "; doMove = true; moveCategory = "defect"; break;
      case 2: header = "File defect, but we work around: "; break; // clutters sgf-log // private static boolean noLog = false;
      case 3: header = "Cannot use file (unsupported feature): "; doMove = true; moveCategory = "notsupported"; break;
    } // move can only be allowed, if we work with files in our own collection
    
    logString = "";
    code = shortenCode(code);
    
    if (logLevel > -1){
      logString += header + NL + fileName + NL;
      displayString += header + htmlBr + fileName + htmlBr;
    }
    if (logLevel > 0){
      logString += message + NL;
      String htmlMsg = message.replace("<", "&lt;");
      htmlMsg = htmlMsg.replace("\r\n", "<br>");
//d.b.cg(htmlMsg + "\n #1");
      displayString += htmlMsg + htmlBr;
    }
    if (logLevel > 1 && !code.equals("")){
      logString += code + NL; //
      String htmlCode = code.replace("<", "&lt;");
      htmlCode = htmlCode.replace("\r\n", "<br>");
      htmlCode = htmlCode.replace("\n", "<br>");
//d.b.cg(htmlCode + "\n #2");
      displayString += styleStartCode + htmlCode + styleEndCode + htmlBr; // complete msg enclosed by <html></html> (lowercase is o.k.)
    }
    if (logLevel > 2 || Main.DEBUG2){
      logString += " >>>" + originMsg;
      originMsg = originMsg.replace("\r\n", "<br>");
      displayString += " &gt;&gt;&gt;" + originMsg;
    }
    if (doMove){
      String moveResultText = moveFile(fileName, moveCategory);
      logString += moveResultText + NL;
      moveResultText = moveResultText.replace("\r\n", "<br>");
      displayString += moveResultText;
    }
    logString += NL;
    if (SGFParser.VALIDATING)collectStrings(logString);
    else writeSGFLog(logString);
    doMove = false;
    moveCategory = "";
    errorType = 1;
  }

   // NOT YET USED // SGFLog(int, String, String, String) // why not origin here?
  public static void X_SGFLog(int level, String sgfFileName, String message, String sgfCodeExample){ // NOT YET USED 
//    logLevel = GS.getSgfLogLevel(); // DAS FUNZT HIER NICHT
    boolean moveSuccess = false; // HERE WRONG!!
    int oldLevel = logLevel; // this can be used for a validating run with temporary changed logLevel
    logLevel = level;  // this needs to be set/reset in the Validator settings
    // and, at the end of the validating run, it is reset: logLevel = oldLevel 
    // - oh! oldLevel must be static and for the complete validating run
    String moveResultTxt = ""; // HERE WRONG!!
    String abortMoveTxt = NL + "Abort moving defect files (but continue parsing)?"; // AND Btn. "Abort all", "Abort moving"// HIER FALSCH!!
     // kann doch direkt!
    //moveSuccess = moveDefectFile; // log: if (moveSuccess) msg = msg + file moved to SETTINGS/defect // HIER FALSCH!!
    if (true) {moveSuccess = FileWCpMv.fileWCpMvSGF(sgfFileName, Main.DEFECT_DIR, false, FileWCpMv.MOVE); // false = infoUser, moveDefectFile
       //if(!validating)msgUser} 
    // HERE WRONG!!
    }
    if (!moveSuccess){
      moveResultTxt = "Defect file couldn't be moved to:" + NL + Main.pathToDefect;
      // msgWindow, when abort, write to log
      /*msg + option to disable move file*/
    } // HERE WRONG!!
    else {moveResultTxt = "File moved to " + Main.pathToDefect;} // HIER FALSCH!!
    SGFLog(sgfFileName, message + moveResultTxt, sgfCodeExample, ""); // moveResultTxt statt code
    // MessageWindow: toggleMove[x], toggleMessage[x], showLogLevel, showProgress[x] 
    //                (countFiles "counting files" and showCountFinished) showSettings, 
    //                showActFolder, wenn änderung einstellungen, dann einfügen 
    //                "change settings: " + newSettings, ...
    logLevel = oldLevel; // this needs to be set/reset in the Validator settings
  }
  
  // SGFLog(int, String, String, String, String) // NOT YET USED
  public static void X_SGFLog(int level, String sgfFileName, String message, String sgfCodeExample, String excMsg){ // NOT YET USED
    StringBuffer collectLog = new StringBuffer(bufferSize);
    if (excMsg == null) excMsg = "";
    // strings in buffer aufnehmen, wenn buffer > 10000 dann schreiben 
    // puffern, wenn 
    // (eigentlich, wenn log + exceptions, dann zeit unkritisch)
  }
  
  public static void collectStrings(String addThisString){ // this is used to reduce parsing time for a complete folder
    collectedLogStrings.append(addThisString); // + NL
    if (collectedLogStrings.length() > bufferSize) { // bufferSize: at the moment a fixed value of 10000)
      writeSGFLog(collectedLogStrings);
      collectedLogStrings = new StringBuffer(bufferSize);
    }
       // StringBuffer.append("...") // needs extra line separator

    // Eventuell sollte bei jedem Fehler der akt. (event. abgekürzte) 
    // Dateiname (oder das akt. Verz.) auf die Konsole geschrieben werden, 
    // um zu verhindern, dass bei einem unvorhergesehenen Absturz umstaendlich 
    // die Fehlerdatei eingegrenzt werden muss. Vielleicht:
    // if(Main.DEBUG2) System.out.println("Processing: " + FILENAME)
    //                                 or "Processing: " + PATH ... "DONE"

  }

  public static void setBufferSize(int newBufferSize){
    bufferSize = newBufferSize; // NOT YET used - if needed: set it manually in the settings file (set by settings window will come later)
    //writeBufferToFile(), resizeBuffer()
    // boolean FileWorks.writeFileStrBuff(String pathToFile, StringBuffer StrBuff)
    //FileWorks.writeFileStrBuff();
  }
  
  public static void checkLogSize(String thisLogFile, long warnSize){
  // looks like some coding work - extra class? (only, if automatic shortening and adding (new) header info)
    String msg = "";
    long logFileSize = FileWorks.getFileSize(thisLogFile);
    if (logFileSize > warnSize){
      msg = "A log file grew to " + logFileSize + " bytes. Consider to shorten it.\n" 
           + "File and location:" + NL
           + "\"" + thisLogFile + "\"";
      JOptionPane.showMessageDialog(null, msg);
    }
   // called only at the begin of logging/at program start
    
   // getLogFileSize, compareToMax, if (bigger then max) info user (erstamal "you can shorten it yourself", später auto-shorten nach rückfrage), question "shorten"
   // if (yes) FileWorks.shortenLogFile (int shortBytes, String intro) , shortened file to StringBuffer 
   // write file (get settings), write "file cut down from xyMBy to xz Bytes, DateTime" write file add stringbuffer RETURN
    
  // can let the file cut down, then
  // adds date of cutting, version of GG, name of moveToFolder, settings
  // and a bar of "#### ^^- old log -^^ - vv- new log -vv ####" between old and new log
  // "The size of the log file PATH/NAME exceeds x megabytes: act. size = " + #### + " mby"
  // PATH/NAME in SETTINGS oder TEMP
  // "reduce size to xy kby?"
  // "defect sgf files can (at your option) be moved to PFAD"
  }

  private static String dateTime(){ //import java.sql.Timestamp; // since Java 1.5
    return new Timestamp(new Date().getTime()).toString(); // 2014-11-16 14:39:11.906
  }
  
  private static String getBar(){
  return NL + " #############################################################################" + NL;
  }//void writeFileAddStringUTF8(String fileName, String addThis){} // writes with utf-8 encoding!
  
  private static String getSettings(){ // better getSettingsStr?
    logLevel = GS.getSgfLogLevel();
    String prg = "";
    if (Main.TEST) prg = "MyGG-TEST-";
    else prg = "MyGG-";
    return " ### " + prg + Main.NUM_VER_STRING + " - " + dateTime() + NL
         + " ### Settings (change them in the settings file or by system variables):" + NL
         + " ### logBufferSize = " + bufferSize + "; warnLogFileSize = " + warnLogFileSize + ";"  + NL
         + " ### moveDefectFile = " + GS.getParserMoveDefectFile() + "; parserSGFMaxFileSize = " 
                                              + GS.getParserSGFMaxFileSize() + ";" + NL
         + " ### logLevel = " + logLevel + " (" + getLogLevelName(logLevel) + ")" + NL
         + " ### DEBUG2 (stacktrace for sgf-errors) = " + Main.DEBUG2 + NL;
  } // oder writeIntro oder beides
 
  
  public static void beginLogging(){ //used with validate
  //writeBar, writeDateTime, writeSettings ()
    checkLogSize(logFile, warnLogFileSize);
    collectedLogStrings = new StringBuffer(bufferSize);
    
    // this writes with utf-8 encoding:
    FileWReadWrite.writeFileAddStringUTF8(logFile, getBar() + getSettings()
                                 + " ### parse folder:" + NL + " ### \"" + Validator.validateFolder + "\"" + NL + NL);
//    writeSGFLog(getBar() + getSettings());
//    writeSGFLog(" ### parse folder:" + NL + " ### " + Validator.validateFolder + NL);
  }
  
  public static void finishLogging(String summary){ //used with validate
    FileWReadWrite.writeFileAddStringBufferUTF8(logFile, collectedLogStrings);
    FileWReadWrite.writeFileAddStringUTF8(logFile, summary); // this writes with utf-8 encoding
   // writeSGFLog(summary);
  // "Defect files have been moved to PATH"
  }
  
  public static int getLogLevel(){return logLevel;}
  
  public static void setErrorType(int newType){errorType = newType;} // would be better if we could switch this only temporary (MANHANA!)
  
  public static void setLogLevel(int newLevel){logLevel = newLevel; GS.setSgfLogLevel(newLevel);}
  //default is 1, set from settings window and a special validating settings window; autoswitch to 2 when edit defect = true

  // AND (extra) a temporary logLevel doesn't (mustn't) touch the settings

  private static String getLogLevelName(int logLevel){ 
  // needed for settingsWindow (NOT YET) and Validating (for the headerLine) 
  // and (NOT YET) writeSettings (for when having a [also nearly] empty sgfLogFile - written 
  // to the beginning of the log file) (not yet implemented))
    switch (logLevel){ // local logLevel
      case 0: return "SHORT - file name"; // + statement "File defect:" or similar
      case 1: return "NORMAL - file name, message";
      case 2: return "DETAIL - file name, message, code example";
      case 3: return "DEBUG - file name, message, code example, origin (for e.g. debugging)";
      default: return "NORMAL - file name, message";
    }
  }
  
  // public static boolean getMoveDefectFile(){return moveDefectFile;} // NOT YET - AND: This is nothing with log!!
  
  // public static void setMoveDefectFile(boolean moveFile){moveDefectFile = moveFile;} // NOT YET - AND: This is nothing with log!!
  
  private static String moveFile(String source, String category){ // category: defect or notsupported = foldername
    boolean success = false;
    if (GS.getParserMoveDefectFile() && (!GS.getAllowTextEdit() || !Validator.getValidateFromCLI()) ) { // HERE IS A WORM!!
                         // we must not move, when we validate from command line: we 
                         // don't yet know our settings folder - but this value will
                         // be false as default from GS, and when validating from 
                         // commandline, we don't read the settings file.
                         // further we shouldn't move, when we want to text-edit a defect file,
      success = FileWCpMv.fileWCpMvSGF(source, category, false, FileWCpMv.MOVE); // false = infoUser is handled here
      if (success){
        return NL + "File moved to:" + NL + Main.pathToSettings + Main.SLASH + category;
      }
      else{
        return NL + "File couldn't be moved to:" + NL + Main.pathToSettings + Main.SLASH + category + NL
             + "Consult the grind-log.txt file";
      }
    }
    //if (GS.getParserMoveDefectFile())
    else return "";
  }


  //private void writeLog(){
  //  FileWorks.writeFileStrBuff(logFile, collectedLogStrings); // we need encoding of characters!!
  //}
  
  //public void setWarnLogFileSize(int newWarnSize){
  //  warnLogFileSize = newWarnSize; // NOT YET (when implemented, we will set it in the settings window)
  //}
  
  public static void setLogFile(String thisPath){
    logFile = thisPath;
  }
  
  public static void writeSGFLog(String writeThis){
    //displayString = writeThis;
    writeThis = " ### " + dateTime() + " (" + Main.NUM_VER_STRING + " build " 
                + GoGrinder.Params.getBuildCount() + "): ###" + NL + writeThis;
    FileWReadWrite.writeFileAddStringUTF8(logFile, writeThis); // , "UTF-8"
    //if (!SGFParser.VALIDATING){ //"Curr. file: \n NAME \n (SZ[13]...) \n LOCATION
    //displayString = fileMsg + parserMsg + "\n" + code + originMsg;
    //JOptionPane.showMessageDialog(null, displayString);//fileMsg + parserMsg + code + originMsg
    //}
  }
  
  public static void writeSGFLog(StringBuffer writeThisBuff){
    FileWReadWrite.writeFileAddStringBufferUTF8(logFile, writeThisBuff);
  }
}