/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.logging;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CircularList<T>
implements Iterable<T> {
    private T[] data;
    private int head = 0;
    private int tail = 0;
    private int size = 0;

    public CircularList(int size) {
        this.data = new Object[size];
    }

    public synchronized void resize(int newsize) {
        if (newsize == this.size) {
            return;
        }
        Object[] vals = new Object[newsize];
        int i = 0;
        if (newsize > this.size) {
            for (i = 0; i < this.size; ++i) {
                vals[i] = this.data[this.convert(i)];
            }
        } else {
            int off = this.size - newsize;
            for (i = 0; i < newsize; ++i) {
                vals[i] = this.data[this.convert(i + off)];
            }
        }
        this.data = vals;
        this.head = 0;
        this.tail = i;
    }

    private int convert(int index) {
        return (index + this.head) % this.data.length;
    }

    public boolean isEmpty() {
        return this.head == this.tail;
    }

    public int size() {
        return this.size;
    }

    public int getBufferSize() {
        return this.data.length;
    }

    private void checkIndex(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }

    public T get(int index) {
        this.checkIndex(index);
        return this.data[this.convert(index)];
    }

    public synchronized void add(T o) {
        this.data[this.tail] = o;
        this.tail = (this.tail + 1) % this.data.length;
        if (this.size == this.data.length) {
            this.head = (this.head + 1) % this.data.length;
        }
        ++this.size;
        if (this.size > this.data.length) {
            this.size = this.data.length;
        }
    }

    public synchronized void clear() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = null;
        }
        this.size = 0;
        this.tail = 0;
        this.head = 0;
    }

    public List<T> toList() {
        ArrayList<T> list = new ArrayList<T>(this.size);
        for (int i = 0; i < this.size; ++i) {
            list.add(this.data[this.convert(i)]);
        }
        return list;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[");
        for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                str.append(",");
            }
            str.append(this.data[this.convert(i)]);
        }
        str.append("]");
        return str.toString();
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < CircularList.this.size;
            }

            @Override
            public T next() {
                return CircularList.this.get(this.idx++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

