/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import org.apache.solr.analytics.function.mapping.LambdaFunction;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.StringValue;

class StringValueInStringValueOutFunction
extends StringValue.AbstractStringValue {
    private final StringValue param;
    private final LambdaFunction.StringInStringOutLambda lambda;
    private final String name;
    private final String exprStr;
    private final AnalyticsValueStream.ExpressionType funcType;
    private boolean exists = false;

    public StringValueInStringValueOutFunction(String name, LambdaFunction.StringInStringOutLambda lambda, StringValue param) {
        this.name = name;
        this.lambda = lambda;
        this.param = param;
        this.exprStr = AnalyticsValueStream.createExpressionString(name, param);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param);
    }

    @Override
    public String getString() {
        String value = this.lambda.apply(this.param.getString());
        this.exists = this.param.exists();
        return value;
    }

    @Override
    public boolean exists() {
        return this.exists;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

