/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.MockDirectoryWrapper;
import org.apache.lucene.store.NRTCachingDirectory;
import org.apache.lucene.store.NoLockFactory;
import org.apache.lucene.store.TrackingDirectoryWrapper;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.EphemeralDirectoryFactory;

public class MockDirectoryFactory
extends EphemeralDirectoryFactory {
    public static final String SOLR_TESTS_ALLOW_READING_FILES_STILL_OPEN_FOR_WRITE = "solr.tests.allow_reading_files_still_open_for_write";
    public static final String SOLR_TESTS_USING_MOCK_DIRECTORY_WRAPPER = "solr.tests.using_mock_directory_wrapper";
    private boolean allowReadingFilesStillOpenForWrite = Boolean.getBoolean("solr.tests.allow_reading_files_still_open_for_write");
    private boolean useMockDirectoryWrapper = Boolean.getBoolean("solr.tests.using_mock_directory_wrapper");

    protected LockFactory createLockFactory(String rawLockType) throws IOException {
        return NoLockFactory.INSTANCE;
    }

    protected Directory create(String path, LockFactory lockFactory, DirectoryFactory.DirContext dirContext) throws IOException {
        Object dir = this.useMockDirectoryWrapper ? LuceneTestCase.newMockDirectory() : LuceneTestCase.newDirectory();
        Directory cdir = this.reduce((Directory)dir);
        cdir = this.reduce(cdir);
        if ((cdir = this.reduce(cdir)) instanceof MockDirectoryWrapper) {
            MockDirectoryWrapper mockDirWrapper = (MockDirectoryWrapper)cdir;
            mockDirWrapper.setAssertNoUnrefencedFilesOnClose(false);
            mockDirWrapper.setCheckIndexOnClose(false);
            if (this.allowReadingFilesStillOpenForWrite) {
                mockDirWrapper.setAllowReadingFilesStillOpenForWrite(true);
            }
        }
        return dir;
    }

    private Directory reduce(Directory dir) {
        Directory cdir = dir;
        if (dir instanceof NRTCachingDirectory) {
            cdir = ((NRTCachingDirectory)dir).getDelegate();
        }
        if (cdir instanceof TrackingDirectoryWrapper) {
            cdir = ((TrackingDirectoryWrapper)dir).getDelegate();
        }
        return cdir;
    }

    public boolean isAbsolute(String path) {
        return new File(path).isAbsolute();
    }
}

