/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.servlet;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.solr.api.ApiBag;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.slf4j.Logger;

public class ResponseUtils {
    private ResponseUtils() {
    }

    public static int getErrorInfo(Throwable ex, NamedList info, Logger log) {
        int code = 500;
        if (ex instanceof SolrException) {
            SolrException solrExc = (SolrException)ex;
            code = solrExc.code();
            NamedList errorMetadata = solrExc.getMetadata();
            if (errorMetadata == null) {
                errorMetadata = new NamedList();
            }
            errorMetadata.add("error-class", (Object)ex.getClass().getName());
            errorMetadata.add("root-error-class", (Object)SolrException.getRootCause((Throwable)ex).getClass().getName());
            info.add("metadata", (Object)errorMetadata);
            if (ex instanceof ApiBag.ExceptionWithErrObject) {
                ApiBag.ExceptionWithErrObject exception = (ApiBag.ExceptionWithErrObject)((Object)ex);
                info.add("details", exception.getErrs());
            }
        }
        for (Throwable th = ex; th != null; th = th.getCause()) {
            String msg = th.getMessage();
            if (msg == null) continue;
            info.add("msg", (Object)msg);
            break;
        }
        if (code == 500 || code < 100) {
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            SolrException.log((Logger)log, (Throwable)ex);
            info.add("trace", (Object)sw.toString());
            if (code < 100) {
                log.warn("invalid return code: {}", (Object)code);
                code = 500;
            }
        }
        info.add("code", (Object)code);
        return code;
    }
}

