/*
 * Decompiled with CFR 0.152.
 */
package org.josql.filters;

import org.josql.Query;
import org.josql.QueryParseException;

public abstract class AbstractJoSQLFilter {
    protected Query q = null;
    protected Exception exp = null;
    protected boolean badQuery = false;

    protected AbstractJoSQLFilter() {
    }

    public AbstractJoSQLFilter(String q) throws QueryParseException {
        this.setQuery(q);
    }

    public abstract Class getExpectedClass();

    public AbstractJoSQLFilter(Query q) throws IllegalStateException, QueryParseException {
        this.setQuery(q);
    }

    private void checkFrom() throws QueryParseException {
        if (!this.getExpectedClass().isAssignableFrom(this.q.getFromObjectClass())) {
            throw new QueryParseException("Query FROM class is: " + this.q.getFromObjectClass().getName() + ", however only: " + this.getExpectedClass().getName() + " or sub-classes are supported.");
        }
    }

    public abstract boolean accept(Object var1) throws UnsupportedOperationException;

    public void clearException() {
        this.exp = null;
        this.badQuery = false;
    }

    public Exception getException() {
        return this.exp;
    }

    public void setQuery(String q) throws QueryParseException {
        this.q = new Query();
        this.q.parse(q);
        this.badQuery = false;
        this.exp = null;
        this.checkFrom();
    }

    public void setQuery(Query q) throws IllegalStateException, QueryParseException {
        if (!q.parsed()) {
            throw new IllegalStateException("Query has not yet been parsed.");
        }
        this.q = q;
        this.checkFrom();
        this.badQuery = false;
        this.exp = null;
    }

    public Query getQuery() {
        return this.q;
    }
}

