/*
 * Decompiled with CFR 0.152.
 */
package phase;

import ints.IntArray;
import ints.SynchedIntList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import phase.FixedPhaseData;
import phase.PhaseData;
import vcf.BasicGT;
import vcf.BitSetRefGTRec;
import vcf.Data;
import vcf.GT;
import vcf.GTRec;
import vcf.Markers;
import vcf.RefGTRec;
import vcf.XRefGT;

public class Stage2Haps {
    private final FixedPhaseData fpd;
    private final GTRec[] stage1Recs;
    private final Markers markers;
    private final AtomicReferenceArray<SynchedIntList> rareCarriers;

    public Stage2Haps(PhaseData phaseData) {
        this.fpd = phaseData.fpd();
        XRefGT xRefGT = phaseData.estPhase().phasedHaps();
        this.stage1Recs = BitSetRefGTRec.toBitSetRefGTRecs(xRefGT, this.fpd.par().nthreads());
        this.markers = this.fpd.targGT().markers();
        this.rareCarriers = Stage2Haps.rareHaps(this.fpd);
    }

    private static AtomicReferenceArray<SynchedIntList> rareHaps(FixedPhaseData fixedPhaseData) {
        int n2 = fixedPhaseData.targGT().markers().sumAlleles();
        AtomicReferenceArray<SynchedIntList> atomicReferenceArray = new AtomicReferenceArray<SynchedIntList>(n2);
        IntStream.rangeClosed(0, fixedPhaseData.stage1To2().size()).parallel().forEach(n -> Stage2Haps.initList(fixedPhaseData, n, atomicReferenceArray));
        return atomicReferenceArray;
    }

    private static void initList(FixedPhaseData fixedPhaseData, int n, AtomicReferenceArray<SynchedIntList> atomicReferenceArray) {
        Markers markers = fixedPhaseData.targGT().markers();
        IntArray intArray = fixedPhaseData.stage1To2();
        int n2 = n == 0 ? 0 : intArray.get(n - 1) + 1;
        int n3 = n == intArray.size() ? markers.size() : intArray.get(n);
        for (int i = n2; i < n3; ++i) {
            int n4 = markers.marker(i).nAlleles();
            int n5 = markers.sumAlleles(i);
            for (int j = 0; j < n4; ++j) {
                IntArray intArray2 = fixedPhaseData.carriers(i, j);
                if (intArray2 == Data.HIGH_FREQ_ARRAY) continue;
                atomicReferenceArray.set(n5 + j, new SynchedIntList(intArray2.size()));
            }
        }
    }

    public FixedPhaseData fpd() {
        return this.fpd;
    }

    public void setPhasedGT(int n, int n2, int n3, int n4) {
        SynchedIntList synchedIntList;
        int n5 = this.markers.sumAlleles(n);
        SynchedIntList synchedIntList2 = this.rareCarriers.get(n5 + n3);
        if (synchedIntList2 != null) {
            synchedIntList2.add(n2 << 1);
        }
        if ((synchedIntList = this.rareCarriers.get(n5 + n4)) != null) {
            synchedIntList.add(n2 << 1 | 1);
        }
    }

    public GT stage2Haps() {
        GTRec[] gTRecArray = (GTRec[])IntStream.rangeClosed(0, this.fpd.stage1To2().size()).parallel().boxed().flatMap(n -> this.recs(this.fpd, (int)n)).toArray(GTRec[]::new);
        GT gT = this.fpd.targGT();
        return new BasicGT(gT.markers(), gT.samples(), gTRecArray);
    }

    private Stream<GTRec> recs(FixedPhaseData fixedPhaseData, int n) {
        IntArray intArray = fixedPhaseData.stage1To2();
        int n2 = n == 0 ? 0 : intArray.get(n - 1);
        int n3 = n == intArray.size() ? this.markers.size() : intArray.get(n);
        GTRec[] gTRecArray = new GTRec[n3 - n2];
        for (int i = n2; i < n3; ++i) {
            if (i == n2 && n > 0) {
                gTRecArray[0] = this.stage1Recs[n - 1];
                continue;
            }
            int n4 = this.markers.sumAlleles(i);
            int n5 = this.markers.sumAlleles(i + 1);
            int[][] nArrayArray = new int[n5 - n4][];
            for (int j = 0; j < nArrayArray.length; ++j) {
                SynchedIntList synchedIntList = this.rareCarriers.get(n4 + j);
                if (synchedIntList == null) continue;
                nArrayArray[j] = synchedIntList.toArray();
                Arrays.sort(nArrayArray[j]);
            }
            GT gT = fixedPhaseData.targGT();
            gTRecArray[i - n2] = RefGTRec.hapCodedInstance(gT.marker(i), gT.samples(), nArrayArray);
        }
        return Arrays.stream(gTRecArray);
    }
}

