/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.common.Display;
import org.diylc.common.ObjectCache;
import org.diylc.components.AbstractTransparentComponent;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.Theme;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.utils.Constants;

public abstract class AbstractLeadedComponent<T>
extends AbstractTransparentComponent<T> {
    private static final long serialVersionUID = 1L;
    public static Color LEAD_COLOR = Color.decode("#CCCCCC");
    public static Color LEAD_COLOR_ICON = LEAD_COLOR.darker().darker();
    public static Size LEAD_THICKNESS = new Size((Double)0.6, SizeUnit.mm);
    public static Size DEFAULT_SIZE = new Size((Double)1.0, SizeUnit.in);
    protected Size length;
    protected Size width;
    protected Point[] points = new Point[]{new Point((int)(-DEFAULT_SIZE.convertToPixels() / 2.0), 0), new Point((int)(DEFAULT_SIZE.convertToPixels() / 2.0), 0)};
    protected Color bodyColor = Color.white;
    protected Color borderColor = Color.black;
    protected Color labelColor = LABEL_COLOR;
    protected Color leadColor = LEAD_COLOR;
    protected Display display = Display.NAME;
    private boolean flipStanding = false;

    protected AbstractLeadedComponent() {
        try {
            this.length = this.getDefaultLength().clone();
            this.width = this.getDefaultWidth().clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public void draw(Graphics2D graphics2D, ComponentState componentState, boolean bl, Project project, IDrawingObserver iDrawingObserver) {
        double d = this.points[0].distance(this.points[1]);
        Shape shape = this.getBodyShape();
        if (shape == null) {
            this.drawLead(graphics2D, componentState);
        } else if (this.supportsStandingMode() && this.length.convertToPixels() > this.points[0].distance(this.points[1])) {
            Color color;
            int n = this.getClosestOdd(this.width.convertToPixels());
            Ellipse2D.Double double_ = new Ellipse2D.Double((this.getFlipStanding() ? this.points[1] : this.points[0]).x - n / 2, (this.getFlipStanding() ? this.points[1] : this.points[0]).y - n / 2, n, n);
            Composite composite = graphics2D.getComposite();
            if (this.alpha < MAX_ALPHA) {
                graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / (float)MAX_ALPHA));
            }
            graphics2D.setColor(bl ? Constants.TRANSPARENT_COLOR : this.getStandingBodyColor());
            graphics2D.fill(double_);
            graphics2D.setComposite(composite);
            if (bl) {
                Theme theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
                color = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : theme.getOutlineColor();
            } else {
                color = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : this.borderColor;
            }
            graphics2D.setColor(color);
            graphics2D.draw(double_);
            if (!bl) {
                this.drawLead(graphics2D, componentState);
            }
        } else {
            int n;
            Serializable serializable;
            Color color;
            Serializable serializable2;
            double d2;
            double d3;
            AffineTransform affineTransform;
            Rectangle rectangle = shape.getBounds();
            Double d4 = Math.atan2(this.points[1].y - this.points[0].y, this.points[1].x - this.points[0].x);
            if (!bl) {
                affineTransform = graphics2D.getTransform();
                int n2 = this.getClosestOdd(this.getLeadThickness());
                double d5 = (d - (double)this.calculatePinSpacing(rectangle)) / 2.0 - (double)(n2 / 2);
                graphics2D.setStroke(ObjectCache.getInstance().fetchBasicStroke(n2));
                Color color2 = this.shouldShadeLeads() ? this.getLeadColorForPainting(componentState).darker() : this.getLeadColorForPainting(componentState);
                graphics2D.setColor(color2);
                int n3 = (int)((double)this.points[0].x + Math.cos(d4) * d5);
                int n4 = (int)Math.round((double)this.points[0].y + Math.sin(d4) * d5);
                graphics2D.drawLine(this.points[0].x, this.points[0].y, n3, n4);
                n3 = (int)((double)this.points[1].x + Math.cos(d4 - Math.PI) * d5);
                n4 = (int)Math.round((double)this.points[1].y + Math.sin(d4 - Math.PI) * d5);
                graphics2D.drawLine(this.points[1].x, this.points[1].y, n3, n4);
                if (this.shouldShadeLeads()) {
                    graphics2D.setStroke(ObjectCache.getInstance().fetchBasicStroke(n2 - 2));
                    color2 = this.getLeadColorForPainting(componentState);
                    graphics2D.setColor(color2);
                    graphics2D.drawLine(this.points[0].x, this.points[0].y, (int)((double)this.points[0].x + Math.cos(d4) * d5), (int)((double)this.points[0].y + Math.sin(d4) * d5));
                    graphics2D.drawLine(this.points[1].x, this.points[1].y, (int)((double)this.points[1].x + Math.cos(d4 - Math.PI) * d5), (int)((double)this.points[1].y + Math.sin(d4 - Math.PI) * d5));
                }
                graphics2D.setTransform(affineTransform);
            }
            affineTransform = null;
            if (this.useShapeRectAsPosition()) {
                d3 = rectangle.getHeight();
                d2 = rectangle.getWidth();
            } else {
                d3 = this.getWidth().convertToPixels();
                d2 = this.getLength().convertToPixels();
            }
            affineTransform = graphics2D.getTransform();
            graphics2D.translate(((double)(this.points[0].x + this.points[1].x) - d2) / 2.0, ((double)(this.points[0].y + this.points[1].y) - d3) / 2.0);
            graphics2D.rotate(d4, d2 / 2.0, d3 / 2.0);
            Composite composite = graphics2D.getComposite();
            if (this.alpha < MAX_ALPHA) {
                graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / (float)MAX_ALPHA));
            }
            if (this.bodyColor != null && this.bodyColor != null) {
                graphics2D.setColor(bl ? Constants.TRANSPARENT_COLOR : this.bodyColor);
                graphics2D.fill(shape);
            }
            this.decorateComponentBody(graphics2D, bl);
            graphics2D.setComposite(composite);
            graphics2D.setStroke(ObjectCache.getInstance().fetchBasicStroke(1));
            if (bl) {
                serializable2 = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
                color = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : serializable2.getOutlineColor();
            } else {
                color = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : this.borderColor;
            }
            graphics2D.setColor(color);
            graphics2D.draw(shape);
            graphics2D.setFont(LABEL_FONT);
            if (this.useShapeRectAsPosition()) {
                graphics2D.translate(rectangle.x, rectangle.y);
            }
            if (bl) {
                serializable = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
                serializable2 = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? LABEL_COLOR_SELECTED : ((Theme)serializable).getOutlineColor();
            } else {
                serializable2 = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? LABEL_COLOR_SELECTED : this.labelColor;
            }
            graphics2D.setColor((Color)serializable2);
            serializable = graphics2D.getFontMetrics();
            String string = this.display == Display.NAME ? this.getName() : (this.getValue() == null ? "" : this.getValue().toString());
            Rectangle2D rectangle2D = ((FontMetrics)serializable).getStringBounds(string, graphics2D);
            int n5 = n = bl ? 0 : this.getLabelOffset((int)d2, (int)d3);
            if (d4 >= 1.5707963267948966 && d4 <= Math.PI || d4 < -1.5707963267948966 && d4 > -Math.PI) {
                graphics2D.rotate(Math.PI, d2 / 2.0, d3 / 2.0);
                n = -n;
            }
            graphics2D.drawString(string, (int)(d2 - rectangle2D.getWidth()) / 2 + n, this.calculateLabelYCoordinate(rectangle, rectangle2D, (FontMetrics)serializable));
            graphics2D.setTransform(affineTransform);
        }
    }

    private void drawLead(Graphics2D graphics2D, ComponentState componentState) {
        graphics2D.setStroke(ObjectCache.getInstance().fetchBasicStroke(this.getLeadThickness()));
        Color color = this.shouldShadeLeads() ? this.getLeadColorForPainting(componentState).darker() : this.getLeadColorForPainting(componentState);
        graphics2D.setColor(color);
        graphics2D.drawLine(this.points[0].x, this.points[0].y, this.points[1].x, this.points[1].y);
        if (this.shouldShadeLeads()) {
            graphics2D.setStroke(ObjectCache.getInstance().fetchBasicStroke(this.getLeadThickness() - 2));
            color = this.getLeadColorForPainting(componentState);
            graphics2D.setColor(color);
            graphics2D.drawLine(this.points[0].x, this.points[0].y, this.points[1].x, this.points[1].y);
        }
    }

    protected void decorateComponentBody(Graphics2D graphics2D, boolean bl) {
    }

    protected int calculateLabelYCoordinate(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, FontMetrics fontMetrics) {
        return (int)(rectangle2D.getHeight() - rectangle2D2.getHeight()) / 2 + fontMetrics.getAscent();
    }

    protected boolean shouldShadeLeads() {
        return true;
    }

    protected boolean supportsStandingMode() {
        return false;
    }

    protected int getLabelOffset(int n, int n2) {
        return 0;
    }

    protected abstract Size getDefaultLength();

    protected abstract Size getDefaultWidth();

    protected abstract Shape getBodyShape();

    protected boolean useShapeRectAsPosition() {
        return true;
    }

    protected int getLeadThickness() {
        return (int)LEAD_THICKNESS.convertToPixels();
    }

    protected Color getLeadColorForPainting(ComponentState componentState) {
        return componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : this.getLeadColor();
    }

    @EditableProperty(name="Lead color")
    public Color getLeadColor() {
        if (this.leadColor == null) {
            this.leadColor = LEAD_COLOR_ICON;
        }
        return this.leadColor;
    }

    public void setLeadColor(Color color) {
        this.leadColor = color;
    }

    protected int calculatePinSpacing(Rectangle rectangle) {
        return rectangle.width;
    }

    @Override
    public int getControlPointCount() {
        return this.points.length;
    }

    @Override
    public Point getControlPoint(int n) {
        return this.points[n];
    }

    @Override
    public boolean isControlPointSticky(int n) {
        return true;
    }

    @Override
    public VisibilityPolicy getControlPointVisibilityPolicy(int n) {
        return VisibilityPolicy.ALWAYS;
    }

    @Override
    public void setControlPoint(Point point, int n) {
        this.points[n].setLocation(point);
    }

    @EditableProperty(name="Color")
    public Color getBodyColor() {
        return this.bodyColor;
    }

    public void setBodyColor(Color color) {
        this.bodyColor = color;
    }

    public Color getStandingBodyColor() {
        return this.bodyColor;
    }

    @EditableProperty(name="Border")
    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    @EditableProperty(name="Length", defaultable=true)
    public Size getLength() {
        return this.length;
    }

    public void setLength(Size size) {
        this.length = size;
    }

    @EditableProperty(name="Width", defaultable=true)
    public Size getWidth() {
        return this.width;
    }

    public void setWidth(Size size) {
        this.width = size;
    }

    @EditableProperty
    public Display getDisplay() {
        return this.display;
    }

    public void setDisplay(Display display) {
        this.display = display;
    }

    @EditableProperty(name="Label color")
    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelColor(Color color) {
        this.labelColor = color;
    }

    public boolean getFlipStanding() {
        return this.flipStanding;
    }

    public void setFlipStanding(boolean bl) {
        this.flipStanding = bl;
    }
}

