/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swingframework;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;

public abstract class ButtonDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    public static final String OK = "OK";
    public static final String CANCEL = "Cancel";
    private JPanel containerPanel;
    private JPanel buttonPanel;
    private String[] buttonCaptions;
    private Map<String, JButton> buttonMap;
    private String selectedButtonCaption;

    public ButtonDialog(JFrame owner, String title, String[] buttonCaptions) {
        super((Frame)owner, title);
        this.setModal(true);
        this.setResizable(false);
        this.buttonCaptions = buttonCaptions;
        this.buttonMap = new HashMap<String, JButton>();
    }

    protected void layoutGui() {
        this.setContentPane(this.getContainerPanel());
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    public JButton getButton(String caption) {
        return this.buttonMap.get(caption);
    }

    public String getSelectedButtonCaption() {
        return this.selectedButtonCaption;
    }

    private JPanel getContainerPanel() {
        if (this.containerPanel == null) {
            this.containerPanel = new JPanel(new BorderLayout());
            this.containerPanel.add((Component)this.getMainComponent(), "Center");
            this.containerPanel.add((Component)this.getButtonPanel(), "South");
        }
        return this.containerPanel;
    }

    public JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            String[] arr$ = this.buttonCaptions;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String caption;
                final String command = caption = arr$[i$];
                JButton button = new JButton(caption);
                button.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (ButtonDialog.this.validateInput(command)) {
                            ButtonDialog.this.selectedButtonCaption = command;
                            ButtonDialog.this.setVisible(false);
                        }
                    }
                });
                this.buttonPanel.add(button);
                this.buttonMap.put(command, button);
            }
        }
        return this.buttonPanel;
    }

    protected abstract JComponent getMainComponent();

    protected boolean validateInput(String button) {
        return true;
    }
}

