/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Filter;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.TagDescription;
import com.amazon.aes.webservices.client.TagType;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class DeleteTags
extends BaseCmd {
    public DeleteTags(String[] args) {
        super("ec2deltag", "ec2-delete-tags");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    protected String getOptionString() {
        return "RESOURCE_ID [RESOURCE_ID ...] --tag KEY[=VALUE] [--tag KEY[=VALUE] ...]";
    }

    private Options getOptions() {
        Options o = new Options();
        OptionBuilder.withLongOpt((String)"tag");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"TAG");
        OptionBuilder.withDescription((String)"Tag in the form of key[=value].");
        o.addOption(OptionBuilder.create((String)"t"));
        return o;
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     Removes a set of tags from a set of resources. You only need to specify the tag key,");
        System.out.println("\t and not the value. If you do specify a value, and it is incorrect, the tag is not deleted. ");
    }

    public void printOptions() {
        super.printOptions(true);
        this.printOption("tag");
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.assertNonOptionSet("RESOURCE_ID");
        this.assertOptionSet("tag");
        List<String> resourceIds = Arrays.asList(this.getNonOptions());
        List<TagType> tags = this.getTags();
        HashSet matchedTags = new HashSet();
        for (TagType tag : tags) {
            ArrayList<Filter> filters = new ArrayList<Filter>();
            filters.add(new Filter("resource-id", resourceIds));
            filters.add(new Filter("key", tag.getKey()));
            if (tag.getValue(false) != null) {
                filters.add(new Filter("value", tag.getValue(false)));
            }
            RequestResultPair rsp = jec2.describeTags(filters);
            matchedTags.addAll((Collection)rsp.getResponse());
        }
        RequestResultPair rsp = jec2.deleteTags(resourceIds, tags);
        for (TagDescription tag : matchedTags) {
            out.outputTag(System.out, tag);
        }
        return true;
    }

    public static void main(String[] args) {
        new DeleteTags(args).invoke();
    }
}

